import { Styles } from "@magic-xpa/gui";
export class confirmationBox {
    static isConfirmBox(style) {
        let buttonMode = style & 0x0F;
        var isConfirm = (buttonMode === Styles.MSGBOX_BUTTON_OK_CANCEL) ||
            (buttonMode === Styles.MSGBOX_BUTTON_ABORT_RETRY_IGNORE) ||
            (buttonMode === Styles.MSGBOX_BUTTON_YES_NO_CANCEL) ||
            (buttonMode === Styles.MSGBOX_BUTTON_YES_NO) ||
            (buttonMode === Styles.MSGBOX_BUTTON_RETRY_CANCEL);
        return (isConfirm);
    }
    static convertToExcpectedResultBox(style, okWasPressed) {
        let buttonMode = style & 0x0F;
        let retValue = Styles.MSGBOX_RESULT_OK;
        if (buttonMode === Styles.MSGBOX_BUTTON_OK)
            retValue = Styles.MSGBOX_RESULT_OK;
        else if (buttonMode === Styles.MSGBOX_BUTTON_OK_CANCEL)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_OK : Styles.MSGBOX_RESULT_CANCEL;
        else if (buttonMode === Styles.MSGBOX_BUTTON_ABORT_RETRY_IGNORE)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_ABORT : Styles.MSGBOX_RESULT_RETRY;
        else if (buttonMode === Styles.MSGBOX_BUTTON_YES_NO_CANCEL)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_YES : Styles.MSGBOX_RESULT_NO;
        else if (buttonMode === Styles.MSGBOX_BUTTON_YES_NO)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_YES : Styles.MSGBOX_RESULT_NO;
        else if (buttonMode === Styles.MSGBOX_BUTTON_RETRY_CANCEL)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_RETRY : Styles.MSGBOX_RESULT_CANCEL;
        return retValue;
    }
    static showConfirmationBox(title, message, style) {
        let okWasPressed = false;
        let isConfirm = this.isConfirmBox(style);
        let titleAndString = title + '\n' + '\n' + message;
        if (isConfirm)
            okWasPressed = confirm(titleAndString);
        else {
            alert(titleAndString);
            okWasPressed = true;
        }
        return okWasPressed;
    }
}
//# sourceMappingURL=data:application/json;base64,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