import { Component, Input, Output, EventEmitter, ViewChild, ComponentFactoryResolver, ElementRef, Injector, ChangeDetectorRef, Compiler } from '@angular/core';
import { BaseMagicOverlayContainer } from "./base-magic-overlay-container";
import { BaseMagicConfirmComponent } from "../components/base-magic-confirm.component";
import { BaseMagicAlertComponent } from "../components/base-magic-alert.component";
import { OverlayType } from "@magic-xpa/gui";
import { ComponentListMagicService } from "../../services/component-list.magic.service";
import { isNullOrUndefined } from '@magic-xpa/mscorelib';
import { MagicLazyLoaderService } from '../../services/magic.lazy.loader.service';
import * as i0 from "@angular/core";
import * as i1 from "../../services/component-list.magic.service";
import * as i2 from "../../services/magic.lazy.loader.service";
import * as i3 from "../directives/magic-focus.directive";
import * as i4 from "../directives/magicViewContainerRef.directive";
const _c0 = ["overlayContainerWrapper"];
export class MagicOverlayContainerWrapper {
    constructor(componentListMagicService, magicLazyModuleLoader, injector, componentFactoryResolver, changeDetectorRef, compiler) {
        this.componentListMagicService = componentListMagicService;
        this.magicLazyModuleLoader = magicLazyModuleLoader;
        this.injector = injector;
        this.componentFactoryResolver = componentFactoryResolver;
        this.changeDetectorRef = changeDetectorRef;
        this.compiler = compiler;
        this.Component = null;
        this.Parameters = {};
        this.onClose = new EventEmitter();
    }
    ngOnInit() {
        let moduleRef = this.componentListMagicService.getModuleRef(this.Parameters.MagicFormName);
        if (moduleRef == null) {
            let lazyLoadModule = this.componentListMagicService.getLazyLoadModuleData(this.Parameters.MagicFormName);
            if (lazyLoadModule != null) {
                let moduleName = lazyLoadModule.moduleName.replace("Magic", "");
                moduleName = moduleName.replace("Module", "");
                this.magicLazyModuleLoader.Load(moduleName).then(m => {
                    const compiled = this.compiler.compileModuleAndAllComponentsSync(m[lazyLoadModule.moduleName]);
                    moduleRef = compiled.ngModuleFactory.create(this.injector);
                    this.loadComponent(moduleRef);
                });
            }
            else {
                this.loadComponent(null);
            }
        }
        else
            this.loadComponent(moduleRef);
    }
    loadComponent(moduleRef) {
        this.Parameters.ModalComp = this.componentListMagicService.getComponent(this.Parameters.MagicFormName, !isNullOrUndefined(this.Parameters.MagicFormName));
        let factory;
        if (moduleRef != null)
            factory = moduleRef.componentFactoryResolver.resolveComponentFactory(this.Component);
        else
            factory = this.componentFactoryResolver.resolveComponentFactory(this.Component);
        let componentRef = this.overlayContentViewContainerRef.createComponent(factory);
        let allowedBaseComp = MagicOverlayContainerWrapper.allowedBaseComps.get(this.OverlayTypeParam);
        if (componentRef.instance instanceof allowedBaseComp.comp) {
            Object.assign(componentRef.instance, this.Parameters);
            componentRef.instance.onClose.subscribe((res) => {
                this.onClose.emit(res);
            });
        }
        else {
            let msg = "Provided  window container should subclass of : " + allowedBaseComp.error + "window will not work properly.";
            alert(msg);
        }
    }
    setViewContainerRef(vcRef) {
        this.overlayContentViewContainerRef = vcRef;
    }
    GetRootElement() {
        return this.overlayContainerWrapperElementRef.nativeElement;
    }
    DetectChanges() {
        this.changeDetectorRef.detectChanges();
    }
}
MagicOverlayContainerWrapper.allowedBaseComps = new Map([
    [OverlayType.Overlay, { comp: BaseMagicOverlayContainer, error: 'BaseMagicOverlayContainer . Overlay ' }],
    [OverlayType.Alert, { comp: BaseMagicAlertComponent, error: 'BaseMagicAlertComponent. Alert ' }],
    [OverlayType.ConfirmationBox, { comp: BaseMagicConfirmComponent, error: 'BaseMagicConfirmComponent. Confirmation ' }]
]);
MagicOverlayContainerWrapper.ɵfac = function MagicOverlayContainerWrapper_Factory(t) { return new (t || MagicOverlayContainerWrapper)(i0.ɵɵdirectiveInject(i1.ComponentListMagicService), i0.ɵɵdirectiveInject(i2.MagicLazyLoaderService), i0.ɵɵdirectiveInject(i0.Injector), i0.ɵɵdirectiveInject(i0.ComponentFactoryResolver), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i0.Compiler)); };
MagicOverlayContainerWrapper.ɵcmp = i0.ɵɵdefineComponent({ type: MagicOverlayContainerWrapper, selectors: [["app-magic-overlay-container-wrapper"]], viewQuery: function MagicOverlayContainerWrapper_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0, 7);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.overlayContainerWrapperElementRef = _t.first);
    } }, inputs: { Component: "Component", Parameters: "Parameters", OverlayTypeParam: "OverlayTypeParam" }, outputs: { onClose: "onClose" }, decls: 7, vars: 0, consts: [["tabIndex", "0", "magicFocus", "", 1, "overlay-container-wrapper-background", 2, "width", "0px", "height", "0px"], [1, "overlay-container-wrapper-background"], ["overlayContainerWrapper", ""], ["magicViewContainerRef", ""], ["overlayContent", ""], ["tabIndex", "0", 1, "overlay-container-wrapper-background", 2, "width", "0px", "height", "0px"]], template: function MagicOverlayContainerWrapper_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div");
        i0.ɵɵelement(1, "div", 0);
        i0.ɵɵelementStart(2, "div", 1, 2);
        i0.ɵɵelement(4, "div", 3, 4);
        i0.ɵɵelementEnd();
        i0.ɵɵelement(6, "div", 5);
        i0.ɵɵelementEnd();
    } }, dependencies: [i3.MagicFocusDirective, i4.MagicViewContainerRef], styles: [".overlay-container-wrapper-background[_ngcontent-%COMP%]{position:fixed;z-index:999;inset:0}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicOverlayContainerWrapper, [{
        type: Component,
        args: [{ selector: 'app-magic-overlay-container-wrapper', template: `
    <div>
      <div class="overlay-container-wrapper-background" tabIndex="0" style="width: 0px; height: 0px;" magicFocus></div>
      <div class="overlay-container-wrapper-background" #overlayContainerWrapper>
        <div #overlayContent magicViewContainerRef>
        </div>
      </div>
      <div class="overlay-container-wrapper-background" tabIndex="0" style="width: 0px; height: 0px;" ></div>
    </div>
  `, styles: [".overlay-container-wrapper-background{position:fixed;z-index:999;inset:0}\n"] }]
    }], function () { return [{ type: i1.ComponentListMagicService }, { type: i2.MagicLazyLoaderService }, { type: i0.Injector }, { type: i0.ComponentFactoryResolver }, { type: i0.ChangeDetectorRef }, { type: i0.Compiler }]; }, { Component: [{
            type: Input
        }], Parameters: [{
            type: Input
        }], OverlayTypeParam: [{
            type: Input
        }], onClose: [{
            type: Output
        }], overlayContainerWrapperElementRef: [{
            type: ViewChild,
            args: ['overlayContainerWrapper', { static: true }]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFnaWMtb3ZlcmxheS1jb250YWluZXItd3JhcHBlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2FuZ3VsYXIvc3JjL3VpL21hZ2ljLW1vZGFsL21hZ2ljLW92ZXJsYXktY29udGFpbmVyLXdyYXBwZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUNMLFNBQVMsRUFDVCxLQUFLLEVBQ0wsTUFBTSxFQUNOLFlBQVksRUFDWixTQUFTLEVBRVQsd0JBQXdCLEVBQ3hCLFVBQVUsRUFDVixRQUFRLEVBQUUsaUJBQWlCLEVBQUUsUUFBUSxFQUN0QyxNQUFNLGVBQWUsQ0FBQztBQUN2QixPQUFPLEVBQUUseUJBQXlCLEVBQUUsTUFBTSxnQ0FBZ0MsQ0FBQztBQUMzRSxPQUFPLEVBQUUseUJBQXlCLEVBQUUsTUFBTSw0Q0FBNEMsQ0FBQztBQUN2RixPQUFPLEVBQUUsdUJBQXVCLEVBQUUsTUFBTSwwQ0FBMEMsQ0FBQztBQUNuRixPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDN0MsT0FBTyxFQUFFLHlCQUF5QixFQUFjLE1BQU0sNkNBQTZDLENBQUM7QUFFcEcsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFDdkQsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sMENBQTBDLENBQUM7Ozs7Ozs7QUEyQmxGLE1BQU0sT0FBTyw0QkFBNEI7SUFrQ3ZDLFlBQW9CLHlCQUFvRCxFQUNwRCxxQkFBNkMsRUFDN0MsUUFBa0IsRUFDNUIsd0JBQWtELEVBQ3hDLGlCQUFtQyxFQUNuQyxRQUFrQjtRQUxsQiw4QkFBeUIsR0FBekIseUJBQXlCLENBQTJCO1FBQ3BELDBCQUFxQixHQUFyQixxQkFBcUIsQ0FBd0I7UUFDN0MsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQUM1Qiw2QkFBd0IsR0FBeEIsd0JBQXdCLENBQTBCO1FBQ3hDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBa0I7UUFDbkMsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQW5DdEIsY0FBUyxHQUFHLElBQUksQ0FBQztRQUlqQixlQUFVLEdBQVEsRUFBRSxDQUFDO1FBSW5CLFlBQU8sR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO0lBNEJyRCxDQUFDO0lBS0QsUUFBUTtRQUNOLElBQUksU0FBUyxHQUFxQixJQUFJLENBQUMseUJBQXlCLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFN0csSUFBSSxTQUFTLElBQUksSUFBSSxFQUFFO1lBQ3JCLElBQUksY0FBYyxHQUFlLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBRXJILElBQUksY0FBYyxJQUFJLElBQUksRUFBRTtnQkFDMUIsSUFBSSxVQUFVLEdBQUcsY0FBYyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUNoRSxVQUFVLEdBQUcsVUFBVSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQzlDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFO29CQUNuRCxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGlDQUFpQyxDQUFNLENBQUMsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztvQkFDcEcsU0FBUyxHQUFHLFFBQVEsQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztvQkFDM0QsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQztnQkFDaEMsQ0FBQyxDQUFDLENBQUM7YUFDSjtpQkFDSTtnQkFDSCxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQzFCO1NBQ0Y7O1lBQ0MsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRU8sYUFBYSxDQUFDLFNBQTJCO1FBQy9DLElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFFMUosSUFBSSxPQUFPLENBQUM7UUFDWixJQUFJLFNBQVMsSUFBSSxJQUFJO1lBQ25CLE9BQU8sR0FBRyxTQUFTLENBQUMsd0JBQXdCLENBQUMsdUJBQXVCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDOztZQUVyRixPQUFPLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixDQUFDLHVCQUF1QixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUVsRixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsOEJBQThCLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ2hGLElBQUksZUFBZSxHQUFHLDRCQUE0QixDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUcvRixJQUFJLFlBQVksQ0FBQyxRQUFRLFlBQVksZUFBZSxDQUFDLElBQUksRUFBRTtZQUN6RCxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ2hELFlBQVksQ0FBQyxRQUFTLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFO2dCQUNyRCxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUN6QixDQUFDLENBQUMsQ0FBQztTQUNKO2FBQU07WUFDTCxJQUFJLEdBQUcsR0FBRyxrREFBa0QsR0FBRyxlQUFlLENBQUMsS0FBSyxHQUFHLGdDQUFnQyxDQUFDO1lBQ3hILEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUNaO0lBQ0gsQ0FBQztJQUVELG1CQUFtQixDQUFDLEtBQXVCO1FBQ3pDLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxLQUFLLENBQUM7SUFDOUMsQ0FBQztJQUVELGNBQWM7UUFDWixPQUFPLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQyxhQUFhLENBQUM7SUFDOUQsQ0FBQztJQUVELGFBQWE7UUFFWCxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekMsQ0FBQzs7QUE3RU0sNkNBQWdCLEdBQUcsSUFBSSxHQUFHLENBQXFDO0lBQ3BFLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxFQUFDLElBQUksRUFBRSx5QkFBeUIsRUFBRSxLQUFLLEVBQUMsc0NBQXNDLEVBQUMsQ0FBQztJQUN0RyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsRUFBQyxJQUFJLEVBQUUsdUJBQXVCLEVBQUUsS0FBSyxFQUFDLGlDQUFpQyxFQUFDLENBQUM7SUFDN0YsQ0FBQyxXQUFXLENBQUMsZUFBZSxFQUFHLEVBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFLEtBQUssRUFBRSwwQ0FBMEMsRUFBQyxDQUFDO0NBQ3JILENBQUMsQ0FBQzt3R0E3QlEsNEJBQTRCO2lFQUE1Qiw0QkFBNEI7Ozs7OztRQXJCckMsMkJBQUs7UUFDSCx5QkFBaUg7UUFDakgsaUNBQTJFO1FBQ3pFLDRCQUNNO1FBQ1IsaUJBQU07UUFDTix5QkFBdUc7UUFDekcsaUJBQU07O3VGQWNHLDRCQUE0QjtjQXhCeEMsU0FBUzsyQkFDRSxxQ0FBcUMsWUFDckM7Ozs7Ozs7OztHQVNUO3NPQWlCZSxTQUFTO2tCQUF4QixLQUFLO1lBSVUsVUFBVTtrQkFBekIsS0FBSztZQUVXLGdCQUFnQjtrQkFBaEMsS0FBSztZQUVZLE9BQU87a0JBQXhCLE1BQU07WUFPaUQsaUNBQWlDO2tCQUF4RixTQUFTO21CQUFDLHlCQUF5QixFQUFFLEVBQUUsTUFBTSxFQUFFLElBQUksRUFBRSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XHJcbiAgQ29tcG9uZW50LFxyXG4gIElucHV0LFxyXG4gIE91dHB1dCxcclxuICBFdmVudEVtaXR0ZXIsXHJcbiAgVmlld0NoaWxkLFxyXG4gIFZpZXdDb250YWluZXJSZWYsXHJcbiAgQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyLFxyXG4gIEVsZW1lbnRSZWYsIE5nTW9kdWxlUmVmLFxyXG4gIEluamVjdG9yLCBDaGFuZ2VEZXRlY3RvclJlZiwgQ29tcGlsZXJcclxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgQmFzZU1hZ2ljT3ZlcmxheUNvbnRhaW5lciB9IGZyb20gXCIuL2Jhc2UtbWFnaWMtb3ZlcmxheS1jb250YWluZXJcIjtcclxuaW1wb3J0IHsgQmFzZU1hZ2ljQ29uZmlybUNvbXBvbmVudCB9IGZyb20gXCIuLi9jb21wb25lbnRzL2Jhc2UtbWFnaWMtY29uZmlybS5jb21wb25lbnRcIjtcclxuaW1wb3J0IHsgQmFzZU1hZ2ljQWxlcnRDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50cy9iYXNlLW1hZ2ljLWFsZXJ0LmNvbXBvbmVudFwiO1xyXG5pbXBvcnQgeyBPdmVybGF5VHlwZSB9IGZyb20gXCJAbWFnaWMteHBhL2d1aVwiO1xyXG5pbXBvcnQgeyBDb21wb25lbnRMaXN0TWFnaWNTZXJ2aWNlLCBNb2R1bGVEYXRhIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL2NvbXBvbmVudC1saXN0Lm1hZ2ljLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgSU1hZ2ljVmlld0NvbnRhaW5lclJlZiB9IGZyb20gXCIuLi8uLi8uLlwiO1xyXG5pbXBvcnQge2lzTnVsbE9yVW5kZWZpbmVkfSBmcm9tICdAbWFnaWMteHBhL21zY29yZWxpYic7XHJcbmltcG9ydCB7IE1hZ2ljTGF6eUxvYWRlclNlcnZpY2UgfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy9tYWdpYy5sYXp5LmxvYWRlci5zZXJ2aWNlJztcclxuXHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ2FwcC1tYWdpYy1vdmVybGF5LWNvbnRhaW5lci13cmFwcGVyJyxcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgPGRpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cIm92ZXJsYXktY29udGFpbmVyLXdyYXBwZXItYmFja2dyb3VuZFwiIHRhYkluZGV4PVwiMFwiIHN0eWxlPVwid2lkdGg6IDBweDsgaGVpZ2h0OiAwcHg7XCIgbWFnaWNGb2N1cz48L2Rpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cIm92ZXJsYXktY29udGFpbmVyLXdyYXBwZXItYmFja2dyb3VuZFwiICNvdmVybGF5Q29udGFpbmVyV3JhcHBlcj5cclxuICAgICAgICA8ZGl2ICNvdmVybGF5Q29udGVudCBtYWdpY1ZpZXdDb250YWluZXJSZWY+XHJcbiAgICAgICAgPC9kaXY+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgICA8ZGl2IGNsYXNzPVwib3ZlcmxheS1jb250YWluZXItd3JhcHBlci1iYWNrZ3JvdW5kXCIgdGFiSW5kZXg9XCIwXCIgc3R5bGU9XCJ3aWR0aDogMHB4OyBoZWlnaHQ6IDBweDtcIiA+PC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICBgLFxyXG4gIHN0eWxlczogW2BcclxuICAgIC5vdmVybGF5LWNvbnRhaW5lci13cmFwcGVyLWJhY2tncm91bmQge1xyXG4gICAgICAvKiBtb2RhbCBiYWNrZ3JvdW5kIGZpeGVkIGFjcm9zcyB3aG9sZSBzY3JlZW4gKi9cclxuICAgICAgcG9zaXRpb246IGZpeGVkO1xyXG4gICAgICB0b3A6IDA7XHJcbiAgICAgIHotaW5kZXg6IDk5OTtcclxuICAgICAgcmlnaHQ6IDA7XHJcbiAgICAgIGJvdHRvbTogMDtcclxuICAgICAgbGVmdDogMDtcclxuICAgIH1cclxuICBgXVxyXG59KVxyXG5leHBvcnQgY2xhc3MgTWFnaWNPdmVybGF5Q29udGFpbmVyV3JhcHBlciAgaW1wbGVtZW50cyBJTWFnaWNWaWV3Q29udGFpbmVyUmVmIHtcclxuICAvKipcclxuICAgKlxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHB1YmxpYyBDb21wb25lbnQgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqXHJcbiAgICovXHJcbiAgQElucHV0KCkgcHVibGljIFBhcmFtZXRlcnM6IGFueSA9IHt9O1xyXG5cclxuICBASW5wdXQoKSBwcml2YXRlIE92ZXJsYXlUeXBlUGFyYW06IE92ZXJsYXlUeXBlO1xyXG5cclxuICBAT3V0cHV0KCkgcHJpdmF0ZSBvbkNsb3NlID0gbmV3IEV2ZW50RW1pdHRlcjx2b2lkPigpO1xyXG5cclxuICAvKipcclxuICAgKiBIVE1MIHRvIGJlIGRpc3BsYXllZCBpbiB0aGUgbW9kYWwgd2luZG93XHJcbiAgICovXHJcbiAgb3ZlcmxheUNvbnRlbnRWaWV3Q29udGFpbmVyUmVmOiBWaWV3Q29udGFpbmVyUmVmO1xyXG5cclxuICBAVmlld0NoaWxkKCdvdmVybGF5Q29udGFpbmVyV3JhcHBlcicsIHsgc3RhdGljOiB0cnVlIH0pIG92ZXJsYXlDb250YWluZXJXcmFwcGVyRWxlbWVudFJlZjogRWxlbWVudFJlZjtcclxuXHJcbiAgLyoqXHJcbiAgICogQGlnbm9yZVxyXG4gICAqIGNvbnRhaXMgZGF0YSBvZiBhbGxvd2VkIGJhc2UgY29tcG9uZW50cyB0byB1c2VcclxuICAgKi9cclxuICBzdGF0aWMgYWxsb3dlZEJhc2VDb21wcyA9IG5ldyBNYXA8bnVtYmVyLCB7Y29tcDogYW55LCBlcnJvcjogc3RyaW5nfT4oW1xyXG4gICAgW092ZXJsYXlUeXBlLk92ZXJsYXksIHtjb21wOiBCYXNlTWFnaWNPdmVybGF5Q29udGFpbmVyLCBlcnJvcjonQmFzZU1hZ2ljT3ZlcmxheUNvbnRhaW5lciAuIE92ZXJsYXkgJ31dLFxyXG4gICAgW092ZXJsYXlUeXBlLkFsZXJ0LCB7Y29tcDogQmFzZU1hZ2ljQWxlcnRDb21wb25lbnQsIGVycm9yOidCYXNlTWFnaWNBbGVydENvbXBvbmVudC4gQWxlcnQgJ31dLFxyXG4gICAgW092ZXJsYXlUeXBlLkNvbmZpcm1hdGlvbkJveCwgIHtjb21wOiBCYXNlTWFnaWNDb25maXJtQ29tcG9uZW50LCBlcnJvciA6J0Jhc2VNYWdpY0NvbmZpcm1Db21wb25lbnQuIENvbmZpcm1hdGlvbiAnfV1cclxuICBdKTtcclxuICAvKipcclxuICAgKlxyXG4gICAqIEBwYXJhbSBjb21wb25lbnRGYWN0b3J5UmVzb2x2ZXJcclxuICAgKi9cclxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIGNvbXBvbmVudExpc3RNYWdpY1NlcnZpY2U6IENvbXBvbmVudExpc3RNYWdpY1NlcnZpY2UsXHJcbiAgICAgICAgICAgICAgcHJpdmF0ZSBtYWdpY0xhenlNb2R1bGVMb2FkZXI6IE1hZ2ljTGF6eUxvYWRlclNlcnZpY2UsXHJcbiAgICAgICAgICAgICAgcHJpdmF0ZSBpbmplY3RvcjogSW5qZWN0b3IsXHJcbiAgICBwcml2YXRlIGNvbXBvbmVudEZhY3RvcnlSZXNvbHZlcjogQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyLFxyXG4gICAgICAgICAgICAgIHByaXZhdGUgY2hhbmdlRGV0ZWN0b3JSZWY6Q2hhbmdlRGV0ZWN0b3JSZWYsXHJcbiAgICAgICAgICAgICAgcHJpdmF0ZSBjb21waWxlcjogQ29tcGlsZXIpIHtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqXHJcbiAgICovXHJcbiAgbmdPbkluaXQoKSB7XHJcbiAgICBsZXQgbW9kdWxlUmVmOiBOZ01vZHVsZVJlZjxhbnk+ID0gdGhpcy5jb21wb25lbnRMaXN0TWFnaWNTZXJ2aWNlLmdldE1vZHVsZVJlZih0aGlzLlBhcmFtZXRlcnMuTWFnaWNGb3JtTmFtZSk7XHJcblxyXG4gICAgaWYgKG1vZHVsZVJlZiA9PSBudWxsKSB7XHJcbiAgICAgIGxldCBsYXp5TG9hZE1vZHVsZTogTW9kdWxlRGF0YSA9IHRoaXMuY29tcG9uZW50TGlzdE1hZ2ljU2VydmljZS5nZXRMYXp5TG9hZE1vZHVsZURhdGEodGhpcy5QYXJhbWV0ZXJzLk1hZ2ljRm9ybU5hbWUpO1xyXG5cclxuICAgICAgaWYgKGxhenlMb2FkTW9kdWxlICE9IG51bGwpIHtcclxuICAgICAgICBsZXQgbW9kdWxlTmFtZSA9IGxhenlMb2FkTW9kdWxlLm1vZHVsZU5hbWUucmVwbGFjZShcIk1hZ2ljXCIsIFwiXCIpO1xyXG4gICAgICAgIG1vZHVsZU5hbWUgPSBtb2R1bGVOYW1lLnJlcGxhY2UoXCJNb2R1bGVcIiwgXCJcIik7XHJcbiAgICAgICAgdGhpcy5tYWdpY0xhenlNb2R1bGVMb2FkZXIuTG9hZChtb2R1bGVOYW1lKS50aGVuKG0gPT4ge1xyXG4gICAgICAgICAgY29uc3QgY29tcGlsZWQgPSB0aGlzLmNvbXBpbGVyLmNvbXBpbGVNb2R1bGVBbmRBbGxDb21wb25lbnRzU3luYyg8YW55Pm1bbGF6eUxvYWRNb2R1bGUubW9kdWxlTmFtZV0pO1xyXG4gICAgICAgICAgbW9kdWxlUmVmID0gY29tcGlsZWQubmdNb2R1bGVGYWN0b3J5LmNyZWF0ZSh0aGlzLmluamVjdG9yKTtcclxuICAgICAgICAgIHRoaXMubG9hZENvbXBvbmVudChtb2R1bGVSZWYpO1xyXG4gICAgICAgIH0pO1xyXG4gICAgICB9XHJcbiAgICAgIGVsc2Uge1xyXG4gICAgICAgIHRoaXMubG9hZENvbXBvbmVudChudWxsKTtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlXHJcbiAgICAgIHRoaXMubG9hZENvbXBvbmVudChtb2R1bGVSZWYpO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBsb2FkQ29tcG9uZW50KG1vZHVsZVJlZjogTmdNb2R1bGVSZWY8YW55Pikge1xyXG4gICAgdGhpcy5QYXJhbWV0ZXJzLk1vZGFsQ29tcCA9IHRoaXMuY29tcG9uZW50TGlzdE1hZ2ljU2VydmljZS5nZXRDb21wb25lbnQodGhpcy5QYXJhbWV0ZXJzLk1hZ2ljRm9ybU5hbWUsICFpc051bGxPclVuZGVmaW5lZCh0aGlzLlBhcmFtZXRlcnMuTWFnaWNGb3JtTmFtZSkpO1xyXG5cclxuICAgIGxldCBmYWN0b3J5O1xyXG4gICAgaWYgKG1vZHVsZVJlZiAhPSBudWxsKVxyXG4gICAgICBmYWN0b3J5ID0gbW9kdWxlUmVmLmNvbXBvbmVudEZhY3RvcnlSZXNvbHZlci5yZXNvbHZlQ29tcG9uZW50RmFjdG9yeSh0aGlzLkNvbXBvbmVudCk7XHJcbiAgICBlbHNlXHJcbiAgICAgIGZhY3RvcnkgPSB0aGlzLmNvbXBvbmVudEZhY3RvcnlSZXNvbHZlci5yZXNvbHZlQ29tcG9uZW50RmFjdG9yeSh0aGlzLkNvbXBvbmVudCk7XHJcblxyXG4gICAgbGV0IGNvbXBvbmVudFJlZiA9IHRoaXMub3ZlcmxheUNvbnRlbnRWaWV3Q29udGFpbmVyUmVmLmNyZWF0ZUNvbXBvbmVudChmYWN0b3J5KTtcclxuICAgIGxldCBhbGxvd2VkQmFzZUNvbXAgPSBNYWdpY092ZXJsYXlDb250YWluZXJXcmFwcGVyLmFsbG93ZWRCYXNlQ29tcHMuZ2V0KHRoaXMuT3ZlcmxheVR5cGVQYXJhbSk7XHJcblxyXG5cclxuICAgIGlmIChjb21wb25lbnRSZWYuaW5zdGFuY2UgaW5zdGFuY2VvZiBhbGxvd2VkQmFzZUNvbXAuY29tcCkge1xyXG4gICAgICBPYmplY3QuYXNzaWduKGNvbXBvbmVudFJlZi5pbnN0YW5jZSwgdGhpcy5QYXJhbWV0ZXJzKTtcclxuICAgICAgKDxhbnk+Y29tcG9uZW50UmVmLmluc3RhbmNlKS5vbkNsb3NlLnN1YnNjcmliZSgocmVzKSA9PiB7XHJcbiAgICAgICAgdGhpcy5vbkNsb3NlLmVtaXQocmVzKTtcclxuICAgICAgfSk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICBsZXQgbXNnID0gXCJQcm92aWRlZCAgd2luZG93IGNvbnRhaW5lciBzaG91bGQgc3ViY2xhc3Mgb2YgOiBcIiArIGFsbG93ZWRCYXNlQ29tcC5lcnJvciArIFwid2luZG93IHdpbGwgbm90IHdvcmsgcHJvcGVybHkuXCI7XHJcbiAgICAgIGFsZXJ0KG1zZyk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBzZXRWaWV3Q29udGFpbmVyUmVmKHZjUmVmOiBWaWV3Q29udGFpbmVyUmVmKXtcclxuICAgIHRoaXMub3ZlcmxheUNvbnRlbnRWaWV3Q29udGFpbmVyUmVmID0gdmNSZWY7XHJcbiAgfVxyXG5cclxuICBHZXRSb290RWxlbWVudCgpOiBIVE1MRWxlbWVudCB7XHJcbiAgICByZXR1cm4gdGhpcy5vdmVybGF5Q29udGFpbmVyV3JhcHBlckVsZW1lbnRSZWYubmF0aXZlRWxlbWVudDtcclxuICB9XHJcblxyXG4gIERldGVjdENoYW5nZXMoKVxyXG4gIHtcclxuICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JSZWYuZGV0ZWN0Q2hhbmdlcygpO1xyXG4gIH1cclxufVxyXG4iXX0=