import { Component, ComponentFactoryResolver, ElementRef, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { isNullOrUndefined } from '@magic-xpa/mscorelib';
import { BaseMagicOverlayContainer } from './base-magic-overlay-container';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "../directives/magicViewContainerRef.directive";
const _c0 = ["modalheader"];
const _c1 = ["modalForeground"];
function MagicOverlayContainer_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 8);
    i0.ɵɵlistener("click", function MagicOverlayContainer_button_2_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r4 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r4.OnClose()); });
    i0.ɵɵtext(1, "X");
    i0.ɵɵelementEnd();
} }
function MagicOverlayContainer_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r8 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 9, 10);
    i0.ɵɵtext(2);
    i0.ɵɵelementStart(3, "button", 11);
    i0.ɵɵlistener("click", function MagicOverlayContainer_div_5_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r8); const ctx_r7 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r7.OnClose()); });
    i0.ɵɵtext(4, "X");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", ctx_r2.getText(), " ");
} }
export class MagicOverlayContainer extends BaseMagicOverlayContainer {
    constructor(componentFactoryResolver) {
        super();
        this.componentFactoryResolver = componentFactoryResolver;
        this.ModalComp = null;
        this.ModalCompParameters = {};
        this.onClose = new EventEmitter();
        this.componentRef = null;
    }
    ngOnInit() {
        const factory = this.componentFactoryResolver.resolveComponentFactory(this.ModalComp);
        this.componentRef = this.modalbodyViewContainerRef.createComponent(factory);
        Object.assign(this.componentRef.instance, this.ModalCompParameters);
    }
    setViewContainerRef(vcRef) {
        this.modalbodyViewContainerRef = vcRef;
    }
    getText() {
        if (this.componentRef !== null) {
            let comp = this.componentRef.instance;
            return comp.FormName();
        }
        else
            return '';
    }
    getStyle() {
        let styles = {};
        if (this.componentRef != undefined) {
            let comp = this.componentRef.instance;
            styles['width'] = comp.Width();
            styles['height'] = comp.Height();
            if (comp.IsCenteredToWindow()) {
                styles['margin'] = 'auto';
            }
            else {
                styles['margin-left'] = comp.X() + 'px';
                styles['margin-top'] = comp.Y() + 'px';
            }
        }
        return styles;
    }
    getClientAreaStyles() {
        let styles = {};
        if (this.componentRef != undefined) {
            const headerHeight = this.getShowTitleBar() && !isNullOrUndefined(this.headerElementRef) ? (this.headerElementRef.nativeElement.offsetHeight + 1) : 0;
            if (!isNullOrUndefined(this.foregroundElementRef)) {
                const foregroundHeight = this.foregroundElementRef.nativeElement.offsetHeight;
                styles['height'] = (foregroundHeight - headerHeight) + 'px';
                const foregroundWidth = this.foregroundElementRef.nativeElement.offsetWidth;
                styles['width'] = (foregroundWidth) + 'px';
            }
            styles['overflow'] = 'auto';
        }
        return styles;
    }
    getShowTitleBar() {
        if (this.componentRef != undefined) {
            let comp = this.componentRef.instance;
            return comp.ShowTitleBar();
        }
    }
    OnClose() {
        this.onClose.emit();
    }
    OnBackgroundClick() {
        let comp = this.componentRef.instance;
        if (comp.ShouldCloseOnBackgroundClick())
            this.OnClose();
    }
}
MagicOverlayContainer.ɵfac = function MagicOverlayContainer_Factory(t) { return new (t || MagicOverlayContainer)(i0.ɵɵdirectiveInject(i0.ComponentFactoryResolver)); };
MagicOverlayContainer.ɵcmp = i0.ɵɵdefineComponent({ type: MagicOverlayContainer, selectors: [["app-magic-overlay-container"]], viewQuery: function MagicOverlayContainer_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0, 5);
        i0.ɵɵviewQuery(_c1, 5);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.headerElementRef = _t.first);
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.foregroundElementRef = _t.first);
    } }, inputs: { ModalComp: "ModalComp", ModalCompParameters: "ModalCompParameters" }, outputs: { onClose: "onClose" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 9, vars: 4, consts: [[1, "modal-background", 3, "click"], ["tabindex", "-1", "style", "float:right; border: none; background-color: transparent; outline: none; color: white", 3, "click", 4, "ngIf"], [1, "modal-foreground", 3, "ngStyle"], ["modalForeground", ""], ["class", "modal-header", 4, "ngIf"], [3, "ngStyle"], ["magicViewContainerRef", ""], ["modalbody", ""], ["tabindex", "-1", 2, "float", "right", "border", "none", "background-color", "transparent", "outline", "none", "color", "white", 3, "click"], [1, "modal-header"], ["modalheader", ""], ["tabindex", "-1", 2, "float", "right", 3, "click"]], template: function MagicOverlayContainer_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div")(1, "div", 0);
        i0.ɵɵlistener("click", function MagicOverlayContainer_Template_div_click_1_listener() { return ctx.OnBackgroundClick(); });
        i0.ɵɵtemplate(2, MagicOverlayContainer_button_2_Template, 2, 0, "button", 1);
        i0.ɵɵelementEnd();
        i0.ɵɵelementStart(3, "div", 2, 3);
        i0.ɵɵtemplate(5, MagicOverlayContainer_div_5_Template, 5, 1, "div", 4);
        i0.ɵɵelementStart(6, "div", 5);
        i0.ɵɵelement(7, "div", 6, 7);
        i0.ɵɵelementEnd()()();
    } if (rf & 2) {
        i0.ɵɵadvance(2);
        i0.ɵɵproperty("ngIf", !ctx.getShowTitleBar());
        i0.ɵɵadvance(1);
        i0.ɵɵproperty("ngStyle", ctx.getStyle());
        i0.ɵɵadvance(2);
        i0.ɵɵproperty("ngIf", ctx.getShowTitleBar());
        i0.ɵɵadvance(1);
        i0.ɵɵproperty("ngStyle", ctx.getClientAreaStyles());
    } }, dependencies: [i1.NgIf, i1.NgStyle, i2.MagicViewContainerRef], styles: [".modal-foreground[_ngcontent-%COMP%]{position:fixed;inset:0;background-color:#fff}.modal-background[_ngcontent-%COMP%]{position:fixed;inset:0;background-color:#000;opacity:.75}.modal-header[_ngcontent-%COMP%]{background-color:beige;border-bottom:2px solid red}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicOverlayContainer, [{
        type: Component,
        args: [{ selector: 'app-magic-overlay-container', template: `
    <div>
      <div class="modal-background" (click)="OnBackgroundClick()">
        <button (click)="OnClose()" tabindex="-1" style="float:right; border: none; background-color: transparent; outline: none; color: white" *ngIf="!getShowTitleBar()">X</button>
      </div>
      <div #modalForeground class="modal-foreground" [ngStyle]="getStyle()">
        <div #modalheader class="modal-header" *ngIf="getShowTitleBar()">
          {{getText()}}
          <button (click)="OnClose()" style="float:right" tabindex="-1">X</button>
        </div>
        <div [ngStyle]="getClientAreaStyles()">
          <div #modalbody magicViewContainerRef>
          </div>
        </div>
      </div>
    </div>
  `, styles: [".modal-foreground{position:fixed;inset:0;background-color:#fff}.modal-background{position:fixed;inset:0;background-color:#000;opacity:.75}.modal-header{background-color:beige;border-bottom:2px solid red}\n"] }]
    }], function () { return [{ type: i0.ComponentFactoryResolver }]; }, { headerElementRef: [{
            type: ViewChild,
            args: ['modalheader', { static: false }]
        }], foregroundElementRef: [{
            type: ViewChild,
            args: ['modalForeground', { static: false }]
        }], ModalComp: [{
            type: Input
        }], ModalCompParameters: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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