import { ChangeDetectorRef, Component, ElementRef, HostListener, Input, Optional, TemplateRef, ViewChild } from '@angular/core';
import { CommandType } from '@magic-xpa/gui';
import { Title } from '@angular/platform-browser';
import { EngineMagicService } from '../services/engine.magic.service';
import { ComponentListMagicService } from '../services/component-list.magic.service';
import { GuiInteractiveExecutor } from './GuiInteractiveExecutor';
import { filter } from 'rxjs/operators';
import { ExitMagicService } from '../services/exit.magic.service';
import { OverlayWindowService } from '../services/OverlayWindowService';
import { CommandsCollectorMagicService } from '../services/commands-collector.magic.service';
import { HttpClient } from '@angular/common/http';
import * as i0 from "@angular/core";
import * as i1 from "../services/engine.magic.service";
import * as i2 from "../services/component-list.magic.service";
import * as i3 from "@angular/platform-browser";
import * as i4 from "../services/OverlayWindowService";
import * as i5 from "@angular/common/http";
import * as i6 from "../services/commands-collector.magic.service";
import * as i7 from "../services/exit.magic.service";
import * as i8 from "@angular/common";
import * as i9 from "ng-dynamic-component";
import * as i10 from "./directives/magicViewContainerRef.directive";
const _c0 = ["magicRoot"];
function MagicShellComponent_ndc_dynamic_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "ndc-dynamic", 6);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r1.RootComponent)("ndcDynamicInputs", ctx_r1.RootComponentParameters);
} }
function MagicShellComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7);
    i0.ɵɵelementContainer(1, 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext();
    const _r4 = i0.ɵɵreference(7);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngTemplateOutlet", ctx_r3.SpinnerTemplate ? ctx_r3.SpinnerTemplate : _r4);
} }
function MagicShellComponent_ng_template_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 9);
} }
export class MagicShellComponent {
    constructor(engineMagicService, componentList, changeDetectorRef, titleService, overlayWindowService, httpClient, pendingCommandsCollector, exitMagicService) {
        this.engineMagicService = engineMagicService;
        this.componentList = componentList;
        this.changeDetectorRef = changeDetectorRef;
        this.titleService = titleService;
        this.overlayWindowService = overlayWindowService;
        this.httpClient = httpClient;
        this.pendingCommandsCollector = pendingCommandsCollector;
        this.exitMagicService = exitMagicService;
        this.RootComponent = null;
        this.magicEngineTerminated = false;
        this.initialize();
        this.setTitle();
    }
    onBeforeUnload(event) {
        if (this.engineMagicService.TransCacheExists()) {
            event.returnValue = 'Are you sure?';
            return 'Are you sure?';
        }
        else {
            this.engineMagicService.TerminateContextUsingFetchAPI();
            this.magicEngineTerminated = true;
        }
    }
    onUnload(event) {
        if (!this.magicEngineTerminated)
            this.engineMagicService.TerminateContextUsingFetchAPI();
    }
    ngAfterViewInit() {
        this.overlayWindowService.init(this.overlayWindowsContainerViewRef, this.rootMagicElementRef.nativeElement);
        this.engineMagicService.startMagicEngine(this.httpClient);
    }
    setViewContainerRef(vcRef) {
        this.overlayWindowsContainerViewRef = vcRef;
    }
    initialize() {
        this.registerUICommands();
    }
    setTitle() {
        const newTitle = this.componentList.title;
        this.titleService.setTitle(newTitle);
    }
    setComponent(formName, taskId, taskDescription, isModal) {
        this.pendingCommandsCollector.startCollecting();
        if (isModal) {
            this.overlayWindowService.open(formName, taskId, taskDescription);
        }
        else {
            this.RootComponent = this.componentList.getComponent(formName);
            this.RootComponentParameters = { taskIdParam: taskId, taskDescription: taskDescription };
        }
        this.changeDetectorRef.detectChanges();
    }
    registerUICommands() {
        this.engineMagicService.refreshDom.pipe(filter(command => command.TaskTag === '0'))
            .subscribe(command => {
            this.executeCommand(command);
        });
        this.engineMagicService
            .interactiveCommands.pipe(filter(command => command.TaskTag === '0'))
            .subscribe(command => {
            GuiInteractiveExecutor.executeInteractiveCommand(null, command, this.overlayWindowService);
        });
    }
    executeCommand(command) {
        switch (command.CommandType) {
            case CommandType.OPEN_FORM:
                this.setComponent(command.str, command.stringList[0], command.stringList[1], command.Bool1);
                break;
            case CommandType.SET_IS_LOGGED_IN:
                this.engineMagicService.setIsLoggedIn(command.Bool1);
                break;
            case CommandType.CLOSE_FORM:
                if (this.RootComponent != null && command.str === this.RootComponentParameters.taskIdParam) {
                    this.RootComponent = null;
                    this.RootComponentParameters = {};
                    this.changeDetectorRef.detectChanges();
                }
                else {
                    this.overlayWindowService.close(command.str);
                    this.changeDetectorRef.detectChanges();
                }
                break;
            case CommandType.RELOAD_PAGE:
                window.location.reload();
                break;
            case CommandType.SHOW_SPINNER:
                if (this.showSpinner != command.Bool1) {
                    this.showSpinner = command.Bool1;
                    this.changeDetectorRef.detectChanges();
                }
                break;
            case CommandType.EXIT_MAGIC:
                if (this.exitMagicService)
                    this.exitMagicService.exitMagic();
                break;
            case CommandType.SHOW_HTML_ERROR:
                window.document.write(command.str);
                break;
        }
    }
}
MagicShellComponent.ɵfac = function MagicShellComponent_Factory(t) { return new (t || MagicShellComponent)(i0.ɵɵdirectiveInject(i1.EngineMagicService), i0.ɵɵdirectiveInject(i2.ComponentListMagicService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.Title), i0.ɵɵdirectiveInject(i4.OverlayWindowService), i0.ɵɵdirectiveInject(i5.HttpClient), i0.ɵɵdirectiveInject(i6.CommandsCollectorMagicService), i0.ɵɵdirectiveInject(i7.ExitMagicService, 8)); };
MagicShellComponent.ɵcmp = i0.ɵɵdefineComponent({ type: MagicShellComponent, selectors: [["magic-root"]], viewQuery: function MagicShellComponent_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0, 7);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.rootMagicElementRef = _t.first);
    } }, hostBindings: function MagicShellComponent_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("beforeunload", function MagicShellComponent_beforeunload_HostBindingHandler($event) { return ctx.onBeforeUnload($event); }, false, i0.ɵɵresolveWindow)("unload", function MagicShellComponent_unload_HostBindingHandler($event) { return ctx.onUnload($event); }, false, i0.ɵɵresolveWindow);
    } }, inputs: { SpinnerTemplate: "SpinnerTemplate" }, features: [i0.ɵɵProvidersFeature([])], decls: 8, vars: 2, consts: [["magicRoot", ""], [3, "ndcDynamicComponent", "ndcDynamicInputs", 4, "ngIf"], ["magicViewContainerRef", ""], ["overlayWindowsContainer", ""], ["class", "spinner-background", 4, "ngIf"], ["defaultSpinner", ""], [3, "ndcDynamicComponent", "ndcDynamicInputs"], [1, "spinner-background"], [3, "ngTemplateOutlet"], [1, "mgSpinnerClass"]], template: function MagicShellComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div", null, 0);
        i0.ɵɵtemplate(2, MagicShellComponent_ndc_dynamic_2_Template, 1, 2, "ndc-dynamic", 1);
        i0.ɵɵelement(3, "div", 2, 3);
        i0.ɵɵelementEnd();
        i0.ɵɵtemplate(5, MagicShellComponent_div_5_Template, 2, 1, "div", 4);
        i0.ɵɵtemplate(6, MagicShellComponent_ng_template_6_Template, 1, 0, "ng-template", null, 5, i0.ɵɵtemplateRefExtractor);
    } if (rf & 2) {
        i0.ɵɵadvance(2);
        i0.ɵɵproperty("ngIf", ctx.RootComponent !== null);
        i0.ɵɵadvance(3);
        i0.ɵɵproperty("ngIf", ctx.showSpinner);
    } }, dependencies: [i8.NgIf, i8.NgTemplateOutlet, i9.DynamicComponent, i9.DynamicIoDirective, i10.MagicViewContainerRef], styles: [".mgSpinnerClass[_ngcontent-%COMP%]{border:10px solid #cccccc;border-top:10px solid black;border-radius:50%;position:fixed;margin:auto;inset:0;width:100px;height:100px;animation:_ngcontent-%COMP%_spin 2s linear infinite}.spinner-background[_ngcontent-%COMP%]{position:fixed;z-index:1000;inset:0;opacity:.5}@keyframes _ngcontent-%COMP%_spin{0%{transform:rotate(0)}to{transform:rotate(360deg)}}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicShellComponent, [{
        type: Component,
        args: [{ selector: 'magic-root', providers: [], template: `
    <div #magicRoot>
      <ndc-dynamic
        *ngIf = "RootComponent !== null"
        [ndcDynamicComponent]="RootComponent"
        [ndcDynamicInputs]   ="RootComponentParameters">
      </ndc-dynamic>

      <div #overlayWindowsContainer magicViewContainerRef>
      </div>
    </div>

    <div class="spinner-background" *ngIf="showSpinner">
      <ng-container [ngTemplateOutlet]="SpinnerTemplate ? SpinnerTemplate:defaultSpinner"></ng-container>
    </div>

    <ng-template #defaultSpinner>
      <div class="mgSpinnerClass"></div>
    </ng-template>
  `, styles: [".mgSpinnerClass{border:10px solid #cccccc;border-top:10px solid black;border-radius:50%;position:fixed;margin:auto;inset:0;width:100px;height:100px;animation:spin 2s linear infinite}.spinner-background{position:fixed;z-index:1000;inset:0;opacity:.5}@keyframes spin{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n"] }]
    }], function () { return [{ type: i1.EngineMagicService }, { type: i2.ComponentListMagicService }, { type: i0.ChangeDetectorRef }, { type: i3.Title }, { type: i4.OverlayWindowService }, { type: i5.HttpClient }, { type: i6.CommandsCollectorMagicService }, { type: i7.ExitMagicService, decorators: [{
                type: Optional
            }] }]; }, { rootMagicElementRef: [{
            type: ViewChild,
            args: ['magicRoot', { static: true }]
        }], SpinnerTemplate: [{
            type: Input
        }], onBeforeUnload: [{
            type: HostListener,
            args: ['window:beforeunload', ['$event']]
        }], onUnload: [{
            type: HostListener,
            args: ['window:unload', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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