import { Pipe } from '@angular/core';
import { DatePipe } from '@angular/common';
import { TaskMagicService } from '../../services/task.magics.service';
import { StringBuilder, isNullOrUndefined } from "@magic-xpa/mscorelib";
import { PICInterface } from "@magic-xpa/utils";
import * as i0 from "@angular/core";
import * as i1 from "../../services/task.magics.service";
export class Constants {
}
Constants.DATE_FMT = 'dd/MMM/yyyy';
export class DateMagicPipe extends DatePipe {
    constructor(_task) {
        super('en-US');
        this._task = _task;
    }
    transform(value, controlId) {
        let mask = this._task.GetControlPictureMask(controlId).getMask();
        let formatStr = null;
        let mgDateFormatter = new MgDateFormatter();
        if (!isNullOrUndefined(value) && mask !== null) {
            formatStr = mgDateFormatter.ConvertMgDateFormatToAngular(mask);
            if (formatStr != null && this._task.isTableControl(controlId)) {
                if (this._task.mgInputDateFormat == null)
                    this._task.mgInputDateFormat = formatStr;
                else
                    formatStr = this._task.mgInputDateFormat;
            }
            return super.transform(value, formatStr);
        }
        else
            value = "";
        return value;
    }
}
DateMagicPipe.ɵfac = function DateMagicPipe_Factory(t) { return new (t || DateMagicPipe)(i0.ɵɵdirectiveInject(i1.TaskMagicService, 16)); };
DateMagicPipe.ɵpipe = i0.ɵɵdefinePipe({ name: "magicDate", type: DateMagicPipe, pure: true });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateMagicPipe, [{
        type: Pipe,
        args: [{
                name: 'magicDate'
            }]
    }], function () { return [{ type: i1.TaskMagicService }]; }, null); })();
export class MgDateFormatter {
    ConvertMgDateFormatToAngular(mgDateMask) {
        let formatStr = new StringBuilder();
        if (mgDateMask !== null) {
            for (let i = 0; i < mgDateMask.length;) {
                switch (mgDateMask.charCodeAt(i)) {
                    case PICInterface.PIC_YYYY:
                        formatStr.Append('yyyy');
                        i += 4;
                        break;
                    case PICInterface.PIC_MMD:
                        formatStr.Append('MM');
                        i += 2;
                        break;
                    case PICInterface.PIC_YY:
                        formatStr.Append('yy');
                        i += 2;
                        break;
                    case PICInterface.PIC_MMM:
                        {
                            let cnt = 0;
                            for (; i < mgDateMask.length; i++)
                                if (mgDateMask.charCodeAt(i) == PICInterface.PIC_MMM)
                                    cnt++;
                                else
                                    break;
                            if (cnt == 3)
                                formatStr.Append('MMM');
                            if (cnt > 3)
                                formatStr.Append('MMMM');
                        }
                        break;
                    case PICInterface.PIC_DD:
                        formatStr.Append('dd');
                        i += 2;
                        break;
                    case PICInterface.PIC_WWW:
                        {
                            let cnt = 0;
                            for (; i < mgDateMask.length; i++)
                                if (mgDateMask.charCodeAt(i) == PICInterface.PIC_WWW)
                                    cnt++;
                                else
                                    break;
                            if (cnt == 3)
                                formatStr.Append('EEE');
                            if (cnt > 3)
                                formatStr.Append('EEEE');
                        }
                        break;
                    default:
                        formatStr.Append(mgDateMask.charAt(i));
                        i++;
                        break;
                }
            }
            return formatStr.ToString();
        }
        else
            return "dd-mm-yyyy";
    }
}
//# sourceMappingURL=data:application/json;base64,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