import { Pipe } from '@angular/core';
import { DatePipe } from '@angular/common';
import { TaskMagicService } from '../../services/task.magics.service';
import { StringBuilder } from "@magic-xpa/mscorelib";
import { PICInterface } from "@magic-xpa/utils";
import * as i0 from "@angular/core";
import * as i1 from "../../services/task.magics.service";
export class TimeMagicPipe extends DatePipe {
    constructor(_task) {
        super('en-US');
        this._task = _task;
    }
    transform(value, controlId) {
        let mask = this._task.GetControlPictureMask(controlId).getMask();
        let formatStr = new StringBuilder();
        if (typeof value !== "undefined" && mask !== null) {
            for (let i = 0; i < mask.length;) {
                switch (mask.charCodeAt(i)) {
                    case PICInterface.PIC_HH:
                        formatStr.Append('hh');
                        i += 2;
                        break;
                    case PICInterface.PIC_MMT:
                        formatStr.Append('mm');
                        i += 2;
                        break;
                    case PICInterface.PIC_SS:
                        formatStr.Append('ss');
                        i += 2;
                        break;
                    default:
                        formatStr.Append(mask.charAt(i));
                        i++;
                        break;
                }
            }
            formatStr.Append(' a');
            return super.transform(value, formatStr.ToString());
        }
        return value;
    }
}
TimeMagicPipe.ɵfac = function TimeMagicPipe_Factory(t) { return new (t || TimeMagicPipe)(i0.ɵɵdirectiveInject(i1.TaskMagicService, 16)); };
TimeMagicPipe.ɵpipe = i0.ɵɵdefinePipe({ name: "magicTime", type: TimeMagicPipe, pure: true });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimeMagicPipe, [{
        type: Pipe,
        args: [{
                name: 'magicTime'
            }]
    }], function () { return [{ type: i1.TaskMagicService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGltZS5tYWdpYy5waXBlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvYW5ndWxhci9zcmMvdWkvcGlwZXMvdGltZS5tYWdpYy5waXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxJQUFJLEVBQWlCLE1BQU0sZUFBZSxDQUFDO0FBQ3BELE9BQU8sRUFBRSxRQUFRLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQUMzQyxPQUFPLEVBQUMsZ0JBQWdCLEVBQUMsTUFBTSxvQ0FBb0MsQ0FBQztBQUNwRSxPQUFPLEVBQUMsYUFBYSxFQUFDLE1BQU0sc0JBQXNCLENBQUE7QUFDbEQsT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLGtCQUFrQixDQUFBOzs7QUFRN0MsTUFBTSxPQUFPLGFBQWMsU0FBUSxRQUFRO0lBRXpDLFlBQXNCLEtBQXVCO1FBQzNDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQURLLFVBQUssR0FBTCxLQUFLLENBQWtCO0lBRTdDLENBQUM7SUFFRCxTQUFTLENBQUMsS0FBVSxFQUFFLFNBQWlCO1FBQ3JDLElBQUksSUFBSSxHQUFXLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLENBQUUsU0FBUyxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDMUUsSUFBSSxTQUFTLEdBQWtCLElBQUksYUFBYSxFQUFHLENBQUM7UUFFcEQsSUFBSSxPQUFPLEtBQUssS0FBSyxXQUFXLElBQUksSUFBSSxLQUFLLElBQUksRUFBRTtZQUNqRCxLQUFLLElBQUksQ0FBQyxHQUFXLENBQUMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sR0FBRztnQkFDeEMsUUFBUSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxFQUFFO29CQUMxQixLQUFLLFlBQVksQ0FBQyxNQUFNO3dCQUN0QixTQUFTLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO3dCQUN2QixDQUFDLElBQUksQ0FBQyxDQUFDO3dCQUNQLE1BQU07b0JBQ1IsS0FBSyxZQUFZLENBQUMsT0FBTzt3QkFDdkIsU0FBUyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDdkIsQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDUCxNQUFNO29CQUNSLEtBQUssWUFBWSxDQUFDLE1BQU07d0JBQ3RCLFNBQVMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7d0JBQ3ZCLENBQUMsSUFBSSxDQUFDLENBQUM7d0JBQ1AsTUFBTTtvQkFDUjt3QkFDRSxTQUFTLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzt3QkFDakMsQ0FBQyxFQUFFLENBQUM7d0JBQ0osTUFBTTtpQkFDVDthQUNGO1lBRUQsU0FBUyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUN2QixPQUFPLEtBQUssQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO1NBQ3JEO1FBQ0QsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDOzswRUFwQ1UsYUFBYTtpRUFBYixhQUFhO3VGQUFiLGFBQWE7Y0FIekIsSUFBSTtlQUFDO2dCQUNKLElBQUksRUFBRSxXQUFXO2FBQ2xCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUGlwZSwgUGlwZVRyYW5zZm9ybSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBEYXRlUGlwZSB9IGZyb20gJ0Bhbmd1bGFyL2NvbW1vbic7XHJcbmltcG9ydCB7VGFza01hZ2ljU2VydmljZX0gZnJvbSAnLi4vLi4vc2VydmljZXMvdGFzay5tYWdpY3Muc2VydmljZSc7XHJcbmltcG9ydCB7U3RyaW5nQnVpbGRlcn0gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCJcclxuaW1wb3J0IHtQSUNJbnRlcmZhY2V9IGZyb20gXCJAbWFnaWMteHBhL3V0aWxzXCJcclxuXHJcbi8qKlxyXG4gKiBAaWdub3JlXHJcbiAqL1xyXG5AUGlwZSh7XHJcbiAgbmFtZTogJ21hZ2ljVGltZSdcclxufSlcclxuZXhwb3J0IGNsYXNzIFRpbWVNYWdpY1BpcGUgZXh0ZW5kcyBEYXRlUGlwZSBpbXBsZW1lbnRzIFBpcGVUcmFuc2Zvcm0ge1xyXG5cclxuICBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgX3Rhc2s6IFRhc2tNYWdpY1NlcnZpY2UpIHtcclxuICAgIHN1cGVyKCdlbi1VUycpO1xyXG4gIH1cclxuXHJcbiAgdHJhbnNmb3JtKHZhbHVlOiBhbnksIGNvbnRyb2xJZDogc3RyaW5nKTogYW55IHtcclxuICAgIGxldCBtYXNrOiBzdHJpbmcgPSB0aGlzLl90YXNrLkdldENvbnRyb2xQaWN0dXJlTWFzayAoY29udHJvbElkKS5nZXRNYXNrKCk7XHJcbiAgICBsZXQgZm9ybWF0U3RyOiBTdHJpbmdCdWlsZGVyID0gbmV3IFN0cmluZ0J1aWxkZXIgKCk7XHJcblxyXG4gICAgaWYgKHR5cGVvZiB2YWx1ZSAhPT0gXCJ1bmRlZmluZWRcIiAmJiBtYXNrICE9PSBudWxsKSB7XHJcbiAgICAgIGZvciAobGV0IGk6IG51bWJlciA9IDA7IGkgPCBtYXNrLmxlbmd0aDspIHtcclxuICAgICAgICBzd2l0Y2ggKG1hc2suY2hhckNvZGVBdChpKSkge1xyXG4gICAgICAgICAgY2FzZSBQSUNJbnRlcmZhY2UuUElDX0hIOlxyXG4gICAgICAgICAgICBmb3JtYXRTdHIuQXBwZW5kKCdoaCcpO1xyXG4gICAgICAgICAgICBpICs9IDI7XHJcbiAgICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgICAgY2FzZSBQSUNJbnRlcmZhY2UuUElDX01NVDpcclxuICAgICAgICAgICAgZm9ybWF0U3RyLkFwcGVuZCgnbW0nKTtcclxuICAgICAgICAgICAgaSArPSAyO1xyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIGNhc2UgUElDSW50ZXJmYWNlLlBJQ19TUzpcclxuICAgICAgICAgICAgZm9ybWF0U3RyLkFwcGVuZCgnc3MnKTtcclxuICAgICAgICAgICAgaSArPSAyO1xyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIGRlZmF1bHQ6XHJcbiAgICAgICAgICAgIGZvcm1hdFN0ci5BcHBlbmQobWFzay5jaGFyQXQoaSkpO1xyXG4gICAgICAgICAgICBpKys7XHJcbiAgICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG5cclxuICAgICAgZm9ybWF0U3RyLkFwcGVuZCgnIGEnKTtcclxuICAgICAgcmV0dXJuIHN1cGVyLnRyYW5zZm9ybSh2YWx1ZSwgZm9ybWF0U3RyLlRvU3RyaW5nKCkpO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIHZhbHVlO1xyXG4gIH1cclxufVxyXG4iXX0=