import { Component, ComponentFactoryResolver, ViewContainerRef } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { EngineMagicService } from '../services/engine.magic.service';
import { getGuiEventObj } from '@magic-xpa/engine';
import { List } from '@magic-xpa/mscorelib';
import { StrUtil } from '@magic-xpa/utils';
import { ComponentListMagicService } from '../services/component-list.magic.service';
import { SubformMagicService } from '../services/subform.magic.service';
import { CommandsCollectorMagicService } from '../services/commands-collector.magic.service';
import { RouterCommandsMagicService } from '../services/router-commands.magic.service';
import { TaskMagicService } from '../services/task.magics.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "../services/engine.magic.service";
import * as i3 from "../services/task.magics.service";
import * as i4 from "../services/component-list.magic.service";
import * as i5 from "../services/commands-collector.magic.service";
import * as i6 from "../services/router-commands.magic.service";
export class RouterContainerMagicComponent {
    static get LastRoute() {
        return RouterContainerMagicComponent.lastRoute;
    }
    constructor(activatedRoute, router, magic, containerTaskService, componentFactoryResolver, viewContainerRef, componentList, pendingCommandsCollector, routerCommandsMagicService) {
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.magic = magic;
        this.containerTaskService = containerTaskService;
        this.componentFactoryResolver = componentFactoryResolver;
        this.viewContainerRef = viewContainerRef;
        this.componentList = componentList;
        this.pendingCommandsCollector = pendingCommandsCollector;
        this.routerCommandsMagicService = routerCommandsMagicService;
        this.componentRef = null;
        this.parentMgSubformService = null;
    }
    ngOnInit() {
        let subformMagicService = SubformMagicService.currentCallerMgSubformServiceRef;
        let currentActiveRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
        RouterContainerMagicComponent.lastRoute = this.router.url;
        if (subformMagicService == null || subformMagicService.currentRouteDefinition === null) {
            this.insertRouteEvent(currentActiveRoute);
            SubformMagicService.routerContainers.push(this);
        }
        else {
            this.initializeComponent();
        }
    }
    insertRouteEvent(currentActiveRoute) {
        let guiEvent = getGuiEventObj('RouterNavigate', null, 0);
        guiEvent.RouterPath = currentActiveRoute.snapshot.routeConfig.path;
        if (currentActiveRoute.snapshot.outlet !== 'primary')
            guiEvent.RouterOutletName = currentActiveRoute.snapshot.outlet;
        let calcRouterPath = currentActiveRoute.routeConfig.path;
        if (calcRouterPath.length > 0) {
            let routerPath = calcRouterPath;
            let tokens = StrUtil.tokenize(routerPath, "/:");
            guiEvent.RouterPath = tokens[0];
            guiEvent.RouterParams = new List();
            for (let i = 1; i < tokens.length; i++) {
                guiEvent.RouterParams.push(currentActiveRoute.snapshot.params[tokens[i]]);
            }
        }
        this.containerTaskService.insertEvent(guiEvent);
    }
    initializeComponent() {
        let subformMagicService = SubformMagicService.currentCallerMgSubformServiceRef;
        if (subformMagicService.currentRouteDefinition !== null) {
            let comp = this.componentList.getComponent(subformMagicService.currentRouteDefinition.formName);
            const componentFactory = this.componentFactoryResolver.resolveComponentFactory(comp);
            this.componentRef = this.viewContainerRef.createComponent(componentFactory);
            Object.assign(this.componentRef.instance, subformMagicService.currentRouteDefinition.parameters);
            let myActiveRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
            let routeParams = StrUtil.tokenize(myActiveRoute.snapshot.routeConfig.path, "/:");
            subformMagicService.routesDict[myActiveRoute.snapshot.outlet] = routeParams[0];
            this.parentMgSubformService = subformMagicService;
            subformMagicService.currentRouteDefinition = null;
            SubformMagicService.currentCallerMgSubformServiceRef = null;
            let ignoreParamChange = true;
            myActiveRoute.paramMap.subscribe(params => {
                if (!ignoreParamChange)
                    this.insertRouteEvent(myActiveRoute);
                ignoreParamChange = false;
            });
            this.parentMgSubformService.refreshView();
            this.routerCommandsMagicService.ExecuteNextCommand();
        }
    }
    ngOnDestroy() {
        if (this.componentRef != null) {
            this.componentRef.instance.task.close();
            let currentActiveRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
            this.parentMgSubformService.routesDict[currentActiveRoute.outlet] = "";
            RouterContainerMagicComponent.lastRoute = this.router.url;
        }
    }
}
RouterContainerMagicComponent.lastRoute = "/";
RouterContainerMagicComponent.ɵfac = function RouterContainerMagicComponent_Factory(t) { return new (t || RouterContainerMagicComponent)(i0.ɵɵdirectiveInject(i1.ActivatedRoute), i0.ɵɵdirectiveInject(i1.Router), i0.ɵɵdirectiveInject(i2.EngineMagicService), i0.ɵɵdirectiveInject(i3.TaskMagicService), i0.ɵɵdirectiveInject(i0.ComponentFactoryResolver), i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(i4.ComponentListMagicService), i0.ɵɵdirectiveInject(i5.CommandsCollectorMagicService), i0.ɵɵdirectiveInject(i6.RouterCommandsMagicService)); };
RouterContainerMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: RouterContainerMagicComponent, selectors: [["magic-route-outlet"]], decls: 0, vars: 0, template: function RouterContainerMagicComponent_Template(rf, ctx) { }, encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RouterContainerMagicComponent, [{
        type: Component,
        args: [{
                selector: 'magic-route-outlet',
                template: `
  `
            }]
    }], function () { return [{ type: i1.ActivatedRoute }, { type: i1.Router }, { type: i2.EngineMagicService }, { type: i3.TaskMagicService }, { type: i0.ComponentFactoryResolver }, { type: i0.ViewContainerRef }, { type: i4.ComponentListMagicService }, { type: i5.CommandsCollectorMagicService }, { type: i6.RouterCommandsMagicService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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