import { ChangeDetectorRef, Component, Input } from '@angular/core';
import { MagicProperties } from "@magic-xpa/utils";
import { isNullOrUndefined } from "@magic-xpa/mscorelib";
import { TaskMagicService } from "../services/task.magics.service";
import { SubformMagicService } from "../services/subform.magic.service";
import { TableMagicService } from "../services/table.magic.service";
import { MagicServices } from "../services/magic.services";
import * as i0 from "@angular/core";
import * as i1 from "../services/magic.services";
export class TaskBaseMagicComponent {
    constructor(ref, magicServices) {
        this.ref = ref;
        this.magicServices = magicServices;
        this.magicProperties = MagicProperties;
    }
    get task() {
        return this.magicServices.task;
    }
    get mgSub() {
        return this.magicServices.subformService;
    }
    get tableService() {
        return this.magicServices.tableService;
    }
    get mg() {
        return this.magicServices.mgAccessorService;
    }
    get taskId() {
        return this.task.taskId;
    }
    get screenFormGroup() {
        return this.task.ScreenModeControls;
    }
    ngOnInit() {
        this.task.detectChanges.pipe().subscribe(c => {
            this.ref.detectChanges();
        });
        this.task.initTask(this.taskIdParam, this.taskDescription);
        this.createFormControlsAccessor(this.screenFormGroup);
        this.setInputDateFormat();
        this.task.customPropertiesSubject.pipe().subscribe(property => {
            this.PropertyChanged(property.propertyName, property.rowId, property.value);
        });
        this.task.recordsCountChangeSubject.pipe().subscribe(value => {
            this.RecordsCountChanged(value);
        });
        this.task.mgLoadSubject.pipe().subscribe(value => {
            this.mgOnLoad();
        });
    }
    createFormControlsAccessor(formGroup) { }
    setInputDateFormat() { }
    PropertyChanged(propertyName, rowId, value) {
    }
    RecordsCountChanged(recordsCount) {
    }
    mgOnLoad() {
    }
    ngAfterViewInit() {
        this.mgSub.init();
    }
    ngAfterContentChecked() {
        if (!isNullOrUndefined(this.tableService.getPageSize()) && this.task.oldPageSize != this.tableService.getPageSize()) {
            this.task.resize(this.tableService.getPageSize(), 0);
            this.task.oldPageSize = this.tableService.getPageSize();
        }
    }
    ngOnDestroy() {
        this.task.dispose();
    }
}
TaskBaseMagicComponent.ɵfac = function TaskBaseMagicComponent_Factory(t) { return new (t || TaskBaseMagicComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.MagicServices)); };
TaskBaseMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: TaskBaseMagicComponent, selectors: [["task-magic"]], inputs: { taskIdParam: "taskIdParam", taskDescription: "taskDescription" }, features: [i0.ɵɵProvidersFeature([TaskMagicService, SubformMagicService, TableMagicService])], decls: 0, vars: 0, template: function TaskBaseMagicComponent_Template(rf, ctx) { }, encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TaskBaseMagicComponent, [{
        type: Component,
        args: [{
                selector: 'task-magic',
                providers: [TaskMagicService, SubformMagicService, TableMagicService],
                template: ''
            }]
    }], function () { return [{ type: i0.ChangeDetectorRef }, { type: i1.MagicServices }]; }, { taskIdParam: [{
            type: Input
        }], taskDescription: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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