export class utils {
    static getDistance(control, x, y) {
        let left = control.clientLeft, top = control.clientTop;
        let dx, dy;
        const right = left + control.clientWidth;
        const bottom = top + control.clientHeight;
        if (x < left) {
            dx = left - x;
        }
        else if (x > right) {
            dx = x - right;
        }
        else {
            dx = 0;
        }
        if (y < top) {
            dy = top - y;
        }
        else if (y > bottom) {
            dy = y - bottom;
        }
        else {
            dy = 0;
        }
        const ret = (dx * dx + dy * dy);
        return ret;
    }
    static getDimentions(el) {
        let xPos = 0;
        let yPos = 0;
        let width = el.width;
        let height = el.height;
        while (el) {
            if (el.tagName == "BODY") {
                let xScroll = el.scrollLeft || document.documentElement.scrollLeft;
                let yScroll = el.scrollTop || document.documentElement.scrollTop;
                xPos += (el.offsetLeft - xScroll + el.clientLeft);
                yPos += (el.offsetTop - yScroll + el.clientTop);
            }
            else {
                xPos += (el.offsetLeft - el.scrollLeft + el.clientLeft);
                yPos += (el.offsetTop - el.scrollTop + el.clientTop);
            }
            el = el.offsetParent;
        }
        return {
            x: xPos,
            y: yPos,
            width: width,
            height: height
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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