import { isNullOrUndefined, NString, List, isUndefined, StringBuilder, RefParam } from '@magic-xpa/mscorelib';
import * as i0 from '@angular/core';
import { Injectable, Component, Input, Output, Directive, EventEmitter, ViewChild, InjectionToken, Inject, HostListener, Optional, Pipe, forwardRef, NgModule } from '@angular/core';
import * as i1 from '@angular/common';
import { DatePipe, CommonModule, formatDate } from '@angular/common';
import * as i2 from '@angular/router';
import { RouterModule } from '@angular/router';
import { FormGroup, FormControl, Validators, NG_VALIDATORS, NG_VALUE_ACCESSOR, CheckboxControlValueAccessor, DefaultValueAccessor, FormsModule, ReactiveFormsModule } from '@angular/forms';
import * as i3 from 'ng-dynamic-component';
import { DynamicModule } from 'ng-dynamic-component';
import { InteractiveCommandType, OverlayType, Styles, HtmlProperties, GuiConstants, CommandType, PIC, GuiEnvironment, Modifiers } from '@magic-xpa/gui';
import { MagicBridge, getGuiEventObj, CookieService } from '@magic-xpa/engine';
import { MagicProperties, Logger, StrUtil, StorageAttribute, PICInterface, BindingLevel, StorageAttributeType, MgControlType } from '@magic-xpa/utils';
import { filter, map, debounceTime } from 'rxjs/operators';
import { Subject, fromEvent } from 'rxjs';
import { __decorate, __metadata } from 'tslib';
import * as i1$1 from '@angular/platform-browser';
import * as i1$2 from '@angular/common/http';
import { HttpClientModule } from '@angular/common/http';
import { maskitoTimeOptionsGenerator } from '@maskito/kit';
import { MaskitoModule } from '@maskito/angular';
import { NativeDateAdapter, MAT_DATE_LOCALE, DateAdapter, MAT_DATE_FORMATS } from '@angular/material/core';
import * as i1$3 from '@angular/cdk/platform';

class ControlMetadata {
    constructor() {
        this.properties = new Map();
        this.classesMap = new Map();
        this.stylesMap = new Map();
        this.userProperties = new Map();
        this.customValidators = new Map();
    }
    setClass(key, value) {
        if (this.classesMap.has(key)) {
            this.removedClass = this.classesMap.get(key);
        }
        this.classesMap.set(key, value);
        let result = '';
        for (let value of this.classesMap) {
            result += value + ' ';
        }
        this.classes = result;
    }
    setStyle(key, value) {
        this.stylesMap.set(key, value);
    }
}
class ControlsMetadata {
    constructor() {
        this.values = new Map();
        this.ControlsProperties = new Map();
        this.isCreated = false;
        this.isEditing = false;
    }
    get Values() {
        return this.values;
    }
    getControlMetadata(controlId) {
        if (!this.ControlsProperties.has(controlId))
            this.ControlsProperties.set(controlId, new ControlMetadata());
        return this.ControlsProperties.get(controlId);
    }
    update(obj) {
        let props = obj.ControlsMetaData;
        for (let controlName in props) {
            if (!this.ControlsProperties.has(controlName))
                this.ControlsProperties.set(controlName, new ControlMetadata());
            let controlMetaData = this.ControlsProperties.get(controlName);
            for (let property in obj.ControlsMetaData[controlName].Properties)
                controlMetaData[property] = obj.ControlsMetaData[controlName].Properties[property];
            controlMetaData.controlType = obj.ControlsMetaData[controlName].Type;
        }
        for (let controlName in obj.ControlsValues) {
            this.setValue(controlName, obj.ControlsValues[controlName]);
        }
    }
    setValue(controlName, value) {
        this.values.set(controlName, value);
    }
    getProperty(controlId, prop) {
        if (this.ControlsProperties.has(controlId)) {
            if (this.ControlsProperties.get(controlId).properties.has(prop)) {
                return this.ControlsProperties.get(controlId).properties.get(prop);
            }
        }
        return "";
    }
    getValue(controlName) {
        return this.values.get(controlName);
    }
}
class Records {
    constructor() {
        this.data = new Map();
        this.list = [];
        this.recordsBeforeCurrentView = 0;
        this.isEmptyDataView = false;
        this.sizeUpdated = false;
    }
    getRow(dvRowId) {
        return this.list[dvRowId + this.recordsBeforeCurrentView];
    }
    markRowAsCreated(guiRowId) {
        if (guiRowId < this.list.length) {
            this.addRow(guiRowId);
            this.data.get(guiRowId).isCreated = true;
        }
    }
    markRowAsNotCreated(guiRowId) {
        if (guiRowId < this.list.length)
            this.data.get(guiRowId).isCreated = false;
    }
    isRowCreated(guiRowId) {
        if (guiRowId < this.list.length) {
            if (!this.data.has(guiRowId) || isNullOrUndefined(this.data.get(guiRowId)))
                return false;
            else
                return this.data.get(guiRowId).isCreated;
        }
        return false;
    }
    startRowEditing(guiRowId) {
        if (guiRowId < this.list.length && this.data.has(guiRowId))
            this.data.get(guiRowId).isEditing = true;
    }
    stopRowEditing(guiRowId) {
        if (guiRowId < this.list.length && this.data.has(guiRowId))
            this.data.get(guiRowId).isEditing = false;
    }
    isRowInRowEditing(guiRowId) {
        if (+guiRowId < this.list.length) {
            if (!this.data.has(+guiRowId) || isNullOrUndefined(this.data.get(+guiRowId)))
                return false;
            else
                return this.data.get(+guiRowId).isEditing;
        }
        return false;
    }
    update(obj) {
        if (obj.fullRefresh && obj.rows.length != this.list.length) {
            this.data = new Map();
            this.list = new Array();
        }
        for (let rowId in obj.rows) {
            if (!this.data.has(+rowId) || this.data.get(+rowId) === null)
                this.data.set(+rowId, new ControlsMetadata());
            let controlsData = this.data.get(+rowId);
            controlsData.update(obj.rows[rowId]);
            controlsData.rowId = rowId;
        }
        for (var [key, value] of this.data) {
            this.list[key] = value;
        }
    }
    updateSize(len) {
        if (this.list.length != len) {
            if (len < this.list.length) {
                for (let i = len; i < this.list.length; i++) {
                    this.data.delete(i);
                }
            }
            this.list.length = len;
            this.sizeUpdated = true;
        }
    }
    clearFirstTableRecord(template) {
        if (this.list.length >= 1) {
            for (const key in template) {
                if (template[key] == '1' && this.list[0].ControlsProperties.has(key)) {
                    this.list[0].ControlsProperties.get(key).properties = new Map();
                }
            }
        }
    }
    addRow(guiRowId) {
        if (guiRowId !== 0 || !this.data.has(guiRowId) || isNullOrUndefined(this.data.get(guiRowId))) {
            this.data.set(guiRowId, new ControlsMetadata());
            this.data.get(guiRowId).rowId = "" + guiRowId;
            this.list[guiRowId] = this.data.get(guiRowId);
        }
    }
    createFirst() {
        this.addRow(0);
    }
    fromJson(data) {
        var obj = JSON.parse(data);
        this.update(obj);
    }
    setGuiTopIndex(topIndex) {
        this.guiTopIndex = topIndex;
    }
    getGuiTopIndex() {
        return this.guiTopIndex;
    }
}
var HtmlClasses;
(function (HtmlClasses) {
    HtmlClasses["Color"] = "color";
    HtmlClasses["font"] = "font";
    HtmlClasses["FocusColor"] = "focuscolor";
    HtmlClasses["HintColor"] = "hintcolor";
})(HtmlClasses || (HtmlClasses = {}));

class StylesMapManager {
    static magicValueGetStyle(styleName, magicValue) {
        let style = "";
        if (!isNullOrUndefined(magicValue)) {
            let value = StylesMapManager.StylesMap.get(styleName);
            if (value.constructor === Map) {
                style = value.get(magicValue);
            }
            else if (value.constructor === String) {
                style = NString.Format(value.toString(), magicValue);
            }
        }
        return style;
    }
}
StylesMapManager.StylesMap = new Map([
    [MagicProperties.LineDivider, new Map([[true, "solid"], [false, "hidden"]])],
    [MagicProperties.ImageFile, "url('\{0}\')"],
    [MagicProperties.Wallpaper, "url('\{0}\')"]
]);
StylesMapManager.MagicPropertyToHtmlAttributeMap = new Map([
    [MagicProperties.LineDivider, "border-bottom-style"],
    [MagicProperties.ImageFile, "background-image"],
    [MagicProperties.Wallpaper, "background-image"]
]);

class EngineMagicService {
    constructor() {
        this.magicBridge = MagicBridge;
        this.isStub = false;
        this.isLoggedIn = false;
        this.refreshDom = new Subject();
        this.interactiveCommands = new Subject();
    }
    startMagicEngine(httpClient) {
        this.magicBridge.registerExecuteCommandsCallback(data => {
            if (!this.isStub) {
                try {
                    const list = data;
                    for (let c of list) {
                        this.refreshDom.next(c);
                    }
                }
                catch (e) {
                    console.dir(e);
                    console.log('magic engine not found');
                    console.log('moving to stub mode');
                    this.isStub = true;
                }
            }
        });
        this.magicBridge.registerInteractiveCallback(data => {
            if (!this.isStub) {
                this.interactiveCommands.next(data);
            }
        });
        this.magicBridge.Initialize(httpClient);
    }
    async terminateMagic() {
        await this.magicBridge.TerminateMagic();
    }
    insertEvent(guiEvent) {
        if (!this.isStub)
            this.magicBridge.insertEvent(guiEvent);
    }
    GetRangedValue(taskId, controlName, value) {
        return this.magicBridge.GetRangedValue(taskId, controlName, value);
    }
    GetControlPictureMask(taskId, controlName) {
        return this.magicBridge.GetControlPictureMask(taskId, controlName);
    }
    GetFormattedValue(taskId, controlName, value, rowId) {
        return this.magicBridge.GetFormattedValue(taskId, controlName, value, rowId);
    }
    ValidateControlValue(taskId, controlName, value) {
        return this.magicBridge.ValidateControlValue(taskId, controlName, value);
    }
    GetFldRanges(taskId, controlName) {
        return this.magicBridge.GetFldRanges(taskId, controlName);
    }
    saveData(data) {
    }
    getIsLoggedIn() {
        return this.isLoggedIn;
    }
    setIsLoggedIn(setIsLoggedIn) {
        this.isLoggedIn = setIsLoggedIn;
    }
    TransCacheExists() {
        return this.magicBridge.TransCacheExists();
    }
    TerminateContextUsingFetchAPI() {
        this.magicBridge.TerminateContextUsingFetchAPI();
    }
}
EngineMagicService.ɵfac = function EngineMagicService_Factory(t) { return new (t || EngineMagicService)(); };
EngineMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: EngineMagicService, factory: EngineMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EngineMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

class ComponentListMagicService {
    constructor() {
        this.components = new Map();
        this.dialogs = new Map();
        this.lazyLoadModulesMap = null;
    }
    getData(name, mustHaveData) {
        let data = null;
        let haveData = this.components.has(name);
        if (!haveData && mustHaveData) {
            console.log("Error: Component: " + name + " does not exist in components map");
        }
        if (haveData)
            data = this.components.get(name);
        return data;
    }
    getComponent(name, mustHaveData = true) {
        let data = this.getData(name, mustHaveData);
        return data ? data.component : null;
    }
    addComponents(componentList, modulRef) {
        for (let key in componentList) {
            let data = { moduleRef: modulRef, component: componentList[key] };
            this.components.set(key, data);
        }
    }
    getModuleRef(name) {
        let data = this.getData(name, false);
        return data ? data.moduleRef : null;
        ;
    }
    getLazyLoadModuleData(name) {
        return (this.lazyLoadModulesMap != null && this.lazyLoadModulesMap.hasOwnProperty(name)) ? this.lazyLoadModulesMap[name] : null;
    }
}
ComponentListMagicService.ɵfac = function ComponentListMagicService_Factory(t) { return new (t || ComponentListMagicService)(); };
ComponentListMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: ComponentListMagicService, factory: ComponentListMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ComponentListMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

class CommandsCollectorMagicService {
    constructor(magic) {
        this.magic = magic;
        this.count = 0;
        this.commands = new List();
        this.subscription = null;
    }
    startCollecting() {
        this.count++;
        Logger.Instance.WriteDevToLog("CommandsCollectorMagicService.startCollecting() --- " + this.count);
        if (this.subscription === null) {
            this.subscription = this.magic.refreshDom
                .subscribe(command => {
                this.commands.push(command);
            });
        }
    }
    stopCollecting() {
        this.count--;
        Logger.Instance.WriteDevToLog("CommandsCollectorMagicService.stopCollecting() --- " + this.count);
        if (this.count === 0) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
    GetCommands(taskId) {
        const commands = this.commands.filter((command) => command.TaskTag === taskId);
        commands.forEach(command => { this.commands.Remove(command); });
        return commands;
    }
}
CommandsCollectorMagicService.ɵfac = function CommandsCollectorMagicService_Factory(t) { return new (t || CommandsCollectorMagicService)(i0.ɵɵinject(EngineMagicService)); };
CommandsCollectorMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: CommandsCollectorMagicService, factory: CommandsCollectorMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CommandsCollectorMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: EngineMagicService }]; }, null); })();

class RouteCommand {
}
class RouterCommandsMagicService {
    constructor() {
        this.pendingRouteCommands = [];
    }
    AddRouteCommand(routeCommand) {
        this.pendingRouteCommands.push(routeCommand);
    }
    ExecuteNextCommand() {
        let pendingRouteCommand = this.pendingRouteCommands.shift();
        if (!isNullOrUndefined(pendingRouteCommand)) {
            pendingRouteCommand.callerMgSubformServiceRef.ExecuteRouteCommand(pendingRouteCommand);
        }
    }
}
RouterCommandsMagicService.ɵfac = function RouterCommandsMagicService_Factory(t) { return new (t || RouterCommandsMagicService)(); };
RouterCommandsMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: RouterCommandsMagicService, factory: RouterCommandsMagicService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RouterCommandsMagicService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

class MagicLazyLoaderService {
    Load(path) {
        return Promise.reject('error in loading module :' + path);
    }
}
MagicLazyLoaderService.ɵfac = function MagicLazyLoaderService_Factory(t) { return new (t || MagicLazyLoaderService)(); };
MagicLazyLoaderService.ɵprov = i0.ɵɵdefineInjectable({ token: MagicLazyLoaderService, factory: MagicLazyLoaderService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicLazyLoaderService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

class SubformMagicService {
    constructor(task, activatedRoute, componentList, pendingCommandsCollector, router, routerCommandsMagicService, componentListMagicService, loader, injector, compiler) {
        this.task = task;
        this.activatedRoute = activatedRoute;
        this.componentList = componentList;
        this.pendingCommandsCollector = pendingCommandsCollector;
        this.router = router;
        this.routerCommandsMagicService = routerCommandsMagicService;
        this.componentListMagicService = componentListMagicService;
        this.loader = loader;
        this.injector = injector;
        this.compiler = compiler;
        this.subformsDict = {};
        this.routesDict = {};
        this.currentRouteDefinition = null;
    }
    mgGetComp(subformName) {
        if (subformName in this.subformsDict) {
            let formName = this.subformsDict[subformName].formName;
            if (formName)
                return this.componentList.getComponent(formName);
        }
        return null;
    }
    mgGetParameters(subformName) {
        if (subformName in this.subformsDict) {
            return this.subformsDict[subformName].parameters;
        }
        else
            return '';
    }
    deleteSubformComp(subformControlName, formName) {
        if (Object.keys(this.subformsDict).indexOf(subformControlName) >= 0) {
            if (this.subformsDict[subformControlName].formName === formName) {
                this.subformsDict[subformControlName] = {};
                this.task.refreshView();
            }
        }
    }
    addSubformComp(subformControlName, formName, taskId, taskDescription, routerPath, params, inDefaultOutlet) {
        this.pendingCommandsCollector.startCollecting();
        let refreshNeeded = false;
        if (isNullOrUndefined(routerPath)) {
            if (Object.keys(this.subformsDict).indexOf(subformControlName) >= 0) {
                if (this.subformsDict[subformControlName].formName === formName) {
                    this.subformsDict[subformControlName] = {};
                    this.task.refreshView();
                }
            }
            let moduleRef = this.componentListMagicService.getModuleRef(formName);
            if (moduleRef == null) {
                let lazyLoadModule = this.componentListMagicService.getLazyLoadModuleData(formName);
                if (lazyLoadModule != null) {
                    let moduleName = lazyLoadModule.moduleName.replace('Magic', '');
                    moduleName = moduleName.replace('Module', '');
                    this.loader.Load(moduleName).then(m => {
                        const compiled = this.compiler.compileModuleAndAllComponentsSync(m[lazyLoadModule.moduleName]);
                        moduleRef = compiled.ngModuleFactory.create(this.injector);
                        this.subformsDict[subformControlName] = {
                            formName,
                            parameters: { taskIdParam: taskId, taskDescription: taskDescription }
                        };
                        this.task.refreshView();
                    });
                }
            }
            else {
                this.subformsDict[subformControlName] = {
                    formName,
                    parameters: { taskIdParam: taskId, taskDescription: taskDescription }
                };
                refreshNeeded = true;
            }
        }
        else {
            if (inDefaultOutlet)
                subformControlName = 'primary';
            let routeParams = new List();
            routeParams.push(routerPath);
            if (params !== null) {
                routeParams = routeParams.concat(params);
            }
            let routeCommand = {
                callerMgSubformServiceRef: this,
                routerOutletName: subformControlName,
                formName: formName,
                parameters: { taskIdParam: taskId, taskDescription: taskDescription },
                routeParams: routeParams
            };
            if (SubformMagicService.currentCallerMgSubformServiceRef === null)
                this.ExecuteRouteCommand(routeCommand);
            else
                this.routerCommandsMagicService.AddRouteCommand(routeCommand);
        }
        if (refreshNeeded)
            this.task.refreshView();
    }
    ExecuteRouteCommand(routeCommand) {
        let currentSubformMagicService = routeCommand.callerMgSubformServiceRef;
        let relativeRoute = SubformMagicService.getRelativeRoute(currentSubformMagicService.activatedRoute);
        if (currentSubformMagicService.routesDict[routeCommand.routerOutletName] === routeCommand.routeParams[0]) {
            currentSubformMagicService.router.navigate([{ outlets: { [routeCommand.routerOutletName]: null } }], { relativeTo: relativeRoute })
                .then((result) => {
                SubformMagicService.currentCallerMgSubformServiceRef = currentSubformMagicService;
                currentSubformMagicService.currentRouteDefinition = {
                    formName: routeCommand.formName,
                    parameters: routeCommand.parameters
                };
                currentSubformMagicService.PerformRouterNavigate(routeCommand.routerOutletName, routeCommand.routeParams);
            });
        }
        else {
            SubformMagicService.currentCallerMgSubformServiceRef = currentSubformMagicService;
            currentSubformMagicService.currentRouteDefinition = {
                formName: routeCommand.formName,
                parameters: routeCommand.parameters
            };
            if (SubformMagicService.routerContainers.length > 0) {
                let routeContainer = SubformMagicService.routerContainers[0];
                SubformMagicService.routerContainers.shift();
                routeContainer.initializeComponent();
            }
            else {
                currentSubformMagicService.PerformRouterNavigate(routeCommand.routerOutletName, routeCommand.routeParams);
            }
        }
    }
    PerformRouterNavigate(routerOutletName, routeParams) {
        let relativeRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
        this.router.navigate([{ outlets: { [routerOutletName]: routeParams } }], { relativeTo: relativeRoute })
            .then((result) => {
            if (result !== null && !result) {
                let subformMagicService = SubformMagicService.currentCallerMgSubformServiceRef;
                subformMagicService.currentRouteDefinition = null;
                SubformMagicService.currentCallerMgSubformServiceRef = null;
                subformMagicService.pendingCommandsCollector.stopCollecting();
                subformMagicService.routerCommandsMagicService.ExecuteNextCommand();
            }
        });
    }
    init() {
        const pendingCommands = this.pendingCommandsCollector.GetCommands(this.task.taskId);
        if (pendingCommands.length > 0) {
            pendingCommands.forEach(command => { this.task.executeCommand(command); });
            this.task.refreshView();
        }
        this.pendingCommandsCollector.stopCollecting();
    }
    refreshView() {
        this.task.refreshView();
    }
    static getRelativeRoute(sendActivatedRoute) {
        let currentActiveRoute = sendActivatedRoute;
        if (currentActiveRoute.snapshot.routeConfig !== null && currentActiveRoute.snapshot.routeConfig.path === '') {
            currentActiveRoute = currentActiveRoute.parent;
            if (!currentActiveRoute.snapshot.routeConfig.loadChildren)
                console.log('getRelativeRoute(): both path and currentActiveRoute.snapshot.routeConfig.loadChildren are empty.');
        }
        return currentActiveRoute;
    }
}
SubformMagicService.currentCallerMgSubformServiceRef = null;
SubformMagicService.routerContainers = new Array();
SubformMagicService.ɵfac = function SubformMagicService_Factory(t) { return new (t || SubformMagicService)(i0.ɵɵinject(TaskMagicService), i0.ɵɵinject(i2.ActivatedRoute), i0.ɵɵinject(ComponentListMagicService), i0.ɵɵinject(CommandsCollectorMagicService), i0.ɵɵinject(i2.Router), i0.ɵɵinject(RouterCommandsMagicService), i0.ɵɵinject(ComponentListMagicService), i0.ɵɵinject(MagicLazyLoaderService), i0.ɵɵinject(i0.Injector), i0.ɵɵinject(i0.Compiler)); };
SubformMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: SubformMagicService, factory: SubformMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SubformMagicService, [{
        type: Injectable
    }], function () { return [{ type: TaskMagicService }, { type: i2.ActivatedRoute }, { type: ComponentListMagicService }, { type: CommandsCollectorMagicService }, { type: i2.Router }, { type: RouterCommandsMagicService }, { type: ComponentListMagicService }, { type: MagicLazyLoaderService }, { type: i0.Injector }, { type: i0.Compiler }]; }, null); })();

class RouterContainerMagicComponent {
    static get LastRoute() {
        return RouterContainerMagicComponent.lastRoute;
    }
    constructor(activatedRoute, router, magic, containerTaskService, componentFactoryResolver, viewContainerRef, componentList, pendingCommandsCollector, routerCommandsMagicService) {
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.magic = magic;
        this.containerTaskService = containerTaskService;
        this.componentFactoryResolver = componentFactoryResolver;
        this.viewContainerRef = viewContainerRef;
        this.componentList = componentList;
        this.pendingCommandsCollector = pendingCommandsCollector;
        this.routerCommandsMagicService = routerCommandsMagicService;
        this.componentRef = null;
        this.parentMgSubformService = null;
    }
    ngOnInit() {
        let subformMagicService = SubformMagicService.currentCallerMgSubformServiceRef;
        let currentActiveRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
        RouterContainerMagicComponent.lastRoute = this.router.url;
        if (subformMagicService == null || subformMagicService.currentRouteDefinition === null) {
            this.insertRouteEvent(currentActiveRoute);
            SubformMagicService.routerContainers.push(this);
        }
        else {
            this.initializeComponent();
        }
    }
    insertRouteEvent(currentActiveRoute) {
        let guiEvent = getGuiEventObj('RouterNavigate', null, 0);
        guiEvent.RouterPath = currentActiveRoute.snapshot.routeConfig.path;
        if (currentActiveRoute.snapshot.outlet !== 'primary')
            guiEvent.RouterOutletName = currentActiveRoute.snapshot.outlet;
        let calcRouterPath = currentActiveRoute.routeConfig.path;
        if (calcRouterPath.length > 0) {
            let routerPath = calcRouterPath;
            let tokens = StrUtil.tokenize(routerPath, "/:");
            guiEvent.RouterPath = tokens[0];
            guiEvent.RouterParams = new List();
            for (let i = 1; i < tokens.length; i++) {
                guiEvent.RouterParams.push(currentActiveRoute.snapshot.params[tokens[i]]);
            }
        }
        this.containerTaskService.insertEvent(guiEvent);
    }
    initializeComponent() {
        let subformMagicService = SubformMagicService.currentCallerMgSubformServiceRef;
        if (subformMagicService.currentRouteDefinition !== null) {
            let comp = this.componentList.getComponent(subformMagicService.currentRouteDefinition.formName);
            const componentFactory = this.componentFactoryResolver.resolveComponentFactory(comp);
            this.componentRef = this.viewContainerRef.createComponent(componentFactory);
            Object.assign(this.componentRef.instance, subformMagicService.currentRouteDefinition.parameters);
            let myActiveRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
            let routeParams = StrUtil.tokenize(myActiveRoute.snapshot.routeConfig.path, "/:");
            subformMagicService.routesDict[myActiveRoute.snapshot.outlet] = routeParams[0];
            this.parentMgSubformService = subformMagicService;
            subformMagicService.currentRouteDefinition = null;
            SubformMagicService.currentCallerMgSubformServiceRef = null;
            let ignoreParamChange = true;
            myActiveRoute.paramMap.subscribe(params => {
                if (!ignoreParamChange)
                    this.insertRouteEvent(myActiveRoute);
                ignoreParamChange = false;
            });
            this.parentMgSubformService.refreshView();
            this.routerCommandsMagicService.ExecuteNextCommand();
        }
    }
    ngOnDestroy() {
        if (this.componentRef != null) {
            this.componentRef.instance.task.close();
            let currentActiveRoute = SubformMagicService.getRelativeRoute(this.activatedRoute);
            this.parentMgSubformService.routesDict[currentActiveRoute.outlet] = "";
            RouterContainerMagicComponent.lastRoute = this.router.url;
        }
    }
}
RouterContainerMagicComponent.lastRoute = "/";
RouterContainerMagicComponent.ɵfac = function RouterContainerMagicComponent_Factory(t) { return new (t || RouterContainerMagicComponent)(i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(i2.Router), i0.ɵɵdirectiveInject(EngineMagicService), i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(i0.ComponentFactoryResolver), i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(ComponentListMagicService), i0.ɵɵdirectiveInject(CommandsCollectorMagicService), i0.ɵɵdirectiveInject(RouterCommandsMagicService)); };
RouterContainerMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: RouterContainerMagicComponent, selectors: [["magic-route-outlet"]], decls: 0, vars: 0, template: function RouterContainerMagicComponent_Template(rf, ctx) { }, encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RouterContainerMagicComponent, [{
        type: Component,
        args: [{
                selector: 'magic-route-outlet',
                template: `
  `
            }]
    }], function () { return [{ type: i2.ActivatedRoute }, { type: i2.Router }, { type: EngineMagicService }, { type: TaskMagicService }, { type: i0.ComponentFactoryResolver }, { type: i0.ViewContainerRef }, { type: ComponentListMagicService }, { type: CommandsCollectorMagicService }, { type: RouterCommandsMagicService }]; }, null); })();

class GuiInteractiveExecutor {
    Run() {
        try {
            switch (this.command._commandType) {
                case InteractiveCommandType.GET_VALUE:
                    this.onValue();
                    break;
                case InteractiveCommandType.GET_ROWS_IN_PAGE:
                    this.onGetRowsInPage();
                    break;
                case InteractiveCommandType.GET_MAX_ROWS_IN_PAGINATED_TABLE:
                    this.onGetMaxRowsInPaginatedTable();
                    break;
                case InteractiveCommandType.MESSAGE_BOX:
                    this.OnMessageBox();
                    break;
                case InteractiveCommandType.GET_TOP_INDEX:
                    this.OnGetTopIndex();
                    break;
                case InteractiveCommandType.GET_IS_ROW_EDITING:
                    this.OnGetIsRowEditing();
                    break;
                case InteractiveCommandType.SET_TITLE:
                    this.OnSetTitle();
                    break;
                case InteractiveCommandType.REFRESH_PAGE:
                    this.OnRefreshPage();
                    break;
                case InteractiveCommandType.GET_LAST_ROUTE:
                    this.OnGetLastRoute();
                    break;
            }
        }
        catch (ex) {
            throw ex;
        }
    }
    static executeInteractiveCommand(task, guiIntactiveCommand, overlayService) {
        let executor = new GuiInteractiveExecutor();
        executor.task = task;
        executor.command = guiIntactiveCommand;
        executor.overlayService = overlayService;
        executor.Run();
    }
    onValue() {
        let guiRowId = this.task.getGuiRowId(+this.command._line, this.task.isTableControl(this.command.controlName) || this.command._obj2.IsTableChild);
        let result = this.task.getFormControl(guiRowId.toString(), this.command.controlName);
        let val;
        if (!isNullOrUndefined(result)) {
            val = result.value;
        }
        else if (this.task.isTableControl(this.command.controlName))
            val = this.task.getValue(this.command.controlName, guiRowId.toString());
        val = this.task.ConvertValToNative(this.command.controlName, guiRowId, val);
        this.command._mgValue.obj = val;
    }
    onGetRowsInPage() {
        this.command._intVal1 = this.task.tableService.getPageSize();
        if (this.task.oldPageSize == 0)
            this.task.oldPageSize = this.command._intVal1;
    }
    onGetMaxRowsInPaginatedTable() {
        this.command._intVal1 = this.task.tableService.getMaxRowsInTable();
    }
    OnMessageBox() {
        this.overlayService.openConfirmationBox(this.command._mgValue.title, this.command._mgValue.str, this.command._mgValue.style);
    }
    OnSetTitle() {
        this.task.setTitle(this.command._mgValue.title);
    }
    OnRefreshPage() {
        let navigateToRootRoute = this.command._boolVal;
        let initialUrl = this.command._obj1;
        if (navigateToRootRoute)
            window.location.replace(initialUrl);
        else
            window.location.reload();
    }
    OnGetTopIndex() {
        this.command._intVal1 = this.task.tableService.getTableTopIndex();
    }
    OnGetIsRowEditing() {
        let dvRowIndex = this.command._intVal1;
        let guiRowIndex = this.task.getGuiRowId(dvRowIndex, true);
        let isLineMode = this.command._boolVal;
        if (isLineMode && (isNullOrUndefined(guiRowIndex) || isNullOrUndefined(this.task.Records.list[guiRowIndex])))
            this.command._boolVal = false;
        else
            this.command._boolVal = this.task.Records.list[guiRowIndex].isEditing;
    }
    OnGetLastRoute() {
        this.command.resultString = RouterContainerMagicComponent.LastRoute;
    }
}

let BaseMagicOverlayContainer = class BaseMagicOverlayContainer {
};
__decorate([
    Input(),
    __metadata("design:type", Object)
], BaseMagicOverlayContainer.prototype, "ModalComp", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], BaseMagicOverlayContainer.prototype, "ModalCompParameters", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], BaseMagicOverlayContainer.prototype, "onClose", void 0);
BaseMagicOverlayContainer = __decorate([
    Input(),
    Output()
], BaseMagicOverlayContainer);

class MagicViewContainerRef {
    constructor(vcRef) {
        this.vcRef = vcRef;
        let comp = (this.vcRef._hostLView).find(v => v != null && !isNullOrUndefined(v.setViewContainerRef));
        comp.setViewContainerRef(vcRef);
    }
}
MagicViewContainerRef.ɵfac = function MagicViewContainerRef_Factory(t) { return new (t || MagicViewContainerRef)(i0.ɵɵdirectiveInject(i0.ViewContainerRef)); };
MagicViewContainerRef.ɵdir = i0.ɵɵdefineDirective({ type: MagicViewContainerRef, selectors: [["", "magicViewContainerRef", ""]] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicViewContainerRef, [{
        type: Directive,
        args: [{
                selector: '[magicViewContainerRef]',
            }]
    }], function () { return [{ type: i0.ViewContainerRef }]; }, null); })();

const _c0$3 = ["modalheader"];
const _c1$1 = ["modalForeground"];
function MagicOverlayContainer_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 8);
    i0.ɵɵlistener("click", function MagicOverlayContainer_button_2_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r4 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r4.OnClose()); });
    i0.ɵɵtext(1, "X");
    i0.ɵɵelementEnd();
} }
function MagicOverlayContainer_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r8 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 9, 10);
    i0.ɵɵtext(2);
    i0.ɵɵelementStart(3, "button", 11);
    i0.ɵɵlistener("click", function MagicOverlayContainer_div_5_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r8); const ctx_r7 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r7.OnClose()); });
    i0.ɵɵtext(4, "X");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", ctx_r2.getText(), " ");
} }
class MagicOverlayContainer extends BaseMagicOverlayContainer {
    constructor(componentFactoryResolver) {
        super();
        this.componentFactoryResolver = componentFactoryResolver;
        this.ModalComp = null;
        this.ModalCompParameters = {};
        this.onClose = new EventEmitter();
        this.componentRef = null;
    }
    ngOnInit() {
        const factory = this.componentFactoryResolver.resolveComponentFactory(this.ModalComp);
        this.componentRef = this.modalbodyViewContainerRef.createComponent(factory);
        Object.assign(this.componentRef.instance, this.ModalCompParameters);
    }
    setViewContainerRef(vcRef) {
        this.modalbodyViewContainerRef = vcRef;
    }
    getText() {
        if (this.componentRef !== null) {
            let comp = this.componentRef.instance;
            return comp.FormName();
        }
        else
            return '';
    }
    getStyle() {
        let styles = {};
        if (this.componentRef != undefined) {
            let comp = this.componentRef.instance;
            styles['width'] = comp.Width();
            styles['height'] = comp.Height();
            if (comp.IsCenteredToWindow()) {
                styles['margin'] = 'auto';
            }
            else {
                styles['margin-left'] = comp.X() + 'px';
                styles['margin-top'] = comp.Y() + 'px';
            }
        }
        return styles;
    }
    getClientAreaStyles() {
        let styles = {};
        if (this.componentRef != undefined) {
            const headerHeight = this.getShowTitleBar() && !isNullOrUndefined(this.headerElementRef) ? (this.headerElementRef.nativeElement.offsetHeight + 1) : 0;
            if (!isNullOrUndefined(this.foregroundElementRef)) {
                const foregroundHeight = this.foregroundElementRef.nativeElement.offsetHeight;
                styles['height'] = (foregroundHeight - headerHeight) + 'px';
                const foregroundWidth = this.foregroundElementRef.nativeElement.offsetWidth;
                styles['width'] = (foregroundWidth) + 'px';
            }
            styles['overflow'] = 'auto';
        }
        return styles;
    }
    getShowTitleBar() {
        if (this.componentRef != undefined) {
            let comp = this.componentRef.instance;
            return comp.ShowTitleBar();
        }
    }
    OnClose() {
        this.onClose.emit();
    }
    OnBackgroundClick() {
        let comp = this.componentRef.instance;
        if (comp.ShouldCloseOnBackgroundClick())
            this.OnClose();
    }
}
MagicOverlayContainer.ɵfac = function MagicOverlayContainer_Factory(t) { return new (t || MagicOverlayContainer)(i0.ɵɵdirectiveInject(i0.ComponentFactoryResolver)); };
MagicOverlayContainer.ɵcmp = i0.ɵɵdefineComponent({ type: MagicOverlayContainer, selectors: [["app-magic-overlay-container"]], viewQuery: function MagicOverlayContainer_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0$3, 5);
        i0.ɵɵviewQuery(_c1$1, 5);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.headerElementRef = _t.first);
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.foregroundElementRef = _t.first);
    } }, inputs: { ModalComp: "ModalComp", ModalCompParameters: "ModalCompParameters" }, outputs: { onClose: "onClose" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 9, vars: 4, consts: [[1, "modal-background", 3, "click"], ["tabindex", "-1", "style", "float:right; border: none; background-color: transparent; outline: none; color: white", 3, "click", 4, "ngIf"], [1, "modal-foreground", 3, "ngStyle"], ["modalForeground", ""], ["class", "modal-header", 4, "ngIf"], [3, "ngStyle"], ["magicViewContainerRef", ""], ["modalbody", ""], ["tabindex", "-1", 2, "float", "right", "border", "none", "background-color", "transparent", "outline", "none", "color", "white", 3, "click"], [1, "modal-header"], ["modalheader", ""], ["tabindex", "-1", 2, "float", "right", 3, "click"]], template: function MagicOverlayContainer_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div")(1, "div", 0);
        i0.ɵɵlistener("click", function MagicOverlayContainer_Template_div_click_1_listener() { return ctx.OnBackgroundClick(); });
        i0.ɵɵtemplate(2, MagicOverlayContainer_button_2_Template, 2, 0, "button", 1);
        i0.ɵɵelementEnd();
        i0.ɵɵelementStart(3, "div", 2, 3);
        i0.ɵɵtemplate(5, MagicOverlayContainer_div_5_Template, 5, 1, "div", 4);
        i0.ɵɵelementStart(6, "div", 5);
        i0.ɵɵelement(7, "div", 6, 7);
        i0.ɵɵelementEnd()()();
    } if (rf & 2) {
        i0.ɵɵadvance(2);
        i0.ɵɵproperty("ngIf", !ctx.getShowTitleBar());
        i0.ɵɵadvance(1);
        i0.ɵɵproperty("ngStyle", ctx.getStyle());
        i0.ɵɵadvance(2);
        i0.ɵɵproperty("ngIf", ctx.getShowTitleBar());
        i0.ɵɵadvance(1);
        i0.ɵɵproperty("ngStyle", ctx.getClientAreaStyles());
    } }, dependencies: [i1.NgIf, i1.NgStyle, MagicViewContainerRef], styles: [".modal-foreground[_ngcontent-%COMP%]{position:fixed;inset:0;background-color:#fff}.modal-background[_ngcontent-%COMP%]{position:fixed;inset:0;background-color:#000;opacity:.75}.modal-header[_ngcontent-%COMP%]{background-color:beige;border-bottom:2px solid red}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicOverlayContainer, [{
        type: Component,
        args: [{ selector: 'app-magic-overlay-container', template: `
    <div>
      <div class="modal-background" (click)="OnBackgroundClick()">
        <button (click)="OnClose()" tabindex="-1" style="float:right; border: none; background-color: transparent; outline: none; color: white" *ngIf="!getShowTitleBar()">X</button>
      </div>
      <div #modalForeground class="modal-foreground" [ngStyle]="getStyle()">
        <div #modalheader class="modal-header" *ngIf="getShowTitleBar()">
          {{getText()}}
          <button (click)="OnClose()" style="float:right" tabindex="-1">X</button>
        </div>
        <div [ngStyle]="getClientAreaStyles()">
          <div #modalbody magicViewContainerRef>
          </div>
        </div>
      </div>
    </div>
  `, styles: [".modal-foreground{position:fixed;inset:0;background-color:#fff}.modal-background{position:fixed;inset:0;background-color:#000;opacity:.75}.modal-header{background-color:beige;border-bottom:2px solid red}\n"] }]
    }], function () { return [{ type: i0.ComponentFactoryResolver }]; }, { headerElementRef: [{
            type: ViewChild,
            args: ['modalheader', { static: false }]
        }], foregroundElementRef: [{
            type: ViewChild,
            args: ['modalForeground', { static: false }]
        }], ModalComp: [{
            type: Input
        }], ModalCompParameters: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();

class OverlayContainerMagicProvider {
    getComponent() {
        return MagicOverlayContainer;
    }
}
OverlayContainerMagicProvider.ɵfac = function OverlayContainerMagicProvider_Factory(t) { return new (t || OverlayContainerMagicProvider)(); };
OverlayContainerMagicProvider.ɵprov = i0.ɵɵdefineInjectable({ token: OverlayContainerMagicProvider, factory: OverlayContainerMagicProvider.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(OverlayContainerMagicProvider, [{
        type: Injectable
    }], null, null); })();

class BaseMagicConfirmComponent {
    constructor() {
        this.onClose = new EventEmitter();
    }
    OnClose(result) {
        this.onClose.emit(result);
    }
}
BaseMagicConfirmComponent.ɵfac = function BaseMagicConfirmComponent_Factory(t) { return new (t || BaseMagicConfirmComponent)(); };
BaseMagicConfirmComponent.ɵcmp = i0.ɵɵdefineComponent({ type: BaseMagicConfirmComponent, selectors: [["mg-base-alert"]], inputs: { title: "title", message: "message" }, outputs: { onClose: "onClose" }, decls: 0, vars: 0, template: function BaseMagicConfirmComponent_Template(rf, ctx) { } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseMagicConfirmComponent, [{
        type: Component,
        args: [{ selector: 'mg-base-alert', template: '' }]
    }], null, { title: [{
            type: Input
        }], message: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();

class BaseMagicAlertComponent {
    constructor() {
        this.onClose = new EventEmitter();
    }
    OnClose() {
        this.onClose.emit();
    }
}
BaseMagicAlertComponent.ɵfac = function BaseMagicAlertComponent_Factory(t) { return new (t || BaseMagicAlertComponent)(); };
BaseMagicAlertComponent.ɵcmp = i0.ɵɵdefineComponent({ type: BaseMagicAlertComponent, selectors: [["mg-base-alert"]], inputs: { title: "title", message: "message" }, outputs: { onClose: "onClose" }, decls: 0, vars: 0, template: function BaseMagicAlertComponent_Template(rf, ctx) { } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseMagicAlertComponent, [{
        type: Component,
        args: [{ selector: 'mg-base-alert', template: '' }]
    }], null, { title: [{
            type: Input
        }], message: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();

class MagicFocusDirective {
    constructor(hostElement) {
        this.hostElement = hostElement;
    }
    ngAfterViewInit() {
        this.hostElement.nativeElement.focus();
    }
}
MagicFocusDirective.ɵfac = function MagicFocusDirective_Factory(t) { return new (t || MagicFocusDirective)(i0.ɵɵdirectiveInject(i0.ElementRef)); };
MagicFocusDirective.ɵdir = i0.ɵɵdefineDirective({ type: MagicFocusDirective, selectors: [["", "magicFocus", ""]] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicFocusDirective, [{
        type: Directive,
        args: [{
                selector: '[magicFocus]'
            }]
    }], function () { return [{ type: i0.ElementRef }]; }, null); })();

const _c0$2 = ["overlayContainerWrapper"];
class MagicOverlayContainerWrapper {
    constructor(componentListMagicService, magicLazyModuleLoader, injector, componentFactoryResolver, changeDetectorRef, compiler) {
        this.componentListMagicService = componentListMagicService;
        this.magicLazyModuleLoader = magicLazyModuleLoader;
        this.injector = injector;
        this.componentFactoryResolver = componentFactoryResolver;
        this.changeDetectorRef = changeDetectorRef;
        this.compiler = compiler;
        this.Component = null;
        this.Parameters = {};
        this.onClose = new EventEmitter();
    }
    ngOnInit() {
        let moduleRef = this.componentListMagicService.getModuleRef(this.Parameters.MagicFormName);
        if (moduleRef == null) {
            let lazyLoadModule = this.componentListMagicService.getLazyLoadModuleData(this.Parameters.MagicFormName);
            if (lazyLoadModule != null) {
                let moduleName = lazyLoadModule.moduleName.replace("Magic", "");
                moduleName = moduleName.replace("Module", "");
                this.magicLazyModuleLoader.Load(moduleName).then(m => {
                    const compiled = this.compiler.compileModuleAndAllComponentsSync(m[lazyLoadModule.moduleName]);
                    moduleRef = compiled.ngModuleFactory.create(this.injector);
                    this.loadComponent(moduleRef);
                });
            }
            else {
                this.loadComponent(null);
            }
        }
        else
            this.loadComponent(moduleRef);
    }
    loadComponent(moduleRef) {
        this.Parameters.ModalComp = this.componentListMagicService.getComponent(this.Parameters.MagicFormName, !isNullOrUndefined(this.Parameters.MagicFormName));
        let factory;
        if (moduleRef != null)
            factory = moduleRef.componentFactoryResolver.resolveComponentFactory(this.Component);
        else
            factory = this.componentFactoryResolver.resolveComponentFactory(this.Component);
        let componentRef = this.overlayContentViewContainerRef.createComponent(factory);
        let allowedBaseComp = MagicOverlayContainerWrapper.allowedBaseComps.get(this.OverlayTypeParam);
        if (componentRef.instance instanceof allowedBaseComp.comp) {
            Object.assign(componentRef.instance, this.Parameters);
            componentRef.instance.onClose.subscribe((res) => {
                this.onClose.emit(res);
            });
        }
        else {
            let msg = "Provided  window container should subclass of : " + allowedBaseComp.error + "window will not work properly.";
            alert(msg);
        }
    }
    setViewContainerRef(vcRef) {
        this.overlayContentViewContainerRef = vcRef;
    }
    GetRootElement() {
        return this.overlayContainerWrapperElementRef.nativeElement;
    }
    DetectChanges() {
        this.changeDetectorRef.detectChanges();
    }
}
MagicOverlayContainerWrapper.allowedBaseComps = new Map([
    [OverlayType.Overlay, { comp: BaseMagicOverlayContainer, error: 'BaseMagicOverlayContainer . Overlay ' }],
    [OverlayType.Alert, { comp: BaseMagicAlertComponent, error: 'BaseMagicAlertComponent. Alert ' }],
    [OverlayType.ConfirmationBox, { comp: BaseMagicConfirmComponent, error: 'BaseMagicConfirmComponent. Confirmation ' }]
]);
MagicOverlayContainerWrapper.ɵfac = function MagicOverlayContainerWrapper_Factory(t) { return new (t || MagicOverlayContainerWrapper)(i0.ɵɵdirectiveInject(ComponentListMagicService), i0.ɵɵdirectiveInject(MagicLazyLoaderService), i0.ɵɵdirectiveInject(i0.Injector), i0.ɵɵdirectiveInject(i0.ComponentFactoryResolver), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i0.Compiler)); };
MagicOverlayContainerWrapper.ɵcmp = i0.ɵɵdefineComponent({ type: MagicOverlayContainerWrapper, selectors: [["app-magic-overlay-container-wrapper"]], viewQuery: function MagicOverlayContainerWrapper_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0$2, 7);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.overlayContainerWrapperElementRef = _t.first);
    } }, inputs: { Component: "Component", Parameters: "Parameters", OverlayTypeParam: "OverlayTypeParam" }, outputs: { onClose: "onClose" }, decls: 7, vars: 0, consts: [["tabIndex", "0", "magicFocus", "", 1, "overlay-container-wrapper-background", 2, "width", "0px", "height", "0px"], [1, "overlay-container-wrapper-background"], ["overlayContainerWrapper", ""], ["magicViewContainerRef", ""], ["overlayContent", ""], ["tabIndex", "0", 1, "overlay-container-wrapper-background", 2, "width", "0px", "height", "0px"]], template: function MagicOverlayContainerWrapper_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div");
        i0.ɵɵelement(1, "div", 0);
        i0.ɵɵelementStart(2, "div", 1, 2);
        i0.ɵɵelement(4, "div", 3, 4);
        i0.ɵɵelementEnd();
        i0.ɵɵelement(6, "div", 5);
        i0.ɵɵelementEnd();
    } }, dependencies: [MagicFocusDirective, MagicViewContainerRef], styles: [".overlay-container-wrapper-background[_ngcontent-%COMP%]{position:fixed;z-index:999;inset:0}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicOverlayContainerWrapper, [{
        type: Component,
        args: [{ selector: 'app-magic-overlay-container-wrapper', template: `
    <div>
      <div class="overlay-container-wrapper-background" tabIndex="0" style="width: 0px; height: 0px;" magicFocus></div>
      <div class="overlay-container-wrapper-background" #overlayContainerWrapper>
        <div #overlayContent magicViewContainerRef>
        </div>
      </div>
      <div class="overlay-container-wrapper-background" tabIndex="0" style="width: 0px; height: 0px;" ></div>
    </div>
  `, styles: [".overlay-container-wrapper-background{position:fixed;z-index:999;inset:0}\n"] }]
    }], function () { return [{ type: ComponentListMagicService }, { type: MagicLazyLoaderService }, { type: i0.Injector }, { type: i0.ComponentFactoryResolver }, { type: i0.ChangeDetectorRef }, { type: i0.Compiler }]; }, { Component: [{
            type: Input
        }], Parameters: [{
            type: Input
        }], OverlayTypeParam: [{
            type: Input
        }], onClose: [{
            type: Output
        }], overlayContainerWrapperElementRef: [{
            type: ViewChild,
            args: ['overlayContainerWrapper', { static: true }]
        }] }); })();

class MagicAlertComponent extends BaseMagicAlertComponent {
}
MagicAlertComponent.ɵfac = function () { let ɵMagicAlertComponent_BaseFactory; return function MagicAlertComponent_Factory(t) { return (ɵMagicAlertComponent_BaseFactory || (ɵMagicAlertComponent_BaseFactory = i0.ɵɵgetInheritedFactory(MagicAlertComponent)))(t || MagicAlertComponent); }; }();
MagicAlertComponent.ɵcmp = i0.ɵɵdefineComponent({ type: MagicAlertComponent, selectors: [["sample-magic-alert-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 8, vars: 2, consts: [[1, "mg-message-background"], [3, "click"]], template: function MagicAlertComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "h2");
        i0.ɵɵtext(3);
        i0.ɵɵelementEnd();
        i0.ɵɵelementStart(4, "p");
        i0.ɵɵtext(5);
        i0.ɵɵelementEnd();
        i0.ɵɵelementStart(6, "button", 1);
        i0.ɵɵlistener("click", function MagicAlertComponent_Template_button_click_6_listener() { return ctx.OnClose(); });
        i0.ɵɵtext(7, "OK");
        i0.ɵɵelementEnd()()();
    } if (rf & 2) {
        i0.ɵɵadvance(3);
        i0.ɵɵtextInterpolate1(" ", ctx.title, "");
        i0.ɵɵadvance(2);
        i0.ɵɵtextInterpolate1("", ctx.message, " ");
    } }, styles: [".mg-message-background[_ngcontent-%COMP%]{background-color:#f5f5f5;width:40%;font-family:Open Sans,Helvetica Neue,Helvetica,Arial,sans-serif;padding:17px;border-radius:5px;text-align:center;margin-top:10%;margin-left:auto;margin-right:auto;border:1px solid gray}button[_ngcontent-%COMP%]{background-color:#8cd4f5;color:#fff;border:none;box-shadow:none;font-size:17px;font-weight:500;border-radius:5px;padding:10px 32px;margin:26px 5px 0;cursor:pointer}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicAlertComponent, [{
        type: Component,
        args: [{ selector: 'sample-magic-alert-component', template: `<div>
    <div class="mg-message-background">
      <h2> {{title}}</h2>
      <p>{{message}} </p>

      <button (click)="OnClose()">OK</button>
    </div>
  </div>`, styles: [".mg-message-background{background-color:#f5f5f5;width:40%;font-family:Open Sans,Helvetica Neue,Helvetica,Arial,sans-serif;padding:17px;border-radius:5px;text-align:center;margin-top:10%;margin-left:auto;margin-right:auto;border:1px solid gray}button{background-color:#8cd4f5;color:#fff;border:none;box-shadow:none;font-size:17px;font-weight:500;border-radius:5px;padding:10px 32px;margin:26px 5px 0;cursor:pointer}\n"] }]
    }], null, null); })();

class MagicConfirmationBoxComponent extends BaseMagicConfirmComponent {
}
MagicConfirmationBoxComponent.ɵfac = function () { let ɵMagicConfirmationBoxComponent_BaseFactory; return function MagicConfirmationBoxComponent_Factory(t) { return (ɵMagicConfirmationBoxComponent_BaseFactory || (ɵMagicConfirmationBoxComponent_BaseFactory = i0.ɵɵgetInheritedFactory(MagicConfirmationBoxComponent)))(t || MagicConfirmationBoxComponent); }; }();
MagicConfirmationBoxComponent.ɵcmp = i0.ɵɵdefineComponent({ type: MagicConfirmationBoxComponent, selectors: [["sample-magic-confirmation-box"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 11, vars: 2, consts: [[1, "mg-message-background"], [3, "click"], [1, "cancel", 3, "click"]], template: function MagicConfirmationBoxComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "h2");
        i0.ɵɵtext(3);
        i0.ɵɵelementEnd();
        i0.ɵɵtext(4);
        i0.ɵɵelement(5, "br")(6, "br");
        i0.ɵɵelementStart(7, "button", 1);
        i0.ɵɵlistener("click", function MagicConfirmationBoxComponent_Template_button_click_7_listener() { return ctx.OnClose(true); });
        i0.ɵɵtext(8, "OK");
        i0.ɵɵelementEnd();
        i0.ɵɵelementStart(9, "button", 2);
        i0.ɵɵlistener("click", function MagicConfirmationBoxComponent_Template_button_click_9_listener() { return ctx.OnClose(false); });
        i0.ɵɵtext(10, "Cancel");
        i0.ɵɵelementEnd()()();
    } if (rf & 2) {
        i0.ɵɵadvance(3);
        i0.ɵɵtextInterpolate1(" ", ctx.title, "");
        i0.ɵɵadvance(1);
        i0.ɵɵtextInterpolate1(" ", ctx.message, " ");
    } }, styles: [".mg-message-background[_ngcontent-%COMP%]{background-color:#f5f5f5;width:40%;font-family:Open Sans,Helvetica Neue,Helvetica,Arial,sans-serif;padding:17px;border-radius:5px;text-align:center;margin-top:10%;margin-left:auto;margin-right:auto;border:1px solid gray}button[_ngcontent-%COMP%]{background-color:#8cd4f5;color:#fff;border:none;box-shadow:none;font-size:17px;font-weight:500;border-radius:5px;padding:10px 32px;margin:26px 5px 0;cursor:pointer}button.cancel[_ngcontent-%COMP%]{background-color:#c1c1c1}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicConfirmationBoxComponent, [{
        type: Component,
        args: [{ selector: 'sample-magic-confirmation-box', template: `<div>
    <div class="mg-message-background">
      <h2> {{title}}</h2>
      {{message}}
      <br>
      <br>

      <button (click)="OnClose(true)">OK</button>
      <button class="cancel" (click)="OnClose(false)">Cancel</button>
    </div>
  </div>`, styles: [".mg-message-background{background-color:#f5f5f5;width:40%;font-family:Open Sans,Helvetica Neue,Helvetica,Arial,sans-serif;padding:17px;border-radius:5px;text-align:center;margin-top:10%;margin-left:auto;margin-right:auto;border:1px solid gray}button{background-color:#8cd4f5;color:#fff;border:none;box-shadow:none;font-size:17px;font-weight:500;border-radius:5px;padding:10px 32px;margin:26px 5px 0;cursor:pointer}button.cancel{background-color:#c1c1c1}\n"] }]
    }], null, null); })();

class ConfirmationComponentsMagicProvider {
    showDefaultConfirmations() {
        return true;
    }
    getAlertComponent() {
        return MagicAlertComponent;
    }
    getConfirmtionComponent() {
        return MagicConfirmationBoxComponent;
    }
}
ConfirmationComponentsMagicProvider.ɵfac = function ConfirmationComponentsMagicProvider_Factory(t) { return new (t || ConfirmationComponentsMagicProvider)(); };
ConfirmationComponentsMagicProvider.ɵprov = i0.ɵɵdefineInjectable({ token: ConfirmationComponentsMagicProvider, factory: ConfirmationComponentsMagicProvider.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ConfirmationComponentsMagicProvider, [{
        type: Injectable
    }], null, null); })();

class confirmationBox {
    static isConfirmBox(style) {
        let buttonMode = style & 0x0F;
        var isConfirm = (buttonMode === Styles.MSGBOX_BUTTON_OK_CANCEL) ||
            (buttonMode === Styles.MSGBOX_BUTTON_ABORT_RETRY_IGNORE) ||
            (buttonMode === Styles.MSGBOX_BUTTON_YES_NO_CANCEL) ||
            (buttonMode === Styles.MSGBOX_BUTTON_YES_NO) ||
            (buttonMode === Styles.MSGBOX_BUTTON_RETRY_CANCEL);
        return (isConfirm);
    }
    static convertToExcpectedResultBox(style, okWasPressed) {
        let buttonMode = style & 0x0F;
        let retValue = Styles.MSGBOX_RESULT_OK;
        if (buttonMode === Styles.MSGBOX_BUTTON_OK)
            retValue = Styles.MSGBOX_RESULT_OK;
        else if (buttonMode === Styles.MSGBOX_BUTTON_OK_CANCEL)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_OK : Styles.MSGBOX_RESULT_CANCEL;
        else if (buttonMode === Styles.MSGBOX_BUTTON_ABORT_RETRY_IGNORE)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_ABORT : Styles.MSGBOX_RESULT_RETRY;
        else if (buttonMode === Styles.MSGBOX_BUTTON_YES_NO_CANCEL)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_YES : Styles.MSGBOX_RESULT_NO;
        else if (buttonMode === Styles.MSGBOX_BUTTON_YES_NO)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_YES : Styles.MSGBOX_RESULT_NO;
        else if (buttonMode === Styles.MSGBOX_BUTTON_RETRY_CANCEL)
            retValue = okWasPressed ? Styles.MSGBOX_RESULT_RETRY : Styles.MSGBOX_RESULT_CANCEL;
        return retValue;
    }
    static showConfirmationBox(title, message, style) {
        let okWasPressed = false;
        let isConfirm = this.isConfirmBox(style);
        let titleAndString = title + '\n' + '\n' + message;
        if (isConfirm)
            okWasPressed = confirm(titleAndString);
        else {
            alert(titleAndString);
            okWasPressed = true;
        }
        return okWasPressed;
    }
}

class OverlayWindowService {
    constructor(componentFactoryResolver, componentList, engineMagicService, overlayContainerMagicProvider, confirmationComponentsMagicProvider) {
        this.componentFactoryResolver = componentFactoryResolver;
        this.componentList = componentList;
        this.engineMagicService = engineMagicService;
        this.overlayContainerMagicProvider = overlayContainerMagicProvider;
        this.confirmationComponentsMagicProvider = confirmationComponentsMagicProvider;
        this.overlayWindowFocusManager = null;
    }
    init(overlayWindowsContainerViewRef, rootMagicElement) {
        this.overlayWindowsContainerViewRef = overlayWindowsContainerViewRef;
        this.overlayWindowFocusManager = new OverlayWindowFocusManager(rootMagicElement);
    }
    open(formName, taskId, taskDescription) {
        let comp = this.componentList.lazyLoadModulesMap != null && this.componentList.lazyLoadModulesMap.hasOwnProperty(formName) ? null : this.componentList.getComponent(formName);
        let parameters = { taskIdParam: taskId, taskDescription: taskDescription };
        let componentRef = this.createModalComponent({ MagicFormName: formName, ModalComp: comp, ModalCompParameters: parameters }, this.overlayContainerMagicProvider.getComponent(), OverlayType.Overlay);
        componentRef.instance.onClose.subscribe(() => {
            let guiEvent = getGuiEventObj("close", null, 0);
            guiEvent.TaskID = taskId;
            this.engineMagicService.insertEvent(guiEvent);
        });
    }
    close(commandStr) {
        this.overlayWindowsContainerViewRef.remove();
        this.overlayWindowFocusManager.popDialog();
        let guiEvent1 = getGuiEventObj("dispose", null, 0);
        guiEvent1.TaskID = commandStr;
        this.engineMagicService.insertEvent(guiEvent1);
    }
    openConfirmationBox(title, msg, style) {
        if (this.confirmationComponentsMagicProvider.showDefaultConfirmations()) {
            let res = confirmationBox.showConfirmationBox(title, msg, style);
            this.finishConfirmation(style, res);
        }
        else {
            let comp = confirmationBox.isConfirmBox(style) ? this.confirmationComponentsMagicProvider.getConfirmtionComponent() : this.confirmationComponentsMagicProvider.getAlertComponent();
            let overlayType = confirmationBox.isConfirmBox(style) ? OverlayType.ConfirmationBox : OverlayType.Alert;
            let componentRef = this.createModalComponent({ title: title, message: msg }, comp, overlayType);
            componentRef.instance.onClose.subscribe((res) => {
                this.overlayWindowsContainerViewRef.remove();
                this.overlayWindowFocusManager.popDialog();
                this.finishConfirmation(style, res);
            });
        }
    }
    finishConfirmation(style, result) {
        let guiEvent = getGuiEventObj("confirmationClosed", null, 0);
        guiEvent.keyCode = confirmationBox.convertToExcpectedResultBox(style, result);
        this.engineMagicService.insertEvent(guiEvent);
    }
    createModalComponent(parameters, component, overlayType) {
        let componentRef;
        let magicModalContainerParameters = {
            Component: component,
            Parameters: parameters,
            OverlayTypeParam: overlayType
        };
        const factory = this.componentFactoryResolver.resolveComponentFactory(MagicOverlayContainerWrapper);
        let viewCRef = this.overlayWindowsContainerViewRef;
        componentRef = viewCRef.createComponent(factory);
        Object.assign(componentRef.instance, magicModalContainerParameters);
        this.overlayWindowFocusManager.pushDialog(componentRef.instance.GetRootElement());
        componentRef.instance.DetectChanges();
        return componentRef;
    }
}
OverlayWindowService.ɵfac = function OverlayWindowService_Factory(t) { return new (t || OverlayWindowService)(i0.ɵɵinject(i0.ComponentFactoryResolver), i0.ɵɵinject(ComponentListMagicService), i0.ɵɵinject(EngineMagicService), i0.ɵɵinject(OverlayContainerMagicProvider), i0.ɵɵinject(ConfirmationComponentsMagicProvider)); };
OverlayWindowService.ɵprov = i0.ɵɵdefineInjectable({ token: OverlayWindowService, factory: OverlayWindowService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(OverlayWindowService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i0.ComponentFactoryResolver }, { type: ComponentListMagicService }, { type: EngineMagicService }, { type: OverlayContainerMagicProvider }, { type: ConfirmationComponentsMagicProvider }]; }, null); })();
class OverlayWindowFocusManager {
    constructor(rootMagicElement) {
        this.rootMagicElement = null;
        this.openDialogList = new Array(0);
        this.ignoreUtilFocusChanges = false;
        this.lastFocus = null;
        this.focusListener = null;
        this.rootMagicElement = rootMagicElement;
    }
    pushDialog(rootElement) {
        if (this.openDialogList.length === 0) {
            this.focusListener = this.trapFocus.bind(this);
            document.addEventListener('focus', this.focusListener, true);
        }
        this.openDialogList.push(new DialogInfo(rootElement, (document.activeElement instanceof HTMLElement ? document.activeElement : null)));
    }
    popDialog() {
        const dialogInfo = this.openDialogList.pop();
        this.attemptFocus(dialogInfo.FocusElementOnClose);
        if (this.openDialogList.length === 0) {
            document.removeEventListener('focus', this.focusListener, true);
            this.focusListener = null;
        }
    }
    trapFocus(event) {
        if (this.ignoreUtilFocusChanges) {
            return;
        }
        if (this.openDialogList.length > 0) {
            var currentDialog = this.openDialogList[this.openDialogList.length - 1].RootElement;
            if (currentDialog.contains(event.target)) {
                this.lastFocus = event.target;
            }
            else {
                if (this.rootMagicElement.contains(event.target)) {
                    this.focusFirstDescendant(currentDialog);
                    if (this.lastFocus == document.activeElement) {
                        this.focusLastDescendant(currentDialog);
                    }
                }
                this.lastFocus = document.activeElement;
            }
        }
    }
    focusFirstDescendant(element) {
        for (var i = 0; i < element.childNodes.length; i++) {
            var child = element.childNodes[i];
            if (this.attemptFocus(child) ||
                this.focusFirstDescendant(child)) {
                return true;
            }
        }
        return false;
    }
    ;
    focusLastDescendant(element) {
        for (var i = element.childNodes.length - 1; i >= 0; i--) {
            var child = element.childNodes[i];
            if (this.attemptFocus(child) ||
                this.focusLastDescendant(child)) {
                return true;
            }
        }
        return false;
    }
    ;
    attemptFocus(element) {
        if (!this.isFocusable(element)) {
            return false;
        }
        this.ignoreUtilFocusChanges = true;
        try {
            element.focus();
        }
        catch (e) {
        }
        this.ignoreUtilFocusChanges = false;
        return (document.activeElement === element);
    }
    ;
    isFocusable(element) {
        if (isNullOrUndefined(element))
            return false;
        if (element.tabIndex > 0 || (element.tabIndex === 0 && element.getAttribute('tabIndex') !== null)) {
            return true;
        }
        else if (element.tabIndex < 0)
            return false;
        if (element.disabled) {
            return false;
        }
        switch (element.nodeName) {
            case 'A':
                return !!element.href && element.rel != 'ignore';
            case 'INPUT':
                return element.type != 'hidden' && element.type != 'file';
            case 'BUTTON':
            case 'SELECT':
            case 'TEXTAREA':
                return true;
            default:
                return false;
        }
    }
}
class DialogInfo {
    constructor(rootElement, focusElementOnClose) {
        this.rootElement = rootElement;
        this.focusElementOnClose = focusElementOnClose;
    }
    get RootElement() {
        return this.rootElement;
    }
    get FocusElementOnClose() {
        return this.focusElementOnClose;
    }
}

class TaskMagicService {
    constructor(magic, overlayWindowService) {
        this.magic = magic;
        this.overlayWindowService = overlayWindowService;
        this.Records = new Records();
        this.formGroups = [];
        this.refreshDom = new Subject();
        this.detectChanges = new Subject();
        this.interactiveCommands = new Subject();
        this.OnSelectedRowChanged = new EventEmitter();
        this.customPropertiesSubject = new Subject();
        this.recordsCountChangeSubject = new Subject();
        this.mgLoadSubject = new Subject();
        this.oldPageSize = 0;
        this.Records.setGuiTopIndex(0);
        this.mgInputDateFormat = null;
    }
    getIsLoggenIn() {
        return this.magic.getIsLoggedIn();
    }
    get taskId() {
        return this._taskId;
    }
    set taskId(value) {
        this._taskId = value;
    }
    get ScreenControlsData() {
        return this.Records.list['0'];
    }
    settemplate(value) {
        this.template = value;
    }
    buildScreenModeControls() {
        const group = new FormGroup({});
        for (const key in this.template) {
            if (this.template[key] == '0') {
                let fc = new FormControl('');
                this.setStubValue(0, fc, key);
                group.addControl(key, fc);
            }
        }
        this.ScreenModeControls = group;
    }
    isTableControl(id) {
        return this.template[id] == '1';
    }
    getMgInputDateFormat() { return this.mgInputDateFormat; }
    getFormControl(guiRowid, id) {
        let c;
        let group = this.isTableControl(id) ? this.formGroups[guiRowid] : this.ScreenModeControls;
        if (!isNullOrUndefined(group)) {
            group.get(id);
            c = group.controls[id];
        }
        return c;
    }
    setInputTextValue(controlId, guiRowid, val) {
        this.setValue(controlId, guiRowid, this.ConvertValToNative(controlId, 0, val));
        const fc = this.getFormControl(guiRowid, controlId);
        if (!isNullOrUndefined(val))
            fc.setValue(val);
    }
    buildTableRowControls(guiRowId) {
        const group = new FormGroup({});
        for (const key in this.template) {
            if (this.template[key] == '1') {
                let fc = new FormControl('');
                this.setStubValue(guiRowId, fc, key);
                group.addControl(key, fc);
            }
        }
        this.formGroups[guiRowId] = group;
    }
    updateRecordsBeforeCurrentView(value) {
        this.Records.recordsBeforeCurrentView = value;
    }
    setIncludesFirst(value) {
        this.Records.includesFirst = value;
    }
    setIncludesLast(value) {
        this.Records.includesLast = value;
    }
    markRowAsCreated(guiRowId) {
        this.Records.markRowAsCreated(guiRowId);
    }
    markRowAsNotCreated(guiRowId) {
        this.Records.markRowAsNotCreated(guiRowId);
    }
    startRowEditing(guiRowId) {
        this.Records.startRowEditing(guiRowId);
    }
    stopRowEditing(guiRowId) {
        this.Records.stopRowEditing(guiRowId);
    }
    isRowInRowEditing(guiRowId) {
        return this.Records.isRowInRowEditing(guiRowId);
    }
    setIsEmptyDataView(isEmpty) {
        if (this.Records.isEmptyDataView !== isEmpty) {
            if (isEmpty)
                this.recordsCountChangeSubject.next(0);
            this.Records.isEmptyDataView = isEmpty;
            this.tableService.refreshDataSource();
            this.refreshView();
        }
    }
    initTask(taskId, taskDescription) {
        this.Records.createFirst();
        this.oldPageSize = 0;
        if (this.IsStub()) {
            this.loadData();
        }
        else {
            this.taskId = taskId;
            this.settemplate(taskDescription);
        }
        this.buildScreenModeControls();
        if (!isNullOrUndefined(this.subscribeRefreshDom))
            this.subscribeRefreshDom.unsubscribe();
        if (!isNullOrUndefined(this.subscribeInteractiveCommands))
            this.subscribeInteractiveCommands.unsubscribe();
        this.subscribeRefreshDom = this.magic.refreshDom.pipe(filter(command => command.TaskTag === this.taskId))
            .subscribe(command => {
            this.executeCommand(command);
        });
        this.subscribeInteractiveCommands = this.magic.interactiveCommands
            .pipe(filter(command => command.TaskTag === this.taskId))
            .subscribe(command => {
            this.executeInteractiveCommand(command);
        });
    }
    refreshView() {
        this.detectChanges.next('');
    }
    insertEvent(guiEvent) {
        guiEvent.TaskID = this.taskId;
        this.magic.insertEvent(guiEvent);
    }
    GetControlPictureMask(controlName) {
        return this.magic.GetControlPictureMask(this.taskId, controlName);
    }
    ValidateControlValue(controlName, value) {
        return this.magic.ValidateControlValue(this.taskId, controlName, value);
    }
    GetRangedValue(controlName, value) {
        return this.magic.GetRangedValue(this.taskId, controlName, value);
    }
    GetFldRanges(controlName) {
        return this.magic.GetFldRanges(this.taskId, controlName);
    }
    getProperty(controlId, prop, guiRowId) {
        if (isNullOrUndefined(guiRowId))
            guiRowId = '0';
        if (this.IsStub())
            return this.getPropertyStub(this.Records.list[guiRowId], controlId, prop);
        else {
            let rec = this.Records.list[guiRowId];
            if (isNullOrUndefined(rec))
                debugger;
            else
                return this.Records.list[guiRowId].getProperty(controlId, prop);
        }
    }
    getPropertyStub(ControlsProperties, controlId, prop) {
        ControlsProperties = ControlsProperties.ControlsProperties;
        if (controlId in ControlsProperties) {
            if (prop in ControlsProperties[controlId].properties) {
                return ControlsProperties[controlId].properties[prop];
            }
        }
        return '';
    }
    getStyleStub(ControlsProperties, controlId, styleName) {
        ControlsProperties = ControlsProperties.ControlsProperties;
        return ControlsProperties[controlId].stylesMap.get(styleName);
    }
    getClasses(controlId, guiRowId) {
        if (isNullOrUndefined(guiRowId))
            guiRowId = '0';
        return this.Records.list[guiRowId].getControlMetadata(controlId).classes;
    }
    getStyle(controlId, styleName, guiRowId) {
        if (isNullOrUndefined(guiRowId))
            guiRowId = '0';
        if (this.IsStub())
            return this.getStyleStub(this.Records.list[guiRowId], controlId, styleName);
        else {
            let magicValue = this.Records.list[guiRowId].getControlMetadata(controlId).stylesMap.get(styleName);
            return StylesMapManager.magicValueGetStyle(styleName, magicValue);
        }
    }
    getValue(controlId, guiRowId) {
        if (isNullOrUndefined(guiRowId))
            guiRowId = '0';
        return this.Records.list.length > +guiRowId ? this.Records.list[guiRowId].values[controlId] : '';
    }
    getFormattedValue(controlName, val, rowId) {
        return this.magic.GetFormattedValue(this.taskId, controlName, val, rowId);
    }
    setValue(controlId, guiRowId, value) {
        return this.Records.list[guiRowId].setValue(controlId, value);
    }
    executeInteractiveCommand(guiInteractiveCommand) {
        GuiInteractiveExecutor.executeInteractiveCommand(this, guiInteractiveCommand, this.overlayWindowService);
        this.interactiveCommands.next(guiInteractiveCommand);
    }
    handleSetProperty(command, isTableChild) {
        let controlId = command.CtrlName;
        let dvRowId = (command.line || 0);
        let guiRowId = this.getGuiRowId(dvRowId, isTableChild);
        let properties;
        if (command.Operation === HtmlProperties.SelectedRow) {
            if (command.obj1 !== GuiConstants.NO_ROW_SELECTED) {
                guiRowId = this.getGuiRowId(command.obj1, true);
                properties = this.Records.list[guiRowId].getControlMetadata(controlId);
                properties.properties.set(command.Operation, command.line);
                this.tableService.selectRow(guiRowId.toString());
                this.OnSelectedRowChanged.emit(guiRowId.toString());
            }
        }
        else if (command.Operation === HtmlProperties.Enabled) {
            let c = this.getFormControl(guiRowId.toString(), controlId);
            if (!isNullOrUndefined(c)) {
                if (command.obj1)
                    c.enable();
                else
                    c.disable();
            }
            properties = this.Records.list[guiRowId].getControlMetadata(controlId);
            properties.properties.set(command.Operation, command.obj1);
        }
        else {
            properties = this.Records.list[guiRowId].getControlMetadata(controlId);
            properties.properties.set(command.Operation, command.obj1);
        }
    }
    executeCommand(command) {
        let dvRowId = (command.line || 0);
        let guiRowId = 0;
        let controlId = command.CtrlName;
        let properties;
        let isTableChild = this.isTableControl(controlId);
        if (command.obj !== null)
            isTableChild = isTableChild || command.obj.IsTableChild;
        guiRowId = this.getGuiRowId(dvRowId, isTableChild);
        switch (command.CommandType) {
            case CommandType.SET_IS_LOGGED_IN:
                break;
            case CommandType.SET_TABLE_TOP_INDEX:
                this.tableService.setTableTopIndex(command.number);
                break;
            case CommandType.REFRESH_TASK:
                this.tableService.refreshDataSource();
                this.refreshView();
                break;
            case CommandType.SET_TABLE_ITEMS_COUNT:
                if (!isUndefined(command.number)) {
                    this.tableService.updateTableSize(command.number);
                    if (command.number > 0 && this.Records.sizeUpdated &&
                        !this.Records.isEmptyDataView) {
                        this.recordsCountChangeSubject.next(command.number);
                        this.Records.sizeUpdated = false;
                    }
                }
                break;
            case CommandType.SET_CHUNK_SIZE:
                if (!isUndefined(command.number)) {
                    this.tableService.setChunkSize(command.number);
                }
                break;
            case CommandType.SET_RECORDS_BEFORE_CURRENT_VIEW:
                this.updateRecordsBeforeCurrentView(command.number);
                break;
            case CommandType.CREATE_TABLE_ROW:
                guiRowId = this.getGuiRowId(command.number, true);
                this.buildTableRowControls(guiRowId);
                this.markRowAsCreated(guiRowId);
                break;
            case CommandType.SET_IS_ROW_EDITING:
                guiRowId = this.getGuiRowId(command.line, command.value);
                this.startRowEditing(guiRowId);
                break;
            case CommandType.SET_NOT_IS_ROW_EDITING:
                guiRowId = this.getGuiRowId(command.line, command.value);
                this.stopRowEditing(guiRowId);
                break;
            case CommandType.UNDO_CREATE_TABLE_ROW:
                this.markRowAsNotCreated(this.getGuiRowId(command.number, true));
                break;
            case CommandType.SET_TABLE_INCLUDES_FIRST:
                this.setIncludesFirst(command.Bool1);
                break;
            case CommandType.SET_TABLE_INCLUDES_LAST:
                this.setIncludesLast(command.Bool1);
                break;
            case CommandType.SET_PROPERTY:
                this.handleSetProperty(command, isTableChild);
                if (command.Operation == HtmlProperties.ReadOnly ||
                    command.Operation == HtmlProperties.ItemsList)
                    this.refreshDom.next(command);
                break;
            case CommandType.PROP_SET_USER_PROPERTY:
                properties = this.Records.list[guiRowId].getControlMetadata(controlId);
                if (properties.userProperties.get(command.Operation) !== command.obj1) {
                    properties.userProperties.set(command.Operation, command.obj1);
                    this.customPropertiesSubject.next({ propertyName: controlId + '~' + command.Operation, value: command.obj1, rowId: guiRowId });
                }
                break;
            case CommandType.PROP_SET_CUSTOM_VALIDATOR:
                {
                    properties = this.Records.list[guiRowId].getControlMetadata(controlId);
                    let control = this.getFormControl(guiRowId.toString(), controlId);
                    if (control != null) {
                        properties.customValidators.set(command.Operation, command.obj1);
                        if (control.validator != null)
                            control.setValidators([control.validator, this.customValidator(guiRowId.toString(), controlId)]);
                        else
                            control.setValidators(this.customValidator(guiRowId.toString(), controlId));
                        control.updateValueAndValidity();
                    }
                }
                break;
            case CommandType.SET_CLASS:
                properties = this.Records.list[guiRowId].getControlMetadata(controlId);
                properties.setClass(command.Operation, command.obj1);
                break;
            case CommandType.SET_STYLE:
                properties = this.Records.list[guiRowId].getControlMetadata(controlId);
                properties.setStyle(command.Operation, command.obj1);
                break;
            case CommandType.SET_ATTRIBUTE:
                properties = this.Records.list[0].getControlMetadata(controlId);
                properties.dataType = String.fromCharCode(command.number);
                break;
            case CommandType.SET_VALUE:
                this.Records.list[guiRowId].values[controlId] = command.value;
                let c = this.getFormControl(guiRowId.toString(), controlId);
                if (!isNullOrUndefined(c)) {
                    c.setValue(this.ConvertValFromNative(controlId, command.line, command.value));
                }
                break;
            case CommandType.CREATE_SUB_FORM:
                this.mgSubformService.addSubformComp(command.CtrlName, command.userDropFormat.toString(), command.str, command.fileName, command.contextID, command.params, command.Bool1);
                break;
            case CommandType.CLOSE_SUB_FORM:
                this.mgSubformService.deleteSubformComp(command.CtrlName, command.userDropFormat.toString());
                break;
            case CommandType.SET_EMPTY_DATAVIEW:
                this.setIsEmptyDataView(command.Bool1);
                break;
            case CommandType.SET_FOCUS:
                this.refreshDom.next(command);
                break;
            case CommandType.SET_WC_IDLE:
                this.mgLoadSubject.next();
                break;
        }
    }
    customValidator(rowid, id) {
        return (control) => {
            let controlMetadata;
            controlMetadata = this.Records.list[rowid].getControlMetadata(id);
            for (let key of controlMetadata.customValidators.keys()) {
                let validator = controlMetadata.customValidators.get(key);
                if (!validator.isValid()) {
                    return { [key]: true };
                }
            }
            return null;
        };
    }
    ConvertValToNative(controlId, rowId, val) {
        let properties;
        properties = this.Records.list[0].getControlMetadata(controlId);
        switch (properties.dataType) {
            case StorageAttribute.BOOLEAN: {
                if (typeof val === 'string') {
                    let ranges = this.GetFldRanges(controlId);
                    let found = ranges.indexOf(',');
                    let trueOption = ranges.substr(0, found);
                    let falseOption = ranges.substr(found + 1);
                    if (NString.Equals(val, trueOption, true))
                        return true;
                    else if (NString.Equals(val, falseOption, true))
                        return false;
                    else
                        return val;
                }
                else
                    return val;
            }
            case StorageAttribute.TIME: {
                if (typeof val === 'string') {
                    let idx = val.indexOf(':', 0);
                    let hours = +val.substr(0, idx);
                    let minutes = +val.substr(idx + 1, 2);
                    let seconds = 0;
                    if (val.length > 5) {
                        idx = val.indexOf(':', idx + 1);
                        if (idx >= 0)
                            seconds = +val.substr(idx + 1, 2);
                    }
                    if (val.indexOf('PM') > 0)
                        hours += 12;
                    let dt = new Date();
                    dt.setHours(hours);
                    dt.setMinutes(minutes);
                    dt.setSeconds(seconds);
                    return dt;
                }
                else
                    return val;
            }
            case StorageAttribute.NUMERIC:
                if (isUndefined(val))
                    return val;
                else
                    return (val != null) ? +val : null;
            default:
                return val;
        }
    }
    ConvertValFromNative(controlId, rowId, val) {
        let properties;
        properties = this.Records.list[0].getControlMetadata(controlId);
        switch (properties.dataType) {
            case StorageAttribute.TIME: {
                if (val instanceof Date) {
                    let str = new StringBuilder();
                    let format = val.getHours() > 9 ? '{0}' : '0{0}';
                    str.AppendFormat(format, val.getHours().toString());
                    str.Append(':');
                    format = val.getMinutes() > 9 ? '{0}' : '0{0}';
                    str.AppendFormat(format, val.getMinutes().toString());
                    if (val.getSeconds() > 0) {
                        str.Append(':');
                        format = val.getSeconds() > 9 ? '{0}' : '0{0}';
                        str.AppendFormat(format, val.getSeconds().toString());
                    }
                    return str.ToString();
                }
                else
                    return val;
            }
            case StorageAttribute.BOOLEAN: {
                let properties;
                properties = this.Records.list['0'].getControlMetadata(controlId);
                if (typeof val === 'boolean' && properties.rangeValidator) {
                    let ranges = this.GetFldRanges(controlId);
                    let found = ranges.indexOf(',');
                    let trueOption = ranges.substr(0, found);
                    let falseOption = ranges.substr(found + 1);
                    if (val)
                        return trueOption;
                    else
                        return falseOption;
                }
                else
                    return val;
            }
            default:
                return val;
        }
    }
    resize(pageSize, topGuiRowId) {
        let guiEvent = getGuiEventObj('resize', 'table', 0);
        guiEvent.PageSize = pageSize;
        guiEvent.Line = topGuiRowId;
        this.insertEvent(guiEvent);
    }
    onScrollDown() {
        if (!this.Records.includesLast) {
            let guiEvent = getGuiEventObj('getRows', 'table', 0);
            guiEvent.Line = this.formGroups.length;
            this.insertEvent(guiEvent);
        }
    }
    setTitle(newTitle) {
        this.mgTitleService.setTitle(newTitle);
    }
    getGuiRowId(dvRowId, isTableControl) {
        return (isTableControl ? dvRowId + this.Records.recordsBeforeCurrentView : 0);
    }
    getDvRowId(guiRowId) {
        return (guiRowId - this.Records.recordsBeforeCurrentView);
    }
    dispose() {
        this.refreshDom.complete();
        this.detectChanges.complete();
        this.subscribeInteractiveCommands.unsubscribe();
        this.subscribeRefreshDom.unsubscribe();
        this.interactiveCommands.complete();
        this.customPropertiesSubject.complete();
        this.OnSelectedRowChanged.complete();
    }
    onComboboxSelectionChanged(event, idx, line) {
        let guiEvent = getGuiEventObj('selectionchanged', idx, line);
        if (typeof (event) == 'number') {
            guiEvent.Value = event;
        }
        else {
            if (!isNullOrUndefined(event.target)) {
                let indexes = new Array(event.target.selectedOptions.length);
                for (let i = 0; i < event.target.selectedOptions.length; i++) {
                    indexes[i] = event.target.selectedOptions[i].index;
                }
                guiEvent.Value = indexes.join(',');
            }
            else
                guiEvent.Value = event.value;
        }
        this.insertEvent(guiEvent);
    }
    onListBoxSelectionChanged(event, idx) {
        let guiEvent = getGuiEventObj('selectionchanged', idx, 0);
        let selectedOptions;
        if (!isNullOrUndefined(event.target))
            selectedOptions = event.target.selectedOptions;
        else
            selectedOptions = event.source.selectedOptions.selected;
        let length = selectedOptions.length;
        let indexes = new Array(length);
        for (let i = 0; i < length; i++) {
            if (!isNullOrUndefined(event.target))
                indexes[i] = (selectedOptions[i]).index;
            else
                indexes[i] = (selectedOptions[i]).value;
        }
        guiEvent.Value = indexes;
        this.insertEvent(guiEvent);
    }
    onCheckChanged(event, idx, rowId) {
        if (typeof rowId === 'undefined')
            rowId = 0;
        let guiEvent = getGuiEventObj('selectionchanged', idx, rowId);
        if (typeof (event) == 'boolean') {
            guiEvent.Value = event;
        }
        else {
            if (typeof event.target === 'undefined')
                guiEvent.Value = (event).checked;
            else
                guiEvent.Value = (event.target).checked;
        }
        this.insertEvent(guiEvent);
    }
    mgOnTabSelectionChanged(idx, layer) {
        let guiEvent = getGuiEventObj('selectionchanged', idx, 0);
        guiEvent.Value = layer.toString();
        this.insertEvent(guiEvent);
    }
    mgOnRadioSelectionChanged(idx) {
        let result = this.getFormControl('0', idx);
        let guiEvent = getGuiEventObj('selectionchanged', idx, 0);
        if (typeof result.value !== 'number')
            guiEvent.Value = result.value.index;
        else
            guiEvent.Value = result.value.toString();
        this.insertEvent(guiEvent);
    }
    close() {
        this.insertEvent(getGuiEventObj('close', null, 0));
    }
    IsStub() {
        return this.magic.isStub;
    }
    saveData(data) {
        this.magic.saveData(data);
    }
    createData() {
        let myData = {
            records: this.Records,
            template: this.template
        };
        let text = 'loadData():any   {\n' +
            '    let stubData = ' + JSON.stringify(myData) + ';\n' +
            '    this.loadStubData(stubData);}';
        console.log(text);
        this.saveData(text);
    }
    loadStubData(stubData) {
        this.Records = stubData.records;
        this.settemplate(stubData.template);
        this.taskId = '1';
        for (let i = 0; i < this.Records.list.length; i++)
            this.buildTableRowControls(i);
    }
    loadData() {
        alert('Please, overwrite method loadData');
    }
    setStubValue(guiRowId, fc, name) {
        if (this.IsStub()) {
            try {
                let val = this.Records.list[guiRowId].values[name];
                fc.setValue(val);
            }
            catch (e) {
            }
        }
    }
}
TaskMagicService.ɵfac = function TaskMagicService_Factory(t) { return new (t || TaskMagicService)(i0.ɵɵinject(EngineMagicService), i0.ɵɵinject(OverlayWindowService)); };
TaskMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: TaskMagicService, factory: TaskMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TaskMagicService, [{
        type: Injectable
    }], function () { return [{ type: EngineMagicService }, { type: OverlayWindowService }]; }, null); })();

class TableMagicService {
    constructor(componentList, task) {
        this.componentList = componentList;
        this.task = task;
        this.shouldOpenFieldTextEditor = true;
    }
    refreshDataSource() {
    }
    getPageSize() {
        return this.chunkSize;
    }
    setChunkSize(size) {
        this.chunkSize = size;
    }
    getMaxRowsInTable() {
        return this.task.Records.list.length;
    }
    selectRow(rowId) {
        this.selectedItem = rowId;
    }
    getSelectedRow() {
        return this.selectedItem;
    }
    selectedRow() {
        return null;
    }
    selectPage(pageId) {
    }
    OpenDialogForControl(element) {
        if (element.tagName === "MAT-SELECT" || element.tagName === "MAT-CHECKBOX" ||
            element.tagName === "INPUT" ||
            element.tagName === "SELECT")
            return false;
        return true;
    }
    getDialog() {
        return null;
    }
    onScrollDown() {
        this.task.onScrollDown();
    }
    sortData(e) { }
    mgOnPaginateChange(e, changeSelectedRow) { }
    mgOptionChanged(e) { }
    updateTableSize(size) {
        if (size === 0) {
            size = 1;
            this.task.Records.clearFirstTableRecord(this.task.template);
        }
        this.task.formGroups.length = size;
        this.task.Records.updateSize(size);
        this.task.setIncludesFirst(false);
    }
    setTableTopIndex(value) {
        if (!this.task.Records.includesFirst)
            value++;
        this.task.Records.setGuiTopIndex(value);
    }
    getTableTopIndex() {
        let topIndex = this.task.Records.getGuiTopIndex();
        if (!this.task.Records.includesFirst)
            topIndex--;
        return topIndex;
    }
}
TableMagicService.ɵfac = function TableMagicService_Factory(t) { return new (t || TableMagicService)(i0.ɵɵinject(ComponentListMagicService), i0.ɵɵinject(TaskMagicService)); };
TableMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: TableMagicService, factory: TableMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TableMagicService, [{
        type: Injectable
    }], function () { return [{ type: ComponentListMagicService }, { type: TaskMagicService }]; }, null); })();

class TitleMagicService {
    constructor(titleService) {
        this.titleService = titleService;
    }
    setTitle(newTitle) {
        this.titleService.setTitle(newTitle);
    }
}
TitleMagicService.ɵfac = function TitleMagicService_Factory(t) { return new (t || TitleMagicService)(i0.ɵɵinject(i1$1.Title)); };
TitleMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: TitleMagicService, factory: TitleMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TitleMagicService, [{
        type: Injectable
    }], function () { return [{ type: i1$1.Title }]; }, null); })();

let COLOR_FILE_NAME = new InjectionToken('colorFile', {
    providedIn: 'root',
    factory: () => 'clr_rnt.eng'
});
const MAGIC_FG_COLOR = 1;
const MAGIC_BG_COLOR = 2;
const SYSTEM_FG = 2;
const SYSTEM_BG = 4;
const SYSTEM_FG_AND_SYSTEM_BG = 6;
const TRANSPERENT_BG = 1;
class MagicColorService {
    getColorFilePath() {
        return 'assets/' + this.colorFileName;
    }
    constructor(http, colorFile1 = 'clr_rnt.eng') {
        this.http = http;
        this.colorFileName = 'clr_rnt.eng';
        this.fileNotFound = false;
        if (colorFile1)
            this.colorFileName = colorFile1;
        else
            this.colorFileName = 'clr_rnt.eng';
    }
    getColorData() {
        if (!this.colorsData) {
            this.http.get(this.getColorFilePath(), { responseType: 'text' }).subscribe(resp => {
                this.colorsData = resp.replace(/\n/g, '@').split('@');
            }, error1 => {
                console.error('File not found ' + this.colorFileName);
                this.fileNotFound = true;
            });
        }
    }
    hexToRgba(hex, isTransperent) {
        let shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])([a-f\d])$/i;
        hex = hex.replace(shorthandRegex, function (m, r, g, b, a) {
            return a + a + r + r + g + g + b + b;
        });
        let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
        let rgb = {
            'red': parseInt(result[4], 16),
            'green': parseInt(result[3], 16),
            'blue': parseInt(result[2], 16),
            'alpha': (255 - parseInt(result[1], 16)) / 255
        };
        if (isTransperent)
            rgb.alpha = 0;
        return 'rgba(' + rgb.red + ',' + rgb.green + ',' + rgb.blue + ',' + rgb.alpha + ')';
    }
    getColor(colorIndex, colorType) {
        let isTransperent = false;
        if (!this.colorsData && !this.fileNotFound)
            this.getColorData();
        if (this.colorsData) {
            if (this.colorsData[colorIndex - 1]) {
                const grayHashCode = '00808080';
                let hex = grayHashCode;
                let color = this.colorsData[colorIndex - 1].split(',');
                let colorAtrributes = +color[3];
                switch (colorType) {
                    case MAGIC_FG_COLOR:
                        if (colorAtrributes != SYSTEM_FG && colorAtrributes != SYSTEM_FG_AND_SYSTEM_BG)
                            hex = (color[1]);
                        break;
                    case MAGIC_BG_COLOR:
                        if (colorAtrributes != SYSTEM_BG && colorAtrributes != SYSTEM_FG_AND_SYSTEM_BG) {
                            if (colorAtrributes == TRANSPERENT_BG)
                                isTransperent = true;
                            hex = (color[2]);
                        }
                        break;
                    default:
                        console.log('Please enter valid color type : 1-FG, 2-BG ' + colorIndex);
                        return '';
                }
                return this.hexToRgba('#' + hex, isTransperent);
            }
            else
                console.log('Could not get color for number ' + colorIndex);
        }
        return '';
    }
}
MagicColorService.ɵfac = function MagicColorService_Factory(t) { return new (t || MagicColorService)(i0.ɵɵinject(i1$2.HttpClient), i0.ɵɵinject(COLOR_FILE_NAME)); };
MagicColorService.ɵprov = i0.ɵɵdefineInjectable({ token: MagicColorService, factory: MagicColorService.ɵfac, providedIn: 'root' });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicColorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1$2.HttpClient }, { type: undefined, decorators: [{
                type: Inject,
                args: [COLOR_FILE_NAME]
            }] }]; }, null); })();

class AccessorMagicService {
    constructor(task, magicColor) {
        this.task = task;
        this.magicColor = magicColor;
        this.Logger = null;
        this.hhmm = maskitoTimeOptionsGenerator({ mode: 'HH:MM' });
        this.hhmmss = maskitoTimeOptionsGenerator({ mode: 'HH:MM:SS' });
        this.Logger = Logger.Instance;
    }
    checkIsReadOnly(controlId) {
        let properties;
        properties = this.task.Records.list[0].getControlMetadata(controlId);
        if (properties.properties.get(HtmlProperties.ReadOnly) !== null && properties.properties.get(HtmlProperties.ReadOnly) === true)
            return true;
        else
            return false;
    }
    getText(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.Text, rowId);
    }
    getTabpageText(controlId, layer) {
        const items = this.task.getProperty(controlId, HtmlProperties.ItemsList);
        if (typeof items !== "undefined")
            return items[layer].displayValue;
        return "";
    }
    getImage(controlId, rowId) {
        let result = this.task.getProperty(controlId, HtmlProperties.Image, rowId);
        return result;
    }
    isImageExists(controlId, rowId) {
        let result = this.task.getProperty(controlId, HtmlProperties.Image, rowId);
        return !isNullOrUndefined(result);
    }
    getClasses(controlId, rowId) {
        return this.task.getClasses(controlId, rowId);
    }
    getStyle(controlId, styleName, rowId) {
        let style = this.task.getStyle(controlId, styleName, rowId);
        return style;
    }
    getVisible(controlId, rowId) {
        let vis = this.getProperty(controlId, HtmlProperties.Visible, rowId);
        return vis ? 'visible' : 'hidden';
    }
    getAlphaMask(controlId, rowId) {
        if (isNullOrUndefined(controlId))
            return null;
        let pic = this.task.GetControlPictureMask(controlId);
        let mask = pic.getMask();
        let valueStr = new StringBuilder();
        for (let i = 0; i < mask.length; i++) {
            switch (mask.charCodeAt(i)) {
                case PICInterface.PIC_N:
                    valueStr.Append("0");
                    break;
                case PICInterface.PIC_U:
                case PICInterface.PIC_L:
                case PICInterface.PIC_X:
                    valueStr.Append("A");
                    break;
                default:
                    valueStr.Append(mask.charAt(i));
                    break;
            }
        }
        return (pic != null) ? valueStr.toString() : null;
    }
    getNumericPicture(picture) {
        var obj = {};
        if (isNullOrUndefined(picture))
            return obj;
        let pic = new PIC(picture, StorageAttribute.NUMERIC, 0);
        obj['prefix'] = "";
        if (pic.getPosPref_().length > 0 && pic.getNegPref_().length > 0) {
            let pref = '-' + pic.getPosPref_();
            if (pref == pic.getNegPref_())
                obj['prefix'] = pic.getPosPref_();
        }
        if (pic.getPosSuff_().length > 0)
            obj['suffix'] = pic.getPosSuff_();
        else
            obj['suffix'] = "";
        if (pic.isNegative())
            obj['allowNegative'] = true;
        else
            obj['allowNegative'] = false;
        if (pic.getDec() >= 0)
            obj['precision'] = pic.getDec();
        if (pic.isLeft())
            obj['align'] = "left";
        obj['decimal'] = GuiEnvironment.Environment.GetDecimal();
        if (pic.withComa())
            obj['thousands'] = GuiEnvironment.Environment.GetThousands();
        else
            obj['thousands'] = "";
        if (pic.getWholes())
            obj['wholes'] = pic.getWholes();
        return obj;
    }
    getMustInput(controlId, rowId) {
        let vis = this.getProperty(controlId, HtmlProperties.MustInput, rowId);
        return vis ? 'true' : 'false';
    }
    isDisabled(controlId, rowId) {
        let result = this.getProperty(controlId, HtmlProperties.Enabled, rowId);
        return result === true ? null : true;
    }
    getProperty(controlId, prop, rowId) {
        return this.task.getProperty(controlId, prop, rowId);
    }
    getTitle(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.Tooltip, rowId);
    }
    getZoomButtonTitle(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.ZoomButtonTooltip, rowId);
    }
    getSelectedValue(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.SelectedValue, rowId);
    }
    getPlaceholder(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.PlaceHolder, rowId);
    }
    getType(controlId, rowId) {
        let result = this.task.getProperty(controlId, HtmlProperties.Password, rowId);
        return result ? "password" : "text";
    }
    getTabIndex(controlId, rowId) {
        return this.task.getProperty(controlId, HtmlProperties.TabIndex, rowId);
    }
    getValue(controlId, rowId) {
        let val = this.task.getValue(controlId, rowId);
        return val;
    }
    getFormattedValue(controlId, rowId) {
        let val = this.task.getValue(controlId, rowId);
        val = this.task.getFormattedValue(controlId, val, rowId);
        return val;
    }
    getPicture(controlId, rowId) {
        if (isNullOrUndefined(controlId))
            return null;
        let pic = this.task.GetControlPictureMask(controlId);
        return (pic != null) ? pic.getFormat().toString() : null;
    }
    getCustomProperty(controlId, propertyNameOrRowID, rowId) {
        if (controlId.indexOf('~') == -1)
            return this.getCustomProperty_1(controlId, propertyNameOrRowID, rowId);
        else {
            let cid = controlId.split('~')[0];
            let propName = controlId.split('~')[1];
            return this.getCustomProperty_1(cid, propName, propertyNameOrRowID);
        }
    }
    getCustomProperty_1(controlId, propertyName, rowId) {
        let userProperties;
        if (isNullOrUndefined(rowId))
            rowId = '0';
        let rec = this.task.Records.list[rowId];
        if (isNullOrUndefined(rec))
            debugger;
        else {
            const controlMetadata = rec.getControlMetadata(controlId);
            if (controlMetadata.userProperties.has(propertyName)) {
                userProperties = controlMetadata.userProperties.get(propertyName);
            }
        }
        return userProperties;
    }
    getItemListValues(id, rowId) {
        return this.getProperty(id, HtmlProperties.ItemsList, rowId);
    }
    getFilteredList(controlId, rowId) {
        if (isNullOrUndefined(rowId))
            rowId = '0';
        let items = this.getItemListValues(controlId, rowId);
        let value = this.task.getFormControl(rowId, controlId).value;
        if (value !== null && value !== "" && items instanceof Array) {
            value = value.toLowerCase();
            return items.filter(option => option.displayValue.toLowerCase().includes(value));
        }
        else
            return items;
    }
    getDisplayValue(id, rowId) {
        let displayValue = "";
        let o = this.getProperty(id, HtmlProperties.ItemsList, rowId);
        let value = this.task.getValue(id, rowId);
        if (value >= 0 && value < o.length && !isNullOrUndefined(o[value]))
            displayValue = o[value].displayValue;
        return displayValue;
    }
    isOptionSelected(index, controlId) {
        let val = this.task.getValue(controlId, "0");
        for (let item of val) {
            if (item === index)
                return true;
        }
        return false;
    }
    isTabPageSelected(controlId, layer) {
        let val = this.task.getProperty(controlId, HtmlProperties.SelectedValue);
        return val == (layer - 1);
    }
    isTabPageLayerSelected(controlId, layer) {
        let val = this.task.getProperty(controlId, HtmlProperties.SelectedLayer);
        return val == (layer - 1);
    }
    getTabSelectedIndex(controlId) {
        let val = this.task.getProperty(controlId, HtmlProperties.SelectedValue);
        return val;
    }
    ifRowCreated(row) {
        if (row == null)
            return false;
        let rowId = typeof row == "number" ? row.toString() : row.rowId;
        let result = this.getFormGroupByRow(rowId);
        return !isNullOrUndefined(result);
    }
    getFormGroupByRow(id) {
        return this.task.formGroups[id];
    }
    isRowSelected(controlId, rowId) {
        const selectedRow = this.task.getProperty(controlId, HtmlProperties.SelectedRow, "0");
        return selectedRow == rowId;
    }
    isRowInRowEditing(row) {
        let guiRowId = '0';
        guiRowId = typeof row == "number" ? row.toString() : row.rowId;
        return this.task.isRowInRowEditing(guiRowId);
    }
    isCurrentInRowEditing() {
        let row = this.task.tableService.getSelectedRow();
        return this.task.isRowInRowEditing(row);
    }
    guiTopIndex() {
        return this.task.tableService.getTableTopIndex();
    }
    getErrMsg(id, rowId) {
        let c = this.task.getFormControl(rowId, id);
        if (c.hasError('required'))
            return 'Control must be updated.';
        if (c.hasError('pattern')) {
            if (c.errors.pattern.actualValue < 0 && !c.errors.pattern.requiredPattern.includes('-'))
                return 'Value must be non-negative';
            if (c.errors.pattern.requiredPattern.includes('.')) {
                const numericFormat = Math.abs(c.errors.pattern.actualValue).toString().split('.')[0];
                const decimalFormat = Math.abs(c.errors.pattern.actualValue).toString().split('.')[1];
                const actualNumericLimit = c.errors.pattern.requiredPattern.match(/,(\d+)/)[1];
                const actualDecimalLimit = c.errors.pattern.requiredPattern.match(/(?:[^,]+,){2}(\d+)/)[1];
                if (numericFormat.length > actualNumericLimit || decimalFormat.length > actualDecimalLimit) {
                    return "Numeric format is limited to " + actualNumericLimit + "." + actualDecimalLimit + " digits";
                }
            }
            else if (!c.errors.pattern.requiredPattern.includes('.') && !Number.isInteger(c.errors.pattern.actualValue)) {
                const actualNumericLimit = c.errors.pattern.requiredPattern.match(/,(\d+)/)[1];
                return "Numeric format is limited to " + actualNumericLimit + "." + 0 + " digits";
            }
            else {
                const numericFormat = Math.abs(c.errors.pattern.actualValue).toString();
                const actualNumericLimit = c.errors.pattern.requiredPattern.match(/,(\d+)/)[1];
                if (numericFormat.length > actualNumericLimit) {
                    return "Numeric format is limited to " + actualNumericLimit + "." + 0 + " digits";
                }
            }
        }
        if (c.hasError('rangevalidator'))
            return c.errors.rangevalidator.errorMsg;
        if (c.hasError('maxlength'))
            return 'Max length allowed is : ' + c.errors.maxlength.requiredLength;
        if (c.hasError('max'))
            return 'Max value allowed is : ' + c.errors.max.max;
        let controlMetadata = this.task.Records.list[rowId].getControlMetadata(id);
        for (let key of controlMetadata.customValidators.keys()) {
            if (c.hasError(key)) {
                let customValidator = controlMetadata.customValidators.get(key);
                return customValidator.getErrMessage();
            }
        }
        return 'unknown error';
    }
    setValueToControl(controlName, value, refreshDisplay) {
        if (typeof refreshDisplay === "undefined")
            refreshDisplay = true;
        let guiEvent = getGuiEventObj("setexternalvalue", controlName, 0);
        guiEvent.externalValue = value;
        guiEvent.param = refreshDisplay;
        this.task.insertEvent(guiEvent);
    }
    isDataviewEmpty() {
        return this.task.Records.isEmptyDataView;
    }
    simulateClick(controlName, rowId) {
        if (typeof rowId === "undefined")
            rowId = 0;
        this.task.insertEvent(getGuiEventObj('click', controlName, rowId));
    }
    isLoggedIn() {
        return this.task.getIsLoggenIn();
    }
    GetFormRecords() {
        let rowId = 0;
        let recArray;
        if (!isNullOrUndefined(this.task.Records) && this.task.Records.list.length > 0) {
            let recList = this.task.Records.list;
            let tableControls = new Array();
            for (const key in this.task.template) {
                if (this.task.template[key] == '1')
                    tableControls.push(key);
            }
            recArray = new Array();
            if (tableControls.length > 0) {
                recList.forEach((ctrlMetaData) => {
                    if (this.task.Records.isRowCreated(rowId)) {
                        var formRecord = {};
                        formRecord['rowId'] = rowId;
                        tableControls.forEach((ctrlId) => {
                            formRecord[ctrlId] = ctrlMetaData.values[ctrlId];
                        });
                        recArray.push(formRecord);
                    }
                });
            }
        }
        return recArray;
    }
    SetCookie(name, value, expires, path, domain, secure, sameSite) {
        CookieService.setCookie(name, value, expires, path, domain, secure, sameSite);
    }
    GetCookie(name) {
        return CookieService.getCookie(name);
    }
    DeleteCookie(name) {
        return CookieService.deleteCookie(name);
    }
    getColor(colorNumber, colorType) {
        return this.magicColor.getColor(colorNumber, colorType);
    }
}
AccessorMagicService.ɵfac = function AccessorMagicService_Factory(t) { return new (t || AccessorMagicService)(i0.ɵɵinject(TaskMagicService), i0.ɵɵinject(MagicColorService)); };
AccessorMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: AccessorMagicService, factory: AccessorMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AccessorMagicService, [{
        type: Injectable
    }], function () { return [{ type: TaskMagicService }, { type: MagicColorService }]; }, null); })();

class MagicServices {
    constructor(task, subformService, tableService, titleService, mgAccessorService) {
        this.task = task;
        this.subformService = subformService;
        this.tableService = tableService;
        this.titleService = titleService;
        this.mgAccessorService = mgAccessorService;
        task.tableService = tableService;
        task.mgSubformService = subformService;
        task.mgTitleService = titleService;
        task.mgAccessorService = mgAccessorService;
    }
}
MagicServices.ɵfac = function MagicServices_Factory(t) { return new (t || MagicServices)(i0.ɵɵinject(TaskMagicService), i0.ɵɵinject(SubformMagicService), i0.ɵɵinject(TableMagicService), i0.ɵɵinject(TitleMagicService), i0.ɵɵinject(AccessorMagicService)); };
MagicServices.ɵprov = i0.ɵɵdefineInjectable({ token: MagicServices, factory: MagicServices.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicServices, [{
        type: Injectable
    }], function () { return [{ type: TaskMagicService }, { type: SubformMagicService }, { type: TableMagicService }, { type: TitleMagicService }, { type: AccessorMagicService }]; }, null); })();

class TaskBaseMagicComponent {
    constructor(ref, magicServices) {
        this.ref = ref;
        this.magicServices = magicServices;
        this.magicProperties = MagicProperties;
    }
    get task() {
        return this.magicServices.task;
    }
    get mgSub() {
        return this.magicServices.subformService;
    }
    get tableService() {
        return this.magicServices.tableService;
    }
    get mg() {
        return this.magicServices.mgAccessorService;
    }
    get taskId() {
        return this.task.taskId;
    }
    get screenFormGroup() {
        return this.task.ScreenModeControls;
    }
    ngOnInit() {
        this.task.detectChanges.pipe().subscribe(c => {
            this.ref.detectChanges();
        });
        this.task.initTask(this.taskIdParam, this.taskDescription);
        this.createFormControlsAccessor(this.screenFormGroup);
        this.setInputDateFormat();
        this.task.customPropertiesSubject.pipe().subscribe(property => {
            this.PropertyChanged(property.propertyName, property.rowId, property.value);
        });
        this.task.recordsCountChangeSubject.pipe().subscribe(value => {
            this.RecordsCountChanged(value);
        });
        this.task.mgLoadSubject.pipe().subscribe(value => {
            this.mgOnLoad();
        });
    }
    createFormControlsAccessor(formGroup) { }
    setInputDateFormat() { }
    PropertyChanged(propertyName, rowId, value) {
    }
    RecordsCountChanged(recordsCount) {
    }
    mgOnLoad() {
    }
    ngAfterViewInit() {
        this.mgSub.init();
    }
    ngAfterContentChecked() {
        if (!isNullOrUndefined(this.tableService.getPageSize()) && this.task.oldPageSize != this.tableService.getPageSize()) {
            this.task.resize(this.tableService.getPageSize(), 0);
            this.task.oldPageSize = this.tableService.getPageSize();
        }
    }
    ngOnDestroy() {
        this.task.dispose();
    }
}
TaskBaseMagicComponent.ɵfac = function TaskBaseMagicComponent_Factory(t) { return new (t || TaskBaseMagicComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(MagicServices)); };
TaskBaseMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: TaskBaseMagicComponent, selectors: [["task-magic"]], inputs: { taskIdParam: "taskIdParam", taskDescription: "taskDescription" }, features: [i0.ɵɵProvidersFeature([TaskMagicService, SubformMagicService, TableMagicService])], decls: 0, vars: 0, template: function TaskBaseMagicComponent_Template(rf, ctx) { }, encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TaskBaseMagicComponent, [{
        type: Component,
        args: [{
                selector: 'task-magic',
                providers: [TaskMagicService, SubformMagicService, TableMagicService],
                template: ''
            }]
    }], function () { return [{ type: i0.ChangeDetectorRef }, { type: MagicServices }]; }, { taskIdParam: [{
            type: Input
        }], taskDescription: [{
            type: Input
        }] }); })();

class RowMagicDirective {
    constructor(_task, element) {
        this._task = _task;
        this.element = element;
        this.rowChangedSubscriber = null;
        this.htmlElement = this.element.nativeElement;
    }
    ngOnInit() {
        this.rowChangedSubscriber = this._task
            .OnSelectedRowChanged.pipe(filter(rowId => rowId === this.rowId))
            .subscribe(rowId => {
            if (!this.isInView(this.htmlElement))
                this.htmlElement.scrollIntoView();
        });
    }
    isInView(element) {
        const rect = element.getBoundingClientRect();
        const parentRect = element.parentElement.getBoundingClientRect();
        return (rect.top >= parentRect.top &&
            rect.bottom <= parentRect.bottom);
    }
    ngOnDestroy() {
        if (this.rowChangedSubscriber !== null) {
            this.rowChangedSubscriber.unsubscribe();
        }
    }
    onClick($event) {
        if (this.rowId != '') {
            this._task.insertEvent(getGuiEventObj('click', "magicRow", +this.rowId));
            if (MagicDirective.noOfAutoCompleteBoxesOpened < 1)
                event.cancelBubble = true;
        }
    }
}
RowMagicDirective.ɵfac = function RowMagicDirective_Factory(t) { return new (t || RowMagicDirective)(i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef)); };
RowMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: RowMagicDirective, selectors: [["", "magicRow", ""]], hostBindings: function RowMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("click", function RowMagicDirective_click_HostBindingHandler($event) { return ctx.onClick($event); });
    } }, inputs: { rowId: ["magicRow", "rowId"] } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RowMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[magicRow]'
            }]
    }], function () { return [{ type: TaskMagicService }, { type: i0.ElementRef }]; }, { rowId: [{
            type: Input,
            args: ['magicRow']
        }], onClick: [{
            type: HostListener,
            args: ['click', ['$event']]
        }] }); })();

class MagicDirective {
    set magic(val) {
        this.id = val;
        this.selector = "magic";
    }
    ;
    set eventsOnly(val) {
        console.log("eventsOnly");
        this.eventsOnlyVal = true;
    }
    ;
    constructor(_task, element, renderer, vcRef, magicRow) {
        this._task = _task;
        this.element = element;
        this.renderer = renderer;
        this.vcRef = vcRef;
        this.magicRow = magicRow;
        this.eventHandlers = {};
        this.eventsOnlyVal = false;
        this.htmlElement = this.element.nativeElement;
        if (!(typeof magicRow === "undefined" || magicRow === null))
            this.rowId = magicRow.rowId;
    }
    get task() {
        return this._task;
    }
    regEvents() {
        this.eventHandlers["focusin"] = this.OnFocus.bind(this);
        Object.keys(this.eventHandlers).forEach((key) => {
            this.focusUnlistener = this.renderer.listen(this.htmlElement, key, this.eventHandlers[key]);
        });
        let events = ["click", "mousedown", "dblclick"];
        events.forEach(event => {
            this.renderer.listen(this.htmlElement, event, (e) => {
                let fromButton = false;
                if (this.htmlElement instanceof HTMLButtonElement)
                    fromButton = true;
                this.task.insertEvent(getGuiEventObj(event, this.id, +this.rowId, fromButton));
                if (MagicDirective.noOfAutoCompleteBoxesOpened < 1)
                    e.cancelBubble = true;
            });
        });
        this.renderer.listen(this.htmlElement, "change", (e) => {
            let guiEvent = getGuiEventObj("selectionchanged", this.id, +this.rowId);
            if ((event.target).selectedIndex !== undefined) {
                guiEvent.Value = (event.target).selectedIndex.toString();
                e.cancelBubble = true;
                this.task.insertEvent(guiEvent);
            }
        });
        fromEvent(this.htmlElement, "input").pipe(map((event) => {
            return event.target.value;
        }), debounceTime(200)).subscribe((x) => {
            if (this.task.getProperty(this.id, HtmlProperties.BindingLevel, this.rowId) === BindingLevel.Character) {
                let attribute = this.task.Records.list[0].getControlMetadata(this.id).dataType;
                if (attribute !== StorageAttributeType.Date && attribute != StorageAttributeType.Time)
                    this.task.mgAccessorService.setValueToControl(this.id, x, true);
            }
        });
        this.renderer.listen(this.htmlElement, "keydown", (e) => {
            let guiEvent = getGuiEventObj("keydown", this.id, +this.rowId);
            guiEvent.modifiers = Modifiers.MODIFIER_NONE;
            if (e.altKey && e.keyCode !== GuiConstants.KEY_ALT)
                guiEvent.modifiers = Modifiers.MODIFIER_ALT;
            else if (e.ctrlKey && e.keyCode !== GuiConstants.KEY_CTRL)
                guiEvent.modifiers = Modifiers.MODIFIER_CTRL;
            let supportedKey = e.keyCode === GuiConstants.KEY_PG_UP ||
                e.keyCode === GuiConstants.KEY_PG_DOWN ||
                e.keyCode === GuiConstants.KEY_LEFT ||
                e.keyCode === GuiConstants.KEY_RIGHT ||
                e.keyCode === GuiConstants.KEY_UP ||
                e.keyCode === GuiConstants.KEY_DOWN ||
                e.keyCode === GuiConstants.KEY_ESC ||
                e.keyCode === GuiConstants.KEY_HOME ||
                e.keyCode === GuiConstants.KEY_END ||
                e.keyCode === GuiConstants.KEY_RETURN ||
                (e.keyCode >= GuiConstants.KEY_F1 && e.keyCode <= GuiConstants.KEY_F12);
            if (guiEvent.modifiers !== Modifiers.MODIFIER_NONE || supportedKey) {
                guiEvent.keyCode = e.keyCode;
                if (e.keyCode !== GuiConstants.KEY_ESC || e.keyCode === GuiConstants.KEY_ESC && (!MagicDirective.opened && MagicDirective.noOfAutoCompleteBoxesOpened < 1))
                    e.cancelBubble = true;
                this.task.insertEvent(guiEvent);
            }
        });
    }
    OnFocus() {
        this.task.insertEvent(getGuiEventObj("focus", this.id, +this.rowId));
        event.cancelBubble = true;
    }
    IsSameElement(command) {
        let line = command.line;
        if (this.task.isTableControl(command.CtrlName))
            line = this.task.getGuiRowId(line, true);
        return (command.CtrlName === this.id &&
            (line === +this.rowId ||
                (line === 0 && isNullOrUndefined(this.rowId))));
    }
    IsSameComponent(command) {
        return (command.controlName === this.id);
    }
    regUpdatesUI() {
        this.subscribeRefreshDom = this.task
            .refreshDom.pipe(filter(c => this.IsSameElement(c)))
            .subscribe(a => {
            let command = a;
            if (isNullOrUndefined(this.rowId))
                this.rowId = "0";
            try {
                if (!this.eventsOnlyVal)
                    this.handleCommand(command);
            }
            catch (ex) {
                console.dir(ex);
            }
        });
        this.subscribeInteractiveCommands = this.task.interactiveCommands
            .pipe(filter(c => this.IsSameComponent(c)))
            .subscribe(command => {
            this.handleInteractiveCommands(command);
        });
    }
    ngOnInit() {
        this.regEvents();
        this.regUpdatesUI();
    }
    handleCommand(command) {
        switch (command.CommandType) {
            case CommandType.SET_PROPERTY:
                this.handleSetProperty(command);
                break;
            case CommandType.SET_FOCUS:
                this.focusUnlistener();
                if (!(command.obj.ConnectedControl && this.htmlElement instanceof HTMLButtonElement))
                    this.htmlElement.focus();
                this.focusUnlistener = this.renderer.listen(this.htmlElement, "focusin", this.eventHandlers["focusin"]);
                break;
        }
    }
    handleInteractiveCommands(command) {
        switch (command._commandType) {
            case InteractiveCommandType.CALL_JS:
                let methodName = command._str;
                let args = command.arguments;
                let magicComponent = (this.vcRef._hostLView).find(v => v instanceof TaskBaseMagicComponent);
                let resultString = "";
                try {
                    if (!isNullOrUndefined(magicComponent[methodName])) {
                        resultString = magicComponent[methodName].apply(magicComponent, args);
                    }
                    else
                        console.error("Instance method " + methodName + " does not exists");
                }
                catch (e) {
                    console.error(e.message);
                }
                command.resultString = resultString;
                break;
        }
    }
    handleSetProperty(command) {
        switch (command.Operation) {
            case HtmlProperties.ReadOnly:
                {
                    if (command.obj.Type == MgControlType.CTRL_TYPE_TEXT)
                        if (command.obj1 != true)
                            this.renderer.removeAttribute(this.htmlElement, command.Operation);
                        else
                            this.renderer.setAttribute(this.htmlElement, command.Operation, command.str);
                }
                break;
        }
    }
    ngOnDestroy() {
        this.subscribeRefreshDom.unsubscribe();
    }
}
MagicDirective.opened = false;
MagicDirective.noOfAutoCompleteBoxesOpened = 0;
MagicDirective.ɵfac = function MagicDirective_Factory(t) { return new (t || MagicDirective)(i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(RowMagicDirective, 8)); };
MagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: MagicDirective, selectors: [["", "magic", ""]], inputs: { magic: "magic", eventsOnly: "eventsOnly", rowId: "rowId" } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicDirective, [{
        type: Directive,
        args: [{
                selector: "[magic]"
            }]
    }], function () { return [{ type: TaskMagicService }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i0.ViewContainerRef }, { type: RowMagicDirective, decorators: [{
                type: Optional
            }] }]; }, { magic: [{
            type: Input,
            args: ["magic"]
        }], eventsOnly: [{
            type: Input,
            args: ["eventsOnly"]
        }], rowId: [{
            type: Input
        }] }); })();

class NoControlMagicDirective extends MagicDirective {
    set magic(val) { this.id = val; this.selector = 'magicnc'; }
    ;
    constructor(_task, element, renderer, vcRef, magicRow) {
        super(_task, element, renderer, vcRef, magicRow);
    }
    regEvents() {
        super.regEvents();
        if (this.htmlElement instanceof HTMLSelectElement) {
            this.htmlElement.addEventListener('change', (e) => {
                let guiEvent = getGuiEventObj("selectionchanged", this.id, 0);
                guiEvent.Value = (event.target).selectedIndex.toString();
                this.task.insertEvent(guiEvent);
            });
        }
        if (this.isRadio()) {
            this.htmlElement.addEventListener('change', (e) => {
                let guiEvent = getGuiEventObj("selectionchanged", this.id, 0);
                guiEvent.Value = (e.target).value;
                this.task.insertEvent(guiEvent);
            });
        }
        if (this.isTabControl()) {
            const tabControl = this.htmlElement.children[0];
            let guiEvent = getGuiEventObj("selectionchanged", this.id, 0);
            for (var i = 0; i < tabControl.children.length; i++) {
                tabControl.children[i].addEventListener('click', (e) => {
                    guiEvent.Value = (e.currentTarget.getAttribute('layer') - 1).toString();
                    this.task.insertEvent(guiEvent);
                });
            }
        }
    }
    isTabControl() {
        return this.htmlElement instanceof HTMLDivElement &&
            this.htmlElement.children[0].getAttribute('magicMark') === "magicTabControl";
    }
    isRadio() {
        return this.htmlElement instanceof HTMLDivElement &&
            this.htmlElement.children[0].getAttribute('magicMark') === "magicRadio";
    }
    handleCommand(command) {
        super.handleCommand(command);
        switch (command.CommandType) {
            case CommandType.SET_CLASS:
                const controlMetadata = this._task.Records.list[0].getControlMetadata(this.id);
                if (controlMetadata.removedClass != '') {
                    this.htmlElement.classList.remove(controlMetadata.removedClass);
                    controlMetadata.removedClass = '';
                }
                this.htmlElement.classList.add(command.obj1);
                break;
            case CommandType.SET_VALUE:
                if (this.htmlElement instanceof HTMLLabelElement)
                    this.htmlElement.innerText = command.value;
                if (this.htmlElement instanceof HTMLSelectElement)
                    this.htmlElement.value = command.value;
                if (this.htmlElement instanceof HTMLAnchorElement)
                    this.htmlElement.text = command.value;
                if (this.htmlElement instanceof HTMLInputElement) {
                    if (this.htmlElement.type === "checkbox") {
                        this.htmlElement.checked = command.value;
                    }
                    else {
                        this.htmlElement.value = command.value;
                    }
                }
                if (this.htmlElement instanceof HTMLButtonElement) {
                    this.htmlElement.innerHTML = command.value;
                }
                break;
            case CommandType.SET_PROPERTY:
                this.handleSetProperty(command);
                break;
            case CommandType.SET_STYLE:
                let value = StylesMapManager.magicValueGetStyle(command.Operation, command.obj1);
                let attribute = StylesMapManager.MagicPropertyToHtmlAttributeMap.get(command.Operation);
                this.htmlElement.setAttribute("style", attribute + ":" + value);
                break;
        }
    }
    handleSetProperty(command) {
        super.handleSetProperty(command);
        switch (command.Operation) {
            case HtmlProperties.Text:
                if (this.htmlElement instanceof HTMLLabelElement)
                    this.htmlElement.innerText = command.obj1;
                break;
            case HtmlProperties.Image:
                if (this.htmlElement instanceof HTMLImageElement)
                    this.htmlElement.src = command.obj1;
                else
                    this.htmlElement.setAttribute("src", command.obj1);
                break;
            case HtmlProperties.ItemsList:
                if (this.htmlElement instanceof HTMLSelectElement) {
                    var len = this.htmlElement.length;
                    for (var i = len - 1; i >= 0; i--) {
                        this.htmlElement.remove(i);
                    }
                    for (let s of command.obj1) {
                        let elem = document.createElement("option");
                        elem.text = s.displayValue;
                        elem.value = s.index;
                        this.htmlElement.add(elem);
                    }
                }
                else if (this.isTabControl() && this.htmlElement.children.length > 0) {
                    const tabControl = this.htmlElement.children[0];
                    for (var i = 0; i < tabControl.children.length; i++) {
                        if (tabControl.children[i] instanceof HTMLButtonElement) {
                            tabControl.children[i].innerText = command.obj1[i].displayValue;
                        }
                    }
                }
                break;
            case HtmlProperties.Visible:
                this.htmlElement.setAttribute('style', 'visibility:' + (command.obj1 ? 'visible' : 'hidden'));
                break;
            case HtmlProperties.Enabled:
                if (command.obj1 === false)
                    this.htmlElement.setAttribute("disabled", "true");
                else
                    this.htmlElement.removeAttribute("disabled");
                break;
            case HtmlProperties.TabIndex:
                this.htmlElement.setAttribute(command.Operation, command.obj1);
                break;
            case HtmlProperties.SelectedValue:
                if (this.htmlElement instanceof HTMLSelectElement)
                    this.htmlElement.value = command.obj1;
                else if (this.isTabControl() && this.htmlElement.children.length > 0) {
                    const tabControl = this.htmlElement.children[0];
                    for (var i = 0; i < tabControl.children.length; i++) {
                        let child = tabControl.children[i];
                        const layer = child.getAttribute('layer') - 1;
                        if (child instanceof HTMLButtonElement) {
                            if (layer == command.obj1) {
                                child.classList.add('tab_button_active');
                            }
                            else {
                                child.classList.remove('tab_button_active');
                            }
                        }
                        else {
                            let style = (layer == command.obj1) ? 'display: inline' : 'display: none';
                            child.setAttribute('style', style);
                        }
                    }
                }
                break;
            case HtmlProperties.PlaceHolder:
                this.htmlElement.setAttribute("placeholder", command.obj1);
                break;
            case HtmlProperties.Tooltip:
                this.htmlElement.setAttribute("title", command.obj1);
                break;
            case HtmlProperties.Password:
                if (command.obj1 === false)
                    this.htmlElement.setAttribute("type", "text");
                else
                    this.htmlElement.setAttribute("type", "password");
                break;
        }
    }
}
NoControlMagicDirective.ɵfac = function NoControlMagicDirective_Factory(t) { return new (t || NoControlMagicDirective)(i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(RowMagicDirective, 8)); };
NoControlMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: NoControlMagicDirective, selectors: [["", "magicnc", ""]], inputs: { magic: ["magicnc", "magic"] }, features: [i0.ɵɵInheritDefinitionFeature] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NoControlMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[magicnc]'
            }]
    }], function () { return [{ type: TaskMagicService }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i0.ViewContainerRef }, { type: RowMagicDirective, decorators: [{
                type: Optional
            }] }]; }, { magic: [{
            type: Input,
            args: ['magicnc']
        }] }); })();

class Constants {
}
Constants.DATE_FMT = 'dd/MMM/yyyy';
class DateMagicPipe extends DatePipe {
    constructor(_task) {
        super('en-US');
        this._task = _task;
    }
    transform(value, controlId) {
        let mask = this._task.GetControlPictureMask(controlId).getMask();
        let formatStr = null;
        let mgDateFormatter = new MgDateFormatter();
        if (!isNullOrUndefined(value) && mask !== null) {
            formatStr = mgDateFormatter.ConvertMgDateFormatToAngular(mask);
            if (formatStr != null && this._task.isTableControl(controlId)) {
                if (this._task.mgInputDateFormat == null)
                    this._task.mgInputDateFormat = formatStr;
                else
                    formatStr = this._task.mgInputDateFormat;
            }
            return super.transform(value, formatStr);
        }
        else
            value = "";
        return value;
    }
}
DateMagicPipe.ɵfac = function DateMagicPipe_Factory(t) { return new (t || DateMagicPipe)(i0.ɵɵdirectiveInject(TaskMagicService, 16)); };
DateMagicPipe.ɵpipe = i0.ɵɵdefinePipe({ name: "magicDate", type: DateMagicPipe, pure: true });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateMagicPipe, [{
        type: Pipe,
        args: [{
                name: 'magicDate'
            }]
    }], function () { return [{ type: TaskMagicService }]; }, null); })();
class MgDateFormatter {
    ConvertMgDateFormatToAngular(mgDateMask) {
        let formatStr = new StringBuilder();
        if (mgDateMask !== null) {
            for (let i = 0; i < mgDateMask.length;) {
                switch (mgDateMask.charCodeAt(i)) {
                    case PICInterface.PIC_YYYY:
                        formatStr.Append('yyyy');
                        i += 4;
                        break;
                    case PICInterface.PIC_MMD:
                        formatStr.Append('MM');
                        i += 2;
                        break;
                    case PICInterface.PIC_YY:
                        formatStr.Append('yy');
                        i += 2;
                        break;
                    case PICInterface.PIC_MMM:
                        {
                            let cnt = 0;
                            for (; i < mgDateMask.length; i++)
                                if (mgDateMask.charCodeAt(i) == PICInterface.PIC_MMM)
                                    cnt++;
                                else
                                    break;
                            if (cnt == 3)
                                formatStr.Append('MMM');
                            if (cnt > 3)
                                formatStr.Append('MMMM');
                        }
                        break;
                    case PICInterface.PIC_DD:
                        formatStr.Append('dd');
                        i += 2;
                        break;
                    case PICInterface.PIC_WWW:
                        {
                            let cnt = 0;
                            for (; i < mgDateMask.length; i++)
                                if (mgDateMask.charCodeAt(i) == PICInterface.PIC_WWW)
                                    cnt++;
                                else
                                    break;
                            if (cnt == 3)
                                formatStr.Append('EEE');
                            if (cnt > 3)
                                formatStr.Append('EEEE');
                        }
                        break;
                    default:
                        formatStr.Append(mgDateMask.charAt(i));
                        i++;
                        break;
                }
            }
            return formatStr.ToString();
        }
        else
            return "dd-mm-yyyy";
    }
}

class MgformatMagicDirective {
    constructor(magicDir, _task) {
        this.magicDir = magicDir;
        this._task = _task;
        this.datePasteFlag = false;
    }
    ngAfterViewInit() {
        let control = this._task.getFormControl(this.magicDir.rowId, this.magicDir.id);
        if (control != null && this._task.mgInputDateFormat == null) {
            let pic = this._task.GetControlPictureMask(this.magicDir.id);
            if (pic.getAttr() == StorageAttribute.DATE) {
                this.formatDate(pic);
            }
        }
    }
    onFocusEvent($event) {
        this.calculatePattern();
    }
    onPaste(event) {
        this.datePasteFlag = true;
    }
    onInputEvent(event) {
        let attr = this._task.Records.list[0].getControlMetadata(this.magicDir.id).dataType;
        if (attr == StorageAttribute.DATE) {
            if (!this.datePasteFlag)
                this.dateMasking(event);
            this.datePasteFlag = false;
        }
        this.calculatePattern();
    }
    dateMasking(event) {
        const input = event.target;
        let cursorPos = event.target.selectionStart;
        const separator = this._task.mgInputDateFormat.includes('/') ? '/' : '-';
        if (cursorPos >= input.value.length) {
            const value = input.value.replace(/[^a-zA-Z0-9/-]/g, '');
            if (this._task.mgInputDateFormat == "dd/MM/yyyy" || this._task.mgInputDateFormat == "MM/dd/yyyy" || this._task.mgInputDateFormat == "dd-MM-yyyy" || this._task.mgInputDateFormat == "MM-dd-yyyy") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 4 && value[3] == separator)
                    input.value = value.slice(0, 3) + '01' + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 3) + '0' + value.slice(3);
                else if (value.length == 6 && value[5] != separator)
                    input.value = value.slice(0, 5) + separator + value.slice(5);
                else if (value.length >= 10)
                    input.value = value.slice(0, 10);
            }
            else if (this._task.mgInputDateFormat == "yyyy/MM/dd" || this._task.mgInputDateFormat == "yyyy/dd/MM" || this._task.mgInputDateFormat == "yyyy-MM-dd" || this._task.mgInputDateFormat == "yyyy-dd-MM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '0000' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = '000' + value.slice(0);
                else if (value.length == 3 && value[2] == separator)
                    input.value = '00' + value.slice(0);
                else if (value.length == 4 && value[3] == separator)
                    input.value = '0' + value.slice(0);
                else if (value.length == 5 && value[4] != separator)
                    input.value = value.slice(0, 4) + separator + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 5) + '01' + value.slice(5);
                else if (value.length == 7 && value[6] == separator)
                    input.value = value.slice(0, 5) + '0' + value.slice(5);
                else if (value.length == 8 && value[7] != separator)
                    input.value = value.slice(0, 7) + separator + value.slice(7);
                else if (value.length >= 10)
                    input.value = value.slice(0, 10);
            }
            else if (this._task.mgInputDateFormat == "dd/MM/yy" || this._task.mgInputDateFormat == "yy/MM/dd" || this._task.mgInputDateFormat == "MM/dd/yy" || this._task.mgInputDateFormat == "yy/dd/MM" || this._task.mgInputDateFormat == "dd-MM-yy" || this._task.mgInputDateFormat == "yy-MM-dd" || this._task.mgInputDateFormat == "MM-dd-yy" || this._task.mgInputDateFormat == "yy-dd-MM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 4 && value[3] == separator)
                    input.value = value.slice(0, 3) + '01' + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 3) + '0' + value.slice(3);
                else if (value.length == 6 && value[5] != separator)
                    input.value = value.slice(0, 5) + separator + value.slice(5);
                else if (value.length >= 8)
                    input.value = value.slice(0, 8);
            }
            else if (this._task.mgInputDateFormat == "dd/MMM/yy" || this._task.mgInputDateFormat == "dd-MMM-yy") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 9)
                    input.value = value.slice(0, 9);
            }
            else if (this._task.mgInputDateFormat == "dd/MMM/yyyy" || this._task.mgInputDateFormat == "dd-MMM-yyyy") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '01' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 11)
                    input.value = value.slice(0, 11);
            }
            else if (this._task.mgInputDateFormat == "yy/dd/MMM" || this._task.mgInputDateFormat == "yy-dd-MMM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '00' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = 0 + value;
                else if (value.length == 3 && value[2] != separator)
                    input.value = value.slice(0, 2) + separator + value.slice(2);
                else if (value.length == 4 && value[3] == separator)
                    input.value = value.slice(0, 3) + '01' + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 3) + '0' + value.slice(3);
                else if (value.length == 6 && value[5] != separator)
                    input.value = value.slice(0, 5) + separator + value.slice(5);
                else if (value.length >= 9)
                    input.value = value.slice(0, 9);
            }
            else if (this._task.mgInputDateFormat == "yyyy/dd/MMM" || this._task.mgInputDateFormat == "yyyy-dd-MMM") {
                if (value.length == 1 && value[0] == separator)
                    input.value = '0000' + separator;
                else if (value.length == 2 && value[1] == separator)
                    input.value = '000' + value.slice(0);
                else if (value.length == 3 && value[2] == separator)
                    input.value = '00' + value.slice(0);
                else if (value.length == 4 && value[3] == separator)
                    input.value = '0' + value.slice(0);
                else if (value.length == 5 && value[4] != separator)
                    input.value = value.slice(0, 4) + separator + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 5) + '01' + value.slice(5);
                else if (value.length == 7 && value[6] == separator)
                    input.value = value.slice(0, 5) + '0' + value.slice(5);
                else if (value.length == 8 && value[7] != separator)
                    input.value = value.slice(0, 7) + separator + value.slice(7);
                else if (value.length >= 11)
                    input.value = value.slice(0, 11);
            }
            else if (this._task.mgInputDateFormat == "MMM/dd/yy" || this._task.mgInputDateFormat == "MMM-dd-yy") {
                if (value.length == 4 && value[3] != separator)
                    input.value = value.slice(0, 3) + separator + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 4) + '01' + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 4) + '0' + value.slice(4);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 9)
                    input.value = value.slice(0, 9);
            }
            else if (this._task.mgInputDateFormat == "MMM/dd/yyyy" || this._task.mgInputDateFormat == "MMM-dd-yyyy") {
                if (value.length == 4 && value[3] != separator)
                    input.value = value.slice(0, 3) + separator + value.slice(3);
                else if (value.length == 5 && value[4] == separator)
                    input.value = value.slice(0, 4) + '01' + value.slice(4);
                else if (value.length == 6 && value[5] == separator)
                    input.value = value.slice(0, 4) + '0' + value.slice(4);
                else if (value.length == 7 && value[6] != separator)
                    input.value = value.slice(0, 6) + separator + value.slice(6);
                else if (value.length >= 11)
                    input.value = value.slice(0, 11);
            }
        }
        if (cursorPos < input.value.length && input.value.length > this._task.mgInputDateFormat.length) {
            let inputDate = input.value;
            let start = input.selectionStart - 1;
            let end = input.selectionEnd - 1;
            let indexToRemove = input.selectionStart - 1;
            input.value = inputDate.slice(0, indexToRemove) + inputDate.slice(indexToRemove + 1);
            input.setSelectionRange(start, end);
        }
    }
    onChangeEvent($event) {
        let control = this._task.getFormControl(this.magicDir.rowId, this.magicDir.id);
        let attr = this._task.Records.list[0].getControlMetadata(this.magicDir.id).dataType;
        switch (attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                this.formatAlphaUnicode(control);
                break;
            case StorageAttribute.BOOLEAN:
                this.formatBoolean(control);
                break;
        }
    }
    calculatePattern() {
        let control = this._task.getFormControl(this.magicDir.rowId, this.magicDir.id);
        if (control != null) {
            let attr = this._task.Records.list[0].getControlMetadata(this.magicDir.id).dataType;
            if (attr == StorageAttribute.NUMERIC || attr == StorageAttribute.ALPHA || attr == StorageAttribute.UNICODE) {
                let pic = this._task.GetControlPictureMask(this.magicDir.id);
                if (this.isPatternGenerationNeeded(attr, pic)) {
                    let pattern = this.generatePattern(attr, pic);
                    if (control.validator == null)
                        control.setValidators(Validators.pattern(pattern));
                    else
                        control.setValidators([control.validator, Validators.pattern(pattern)]);
                }
                else {
                    if (attr == StorageAttribute.ALPHA || attr == StorageAttribute.UNICODE) {
                        if (control.validator == null)
                            control.setValidators(Validators.maxLength(pic.getMaskLength()));
                        else {
                            if (pic.isFormatExp()) {
                                control.setValidators(Validators.maxLength(pic.getMaskLength()));
                                if (isUndefined(this.magicDir.rowId))
                                    this.magicDir.rowId = '0';
                                control.setValidators([control.validator, this._task.customValidator(this.magicDir.rowId, this.magicDir.id)]);
                            }
                            else
                                control.setValidators([control.validator, Validators.maxLength(pic.getMaskLength())]);
                        }
                        control.updateValueAndValidity();
                    }
                }
            }
        }
    }
    formatDate(pic) {
        let mgDateFormatter = new MgDateFormatter();
        this._task.mgInputDateFormat = mgDateFormatter.ConvertMgDateFormatToAngular(pic.getMask());
    }
    formatAlphaUnicode(control) {
        let value = control.value;
        if (value !== null && value.length > 0) {
            const newValue = this._task.GetRangedValue(this.magicDir.id, value);
            if (newValue != null)
                value = newValue;
            let pic = this._task.GetControlPictureMask(this.magicDir.id);
            let mask = pic.getMask();
            let valueStr = new StringBuilder();
            for (let i = 0; i < value.length; i++) {
                switch (mask.charCodeAt(i)) {
                    case PICInterface.PIC_U:
                        valueStr.Append(value.charAt(i).toUpperCase());
                        break;
                    case PICInterface.PIC_L:
                        valueStr.Append(value.charAt(i).toLowerCase());
                        break;
                    default:
                        valueStr.Append(value.charAt(i));
                        break;
                }
            }
            control.setValue(valueStr.ToString());
        }
    }
    formatBoolean(control) {
        let value = control.value;
        if (value !== null && value.length > 0) {
            let newValue = this._task.GetRangedValue(this.magicDir.id, value);
            if (newValue.toUpperCase().startsWith(value.toUpperCase())) {
                control.setValue(newValue);
            }
            else {
                control.setValue(value);
            }
        }
    }
    generatePattern(attribute, pic) {
        let pattern = '';
        switch (attribute) {
            case StorageAttribute.NUMERIC:
                pattern = this.generatePatternForNumber(pic);
                break;
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                pattern = this.generatePatternForAlpha(pic);
                break;
        }
        return pattern;
    }
    generatePatternForNumber(pic) {
        let patternStr = new StringBuilder();
        patternStr.Append('^');
        if (pic.isNegative())
            patternStr.Append('-?');
        if (pic.getWholes())
            patternStr.AppendFormat('\\d{{0},{1}}', 0, pic.getWholes());
        if (pic.getDec())
            patternStr.AppendFormat('(\\.\\d{1,{0}})?', pic.getDec());
        patternStr.Append('$');
        return patternStr.ToString();
    }
    isPatternGenerationNeeded(attr, pic) {
        switch (attr) {
            case StorageAttribute.NUMERIC:
                return true;
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                return (pic.getMaskChars() > 0) ? true : false;
        }
    }
    generatePatternForAlpha(pic) {
        let cnt = 0;
        let inputAllChars = false;
        let closeSet = false;
        let mask = pic.getMask();
        let pattern = new StringBuilder();
        pattern.Append('^');
        for (let i = 0; i < mask.length;) {
            if (inputAllChars && (mask.charCodeAt(i) == PICInterface.PIC_N || mask.charCodeAt(i) == PICInterface.PIC_U || mask.charCodeAt(i) == PICInterface.PIC_L
                || mask.charCodeAt(i) == PICInterface.PIC_X)) {
                pattern.Append('(');
                closeSet = true;
                inputAllChars = false;
            }
            cnt = 0;
            switch (mask.charCodeAt(i)) {
                case PICInterface.PIC_U:
                case PICInterface.PIC_X:
                case PICInterface.PIC_L:
                    {
                        pattern.Append('.');
                        let inputAllCharsRef = new RefParam(false);
                        let dirs = PICInterface.PIC_U.toString();
                        dirs += PICInterface.PIC_L.toString();
                        dirs += PICInterface.PIC_X.toString();
                        cnt = this.getDirectiveCount(mask, i, dirs, inputAllCharsRef);
                        inputAllChars = inputAllCharsRef.value;
                        i += cnt;
                    }
                    break;
                case PICInterface.PIC_N:
                    {
                        pattern.Append('\\d');
                        let inputAllCharsRef = new RefParam(false);
                        cnt = this.getDirectiveCount(mask, i, PICInterface.PIC_L.toString(), inputAllCharsRef);
                        inputAllChars = inputAllCharsRef.value;
                        i += cnt;
                    }
                    break;
                default:
                    pattern.Append(mask[i]);
                    i++;
                    break;
            }
            if (cnt > 0)
                pattern.AppendFormat('{{0},{1}}', inputAllChars ? cnt : 0, cnt);
            if (closeSet)
                pattern.Append(')');
            closeSet = false;
        }
        pattern.Append('$');
        return pattern.ToString();
    }
    getDirectiveCount(mask, idx, pattern, changeInPattern) {
        changeInPattern.value = false;
        let patternCount = 0;
        while (idx < mask.length && this.IsPatternMatches(mask.charCodeAt(idx).toString(), pattern)) {
            patternCount++;
            idx++;
        }
        if (idx < mask.length)
            changeInPattern.value = true;
        return patternCount;
    }
    IsPatternMatches(mask, pattern) {
        for (let i = 0; i < pattern.length; i++)
            if (mask == pattern[i])
                return true;
        return false;
    }
}
MgformatMagicDirective.ɵfac = function MgformatMagicDirective_Factory(t) { return new (t || MgformatMagicDirective)(i0.ɵɵdirectiveInject(MagicDirective), i0.ɵɵdirectiveInject(TaskMagicService)); };
MgformatMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: MgformatMagicDirective, selectors: [["", "mgFormat", ""]], hostBindings: function MgformatMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("focus", function MgformatMagicDirective_focus_HostBindingHandler($event) { return ctx.onFocusEvent($event); })("paste", function MgformatMagicDirective_paste_HostBindingHandler($event) { return ctx.onPaste($event); })("input", function MgformatMagicDirective_input_HostBindingHandler($event) { return ctx.onInputEvent($event); })("change", function MgformatMagicDirective_change_HostBindingHandler($event) { return ctx.onChangeEvent($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MgformatMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[mgFormat]'
            }]
    }], function () { return [{ type: MagicDirective }, { type: TaskMagicService }]; }, { onFocusEvent: [{
            type: HostListener,
            args: ['focus', ['$event']]
        }], onPaste: [{
            type: HostListener,
            args: ['paste', ['$event']]
        }], onInputEvent: [{
            type: HostListener,
            args: ['input', ['$event']]
        }], onChangeEvent: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();

class TimeMagicPipe extends DatePipe {
    constructor(_task) {
        super('en-US');
        this._task = _task;
    }
    transform(value, controlId) {
        let mask = this._task.GetControlPictureMask(controlId).getMask();
        let formatStr = new StringBuilder();
        if (typeof value !== "undefined" && mask !== null) {
            for (let i = 0; i < mask.length;) {
                switch (mask.charCodeAt(i)) {
                    case PICInterface.PIC_HH:
                        formatStr.Append('hh');
                        i += 2;
                        break;
                    case PICInterface.PIC_MMT:
                        formatStr.Append('mm');
                        i += 2;
                        break;
                    case PICInterface.PIC_SS:
                        formatStr.Append('ss');
                        i += 2;
                        break;
                    default:
                        formatStr.Append(mask.charAt(i));
                        i++;
                        break;
                }
            }
            formatStr.Append(' a');
            return super.transform(value, formatStr.ToString());
        }
        return value;
    }
}
TimeMagicPipe.ɵfac = function TimeMagicPipe_Factory(t) { return new (t || TimeMagicPipe)(i0.ɵɵdirectiveInject(TaskMagicService, 16)); };
TimeMagicPipe.ɵpipe = i0.ɵɵdefinePipe({ name: "magicTime", type: TimeMagicPipe, pure: true });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimeMagicPipe, [{
        type: Pipe,
        args: [{
                name: 'magicTime'
            }]
    }], function () { return [{ type: TaskMagicService }]; }, null); })();

class RangeValidatorMagicDirective {
    constructor(_task, vcRef) {
        this._task = _task;
        this.vcRef = vcRef;
    }
    validate(c) {
        let controlName;
        controlName = this.getControlName(c);
        let properties;
        properties = this._task.Records.list["0"].getControlMetadata(controlName);
        properties.rangeValidator = true;
        let errMsg = null;
        if (c.dirty)
            errMsg = this._task.ValidateControlValue(controlName, this._task.ConvertValToNative(controlName, 0, c.value));
        let isValid = (errMsg == null) ? true : false;
        if (isValid) {
            return null;
        }
        else {
            return {
                rangevalidator: {
                    errorMsg: errMsg
                }
            };
        }
    }
    getControlName(c) {
        const formGroup = c.parent.controls;
        return Object.keys(formGroup).find(name => c === formGroup[name]) || null;
    }
}
RangeValidatorMagicDirective.ɵfac = function RangeValidatorMagicDirective_Factory(t) { return new (t || RangeValidatorMagicDirective)(i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(i0.ViewContainerRef)); };
RangeValidatorMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: RangeValidatorMagicDirective, selectors: [["", "rangevalidator", ""]], features: [i0.ɵɵProvidersFeature([
            {
                provide: NG_VALIDATORS,
                useExisting: RangeValidatorMagicDirective,
                multi: true,
            }
        ])] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RangeValidatorMagicDirective, [{
        type: Directive,
        args: [{
                selector: '[rangevalidator] ',
                providers: [
                    {
                        provide: NG_VALIDATORS,
                        useExisting: RangeValidatorMagicDirective,
                        multi: true,
                    }
                ]
            }]
    }], function () { return [{ type: TaskMagicService }, { type: i0.ViewContainerRef }]; }, null); })();

function SubformMagicComponent_ndc_dynamic_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "ndc-dynamic", 1);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r0.Component)("ndcDynamicInputs", ctx_r0.Parameters);
} }
class SubformMagicComponent {
    set magic(val) { this.id = val; }
    ;
    constructor(vcRef, mgSub) {
        this.vcRef = vcRef;
        this.mgSub = mgSub;
        this.component = null;
        this.component = (this.vcRef._hostLView).find(v => !isNullOrUndefined(v));
    }
    get Component() {
        return this.mgSub.mgGetComp(this.id);
    }
    get Parameters() {
        return this.mgSub.mgGetParameters(this.id);
    }
}
SubformMagicComponent.ɵfac = function SubformMagicComponent_Factory(t) { return new (t || SubformMagicComponent)(i0.ɵɵdirectiveInject(i0.ViewContainerRef), i0.ɵɵdirectiveInject(SubformMagicService)); };
SubformMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: SubformMagicComponent, selectors: [["magic-subform"]], inputs: { magic: "magic" }, decls: 1, vars: 1, consts: [[3, "ndcDynamicComponent", "ndcDynamicInputs", 4, "ngIf"], [3, "ndcDynamicComponent", "ndcDynamicInputs"]], template: function SubformMagicComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵtemplate(0, SubformMagicComponent_ndc_dynamic_0_Template, 1, 2, "ndc-dynamic", 0);
    } if (rf & 2) {
        i0.ɵɵproperty("ngIf", ctx.Component);
    } }, dependencies: [i1.NgIf, i3.DynamicComponent, i3.DynamicIoDirective], encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SubformMagicComponent, [{
        type: Component,
        args: [{
                selector: 'magic-subform',
                template: `
    <ndc-dynamic
      *ngIf="Component"  
      [ndcDynamicComponent]="Component" 
      [ndcDynamicInputs]="Parameters">
    </ndc-dynamic>
`
            }]
    }], function () { return [{ type: i0.ViewContainerRef }, { type: SubformMagicService }]; }, { magic: [{
            type: Input,
            args: ['magic']
        }] }); })();

const _c0$1 = ["customContent"];
function ErrorMagicComponent_div_0_span_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r2.mgService.getErrMsg(ctx_r2.id, ctx_r2.rowId), " ");
} }
function ErrorMagicComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", null, 1);
    i0.ɵɵprojection(3);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(4, ErrorMagicComponent_div_0_span_4_Template, 2, 1, "span", 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", ctx_r0.defaultDisplay);
} }
const _c1 = ["*"];
class ErrorMagicComponent {
    set magic(val) {
        this.id = val;
    }
    ;
    set rowId1(val) {
        this.rowId = val;
    }
    ;
    set CustomContent(innerComponent) {
        this.defaultDisplay = innerComponent == undefined || this.isEmpty(innerComponent.nativeElement);
        this.changeDetectorRef.detectChanges();
    }
    ;
    constructor(_task, mgService, changeDetectorRef) {
        this._task = _task;
        this.mgService = mgService;
        this.changeDetectorRef = changeDetectorRef;
        this.defaultDisplay = true;
        this.rowId = "0";
    }
    isEmpty(element) {
        const nodes = element.childNodes;
        for (let i = 0; i < nodes.length; i++) {
            const node = nodes.item(i);
            if (node.nodeType !== 8 && nodes.item(i).textContent.trim().length !== 0) {
                return false;
            }
        }
        return true;
    }
    HasErrors(id) {
        if (!isUndefined(id)) {
            let control = this._task.getFormControl(this.rowId, id);
            if (control !== null) {
                if (control.dirty && (control.hasError('pattern') || control.hasError('required') ||
                    control.hasError('rangevalidator') || control.hasError('maxlength') || control.hasError('max')))
                    return true;
                if (control.touched && control.hasError('required'))
                    return true;
                if (this._task.Records.list[this.rowId] && this._task.Records.list[this.rowId].getControlMetadata(id)) {
                    let controlMetadata = this._task.Records.list[this.rowId].getControlMetadata(id);
                    for (let customValidator of controlMetadata.customValidators.keys()) {
                        if (control.hasError(customValidator))
                            return true;
                    }
                }
            }
        }
        return false;
    }
}
ErrorMagicComponent.ɵfac = function ErrorMagicComponent_Factory(t) { return new (t || ErrorMagicComponent)(i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(AccessorMagicService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); };
ErrorMagicComponent.ɵcmp = i0.ɵɵdefineComponent({ type: ErrorMagicComponent, selectors: [["mgError"]], viewQuery: function ErrorMagicComponent_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0$1, 5);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.CustomContent = _t.first);
    } }, inputs: { magic: "magic", rowId1: ["rowId", "rowId1"] }, ngContentSelectors: _c1, decls: 1, vars: 1, consts: [[4, "ngIf"], ["customContent", ""]], template: function ErrorMagicComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵprojectionDef();
        i0.ɵɵtemplate(0, ErrorMagicComponent_div_0_Template, 5, 1, "div", 0);
    } if (rf & 2) {
        i0.ɵɵproperty("ngIf", ctx.HasErrors(ctx.id));
    } }, dependencies: [i1.NgIf], encapsulation: 2 });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ErrorMagicComponent, [{
        type: Component,
        args: [{
                selector: 'mgError',
                template: `<div *ngIf="HasErrors(id)">
    <div #customContent>
      <ng-content></ng-content>
    </div>
     <span *ngIf="defaultDisplay">
      {{mgService.getErrMsg(id, rowId)}} 
    </span>
    </div>
`
            }]
    }], function () { return [{ type: TaskMagicService }, { type: AccessorMagicService }, { type: i0.ChangeDetectorRef }]; }, { magic: [{
            type: Input,
            args: ['magic']
        }], rowId1: [{
            type: Input,
            args: ['rowId']
        }], CustomContent: [{
            type: ViewChild,
            args: ['customContent', { static: false }]
        }] }); })();

class CheckboxMagicDirective {
    constructor(magicDirective) {
        this.magicDirective = magicDirective;
    }
    onChange($event) {
        this.magicDirective.task.onCheckChanged($event, this.magicDirective.id, +this.magicDirective.rowId);
    }
}
CheckboxMagicDirective.ɵfac = function CheckboxMagicDirective_Factory(t) { return new (t || CheckboxMagicDirective)(i0.ɵɵdirectiveInject(MagicDirective)); };
CheckboxMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: CheckboxMagicDirective, selectors: [["input", "type", "checkbox", "magic", "", 3, "noFormControl", ""]], hostBindings: function CheckboxMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("change", function CheckboxMagicDirective_change_HostBindingHandler($event) { return ctx.onChange($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxMagicDirective, [{
        type: Directive,
        args: [{
                selector: `
    input[type=checkbox][magic]:not([noFormControl])
`,
            }]
    }], function () { return [{ type: MagicDirective }]; }, { onChange: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();

class ComboboxMagicDirective {
    constructor(magicDirective) {
        this.magicDirective = magicDirective;
        this.magicDirective.task.refreshDom.pipe(filter(c => this.magicDirective.IsSameElement(c))).subscribe(value => {
            let command = value;
            if (command.Operation === HtmlProperties.ItemsList)
                this.onComboboxItemsListChanged();
        });
    }
    onChange($event) {
        this.magicDirective.task.onComboboxSelectionChanged($event, this.magicDirective.id, +this.magicDirective.rowId);
    }
    onComboboxItemsListChanged() {
        this.magicDirective.task.refreshView();
    }
}
ComboboxMagicDirective.ɵfac = function ComboboxMagicDirective_Factory(t) { return new (t || ComboboxMagicDirective)(i0.ɵɵdirectiveInject(MagicDirective)); };
ComboboxMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: ComboboxMagicDirective, selectors: [["select", "magic", "", 3, "multiple", ""]], hostBindings: function ComboboxMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("change", function ComboboxMagicDirective_change_HostBindingHandler($event) { return ctx.onChange($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ComboboxMagicDirective, [{
        type: Directive,
        args: [{
                selector: `select[magic]:not([multiple])`,
            }]
    }], function () { return [{ type: MagicDirective }]; }, { onChange: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();

class ExitMagicService {
    exitMagic() {
        console.log("Magic application terminated");
    }
}
ExitMagicService.ɵfac = function ExitMagicService_Factory(t) { return new (t || ExitMagicService)(); };
ExitMagicService.ɵprov = i0.ɵɵdefineInjectable({ token: ExitMagicService, factory: ExitMagicService.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ExitMagicService, [{
        type: Injectable
    }], null, null); })();

const _c0 = ["magicRoot"];
function MagicShellComponent_ndc_dynamic_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "ndc-dynamic", 6);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r1.RootComponent)("ndcDynamicInputs", ctx_r1.RootComponentParameters);
} }
function MagicShellComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7);
    i0.ɵɵelementContainer(1, 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext();
    const _r4 = i0.ɵɵreference(7);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngTemplateOutlet", ctx_r3.SpinnerTemplate ? ctx_r3.SpinnerTemplate : _r4);
} }
function MagicShellComponent_ng_template_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 9);
} }
class MagicShellComponent {
    constructor(engineMagicService, componentList, changeDetectorRef, titleService, overlayWindowService, httpClient, pendingCommandsCollector, exitMagicService) {
        this.engineMagicService = engineMagicService;
        this.componentList = componentList;
        this.changeDetectorRef = changeDetectorRef;
        this.titleService = titleService;
        this.overlayWindowService = overlayWindowService;
        this.httpClient = httpClient;
        this.pendingCommandsCollector = pendingCommandsCollector;
        this.exitMagicService = exitMagicService;
        this.RootComponent = null;
        this.magicEngineTerminated = false;
        this.initialize();
        this.setTitle();
    }
    onBeforeUnload(event) {
        if (this.engineMagicService.TransCacheExists()) {
            event.returnValue = 'Are you sure?';
            return 'Are you sure?';
        }
        else {
            this.engineMagicService.TerminateContextUsingFetchAPI();
            this.magicEngineTerminated = true;
        }
    }
    onUnload(event) {
        if (!this.magicEngineTerminated)
            this.engineMagicService.TerminateContextUsingFetchAPI();
    }
    ngAfterViewInit() {
        this.overlayWindowService.init(this.overlayWindowsContainerViewRef, this.rootMagicElementRef.nativeElement);
        this.engineMagicService.startMagicEngine(this.httpClient);
    }
    setViewContainerRef(vcRef) {
        this.overlayWindowsContainerViewRef = vcRef;
    }
    initialize() {
        this.registerUICommands();
    }
    setTitle() {
        const newTitle = this.componentList.title;
        this.titleService.setTitle(newTitle);
    }
    setComponent(formName, taskId, taskDescription, isModal) {
        this.pendingCommandsCollector.startCollecting();
        if (isModal) {
            this.overlayWindowService.open(formName, taskId, taskDescription);
        }
        else {
            this.RootComponent = this.componentList.getComponent(formName);
            this.RootComponentParameters = { taskIdParam: taskId, taskDescription: taskDescription };
        }
        this.changeDetectorRef.detectChanges();
    }
    registerUICommands() {
        this.engineMagicService.refreshDom.pipe(filter(command => command.TaskTag === '0'))
            .subscribe(command => {
            this.executeCommand(command);
        });
        this.engineMagicService
            .interactiveCommands.pipe(filter(command => command.TaskTag === '0'))
            .subscribe(command => {
            GuiInteractiveExecutor.executeInteractiveCommand(null, command, this.overlayWindowService);
        });
    }
    executeCommand(command) {
        switch (command.CommandType) {
            case CommandType.OPEN_FORM:
                this.setComponent(command.str, command.stringList[0], command.stringList[1], command.Bool1);
                break;
            case CommandType.SET_IS_LOGGED_IN:
                this.engineMagicService.setIsLoggedIn(command.Bool1);
                break;
            case CommandType.CLOSE_FORM:
                if (this.RootComponent != null && command.str === this.RootComponentParameters.taskIdParam) {
                    this.RootComponent = null;
                    this.RootComponentParameters = {};
                    this.changeDetectorRef.detectChanges();
                }
                else {
                    this.overlayWindowService.close(command.str);
                    this.changeDetectorRef.detectChanges();
                }
                break;
            case CommandType.RELOAD_PAGE:
                window.location.reload();
                break;
            case CommandType.SHOW_SPINNER:
                if (this.showSpinner != command.Bool1) {
                    this.showSpinner = command.Bool1;
                    this.changeDetectorRef.detectChanges();
                }
                break;
            case CommandType.EXIT_MAGIC:
                if (this.exitMagicService)
                    this.exitMagicService.exitMagic();
                break;
            case CommandType.SHOW_HTML_ERROR:
                window.document.write(command.str);
                break;
        }
    }
}
MagicShellComponent.ɵfac = function MagicShellComponent_Factory(t) { return new (t || MagicShellComponent)(i0.ɵɵdirectiveInject(EngineMagicService), i0.ɵɵdirectiveInject(ComponentListMagicService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.Title), i0.ɵɵdirectiveInject(OverlayWindowService), i0.ɵɵdirectiveInject(i1$2.HttpClient), i0.ɵɵdirectiveInject(CommandsCollectorMagicService), i0.ɵɵdirectiveInject(ExitMagicService, 8)); };
MagicShellComponent.ɵcmp = i0.ɵɵdefineComponent({ type: MagicShellComponent, selectors: [["magic-root"]], viewQuery: function MagicShellComponent_Query(rf, ctx) { if (rf & 1) {
        i0.ɵɵviewQuery(_c0, 7);
    } if (rf & 2) {
        let _t;
        i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.rootMagicElementRef = _t.first);
    } }, hostBindings: function MagicShellComponent_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("beforeunload", function MagicShellComponent_beforeunload_HostBindingHandler($event) { return ctx.onBeforeUnload($event); }, false, i0.ɵɵresolveWindow)("unload", function MagicShellComponent_unload_HostBindingHandler($event) { return ctx.onUnload($event); }, false, i0.ɵɵresolveWindow);
    } }, inputs: { SpinnerTemplate: "SpinnerTemplate" }, features: [i0.ɵɵProvidersFeature([])], decls: 8, vars: 2, consts: [["magicRoot", ""], [3, "ndcDynamicComponent", "ndcDynamicInputs", 4, "ngIf"], ["magicViewContainerRef", ""], ["overlayWindowsContainer", ""], ["class", "spinner-background", 4, "ngIf"], ["defaultSpinner", ""], [3, "ndcDynamicComponent", "ndcDynamicInputs"], [1, "spinner-background"], [3, "ngTemplateOutlet"], [1, "mgSpinnerClass"]], template: function MagicShellComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵelementStart(0, "div", null, 0);
        i0.ɵɵtemplate(2, MagicShellComponent_ndc_dynamic_2_Template, 1, 2, "ndc-dynamic", 1);
        i0.ɵɵelement(3, "div", 2, 3);
        i0.ɵɵelementEnd();
        i0.ɵɵtemplate(5, MagicShellComponent_div_5_Template, 2, 1, "div", 4);
        i0.ɵɵtemplate(6, MagicShellComponent_ng_template_6_Template, 1, 0, "ng-template", null, 5, i0.ɵɵtemplateRefExtractor);
    } if (rf & 2) {
        i0.ɵɵadvance(2);
        i0.ɵɵproperty("ngIf", ctx.RootComponent !== null);
        i0.ɵɵadvance(3);
        i0.ɵɵproperty("ngIf", ctx.showSpinner);
    } }, dependencies: [i1.NgIf, i1.NgTemplateOutlet, i3.DynamicComponent, i3.DynamicIoDirective, MagicViewContainerRef], styles: [".mgSpinnerClass[_ngcontent-%COMP%]{border:10px solid #cccccc;border-top:10px solid black;border-radius:50%;position:fixed;margin:auto;inset:0;width:100px;height:100px;animation:_ngcontent-%COMP%_spin 2s linear infinite}.spinner-background[_ngcontent-%COMP%]{position:fixed;z-index:1000;inset:0;opacity:.5}@keyframes _ngcontent-%COMP%_spin{0%{transform:rotate(0)}to{transform:rotate(360deg)}}"] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicShellComponent, [{
        type: Component,
        args: [{ selector: 'magic-root', providers: [], template: `
    <div #magicRoot>
      <ndc-dynamic
        *ngIf = "RootComponent !== null"
        [ndcDynamicComponent]="RootComponent"
        [ndcDynamicInputs]   ="RootComponentParameters">
      </ndc-dynamic>

      <div #overlayWindowsContainer magicViewContainerRef>
      </div>
    </div>

    <div class="spinner-background" *ngIf="showSpinner">
      <ng-container [ngTemplateOutlet]="SpinnerTemplate ? SpinnerTemplate:defaultSpinner"></ng-container>
    </div>

    <ng-template #defaultSpinner>
      <div class="mgSpinnerClass"></div>
    </ng-template>
  `, styles: [".mgSpinnerClass{border:10px solid #cccccc;border-top:10px solid black;border-radius:50%;position:fixed;margin:auto;inset:0;width:100px;height:100px;animation:spin 2s linear infinite}.spinner-background{position:fixed;z-index:1000;inset:0;opacity:.5}@keyframes spin{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n"] }]
    }], function () { return [{ type: EngineMagicService }, { type: ComponentListMagicService }, { type: i0.ChangeDetectorRef }, { type: i1$1.Title }, { type: OverlayWindowService }, { type: i1$2.HttpClient }, { type: CommandsCollectorMagicService }, { type: ExitMagicService, decorators: [{
                type: Optional
            }] }]; }, { rootMagicElementRef: [{
            type: ViewChild,
            args: ['magicRoot', { static: true }]
        }], SpinnerTemplate: [{
            type: Input
        }], onBeforeUnload: [{
            type: HostListener,
            args: ['window:beforeunload', ['$event']]
        }], onUnload: [{
            type: HostListener,
            args: ['window:unload', ['$event']]
        }] }); })();

const CHECKBOX_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => MagicCheckboxControlValueAccessor),
    multi: true,
};
class MagicCheckboxControlValueAccessor extends CheckboxControlValueAccessor {
}
MagicCheckboxControlValueAccessor.ɵfac = function () { let ɵMagicCheckboxControlValueAccessor_BaseFactory; return function MagicCheckboxControlValueAccessor_Factory(t) { return (ɵMagicCheckboxControlValueAccessor_BaseFactory || (ɵMagicCheckboxControlValueAccessor_BaseFactory = i0.ɵɵgetInheritedFactory(MagicCheckboxControlValueAccessor)))(t || MagicCheckboxControlValueAccessor); }; }();
MagicCheckboxControlValueAccessor.ɵdir = i0.ɵɵdefineDirective({ type: MagicCheckboxControlValueAccessor, selectors: [["input", "type", "checkbox", "magic", "", 3, "formControlName", "", 3, "no-form-control", ""], ["input", "type", "checkbox", "magic", "", 3, "formControl", ""], ["input", "type", "checkbox", "magic", "", 3, "ngModel", ""]], hostBindings: function MagicCheckboxControlValueAccessor_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("change", function MagicCheckboxControlValueAccessor_change_HostBindingHandler($event) { return ctx.onChange($event.target.checked); })("blur", function MagicCheckboxControlValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
    } }, features: [i0.ɵɵProvidersFeature([CHECKBOX_VALUE_ACCESSOR]), i0.ɵɵInheritDefinitionFeature] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicCheckboxControlValueAccessor, [{
        type: Directive,
        args: [{
                selector: `
      input[type=checkbox][magic]:not([formControlName]):not([no-form-control]),
      input[type=checkbox][magic]:not([formControl]),
      input[type=checkbox][magic]:not([ngModel])
    `,
                host: { '(change)': 'onChange($event.target.checked)', '(blur)': 'onTouched()' },
                providers: [CHECKBOX_VALUE_ACCESSOR]
            }]
    }], null, null); })();

const MAGIC_DEFAULT_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => MagicDefaultValueAccessor),
    multi: true
};
class MagicDefaultValueAccessor extends DefaultValueAccessor {
}
MagicDefaultValueAccessor.ɵfac = function () { let ɵMagicDefaultValueAccessor_BaseFactory; return function MagicDefaultValueAccessor_Factory(t) { return (ɵMagicDefaultValueAccessor_BaseFactory || (ɵMagicDefaultValueAccessor_BaseFactory = i0.ɵɵgetInheritedFactory(MagicDefaultValueAccessor)))(t || MagicDefaultValueAccessor); }; }();
MagicDefaultValueAccessor.ɵdir = i0.ɵɵdefineDirective({ type: MagicDefaultValueAccessor, selectors: [["input", "magic", "", 3, "type", "checkbox", 3, "formControlName", "", 3, "no-form-control", ""], ["textarea", "magic", "", 3, "formControlName", "", 3, "noFormControl", "", 3, "no-form-control", ""]], hostBindings: function MagicDefaultValueAccessor_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("input", function MagicDefaultValueAccessor_input_HostBindingHandler($event) { return ctx._handleInput($event.target.value); })("blur", function MagicDefaultValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); })("compositionstart", function MagicDefaultValueAccessor_compositionstart_HostBindingHandler() { return ctx._compositionStart(); })("compositionend", function MagicDefaultValueAccessor_compositionend_HostBindingHandler($event) { return ctx._compositionEnd($event.target.value); });
    } }, exportAs: ["magic"], features: [i0.ɵɵProvidersFeature([MAGIC_DEFAULT_VALUE_ACCESSOR]), i0.ɵɵInheritDefinitionFeature] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicDefaultValueAccessor, [{
        type: Directive,
        args: [{
                selector: `
    input[magic]:not([type=checkbox]):not([formControlName]):not([no-form-control]),
    textarea[magic]:not([formControlName]):not([noFormControl]):not([no-form-control])
  `,
                host: {
                    '(input)': '$any(this)._handleInput($event.target.value)',
                    '(blur)': 'onTouched()',
                    '(compositionstart)': '$any(this)._compositionStart()',
                    '(compositionend)': '$any(this)._compositionEnd($event.target.value)'
                },
                providers: [MAGIC_DEFAULT_VALUE_ACCESSOR],
                exportAs: 'magic'
            }]
    }], null, null); })();

class CheckboxNoFormControlMagicDirective {
    constructor(magicDirective) {
        this.magicDirective = magicDirective;
    }
    onChange($event) {
        this.magicDirective.task.onCheckChanged($event, this.magicDirective.id, +this.magicDirective.rowId);
    }
}
CheckboxNoFormControlMagicDirective.ɵfac = function CheckboxNoFormControlMagicDirective_Factory(t) { return new (t || CheckboxNoFormControlMagicDirective)(i0.ɵɵdirectiveInject(MagicDirective)); };
CheckboxNoFormControlMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: CheckboxNoFormControlMagicDirective, selectors: [["input", "type", "checkbox", "magic", "", "noFormControl", ""]], hostBindings: function CheckboxNoFormControlMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("change", function CheckboxNoFormControlMagicDirective_change_HostBindingHandler($event) { return ctx.onChange($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxNoFormControlMagicDirective, [{
        type: Directive,
        args: [{
                selector: `
    input[type=checkbox][magic]:([noFormControl])   
    `,
            }]
    }], function () { return [{ type: MagicDirective }]; }, { onChange: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();

class InputNoFormControlMagicDirective {
    constructor(magicDirective) {
        this.magicDirective = magicDirective;
    }
    onChange($event) {
        this.magicDirective.task.setInputTextValue(this.magicDirective.id, this.magicDirective.rowId, event.srcElement.value);
    }
}
InputNoFormControlMagicDirective.ɵfac = function InputNoFormControlMagicDirective_Factory(t) { return new (t || InputNoFormControlMagicDirective)(i0.ɵɵdirectiveInject(MagicDirective)); };
InputNoFormControlMagicDirective.ɵdir = i0.ɵɵdefineDirective({ type: InputNoFormControlMagicDirective, selectors: [["input", "magic", "", "noFormControl", "", 3, "type", "checkbox"], ["textarea", "magic", "", "noFormControl", "", 3, "type", "checkbox"]], hostBindings: function InputNoFormControlMagicDirective_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("change", function InputNoFormControlMagicDirective_change_HostBindingHandler($event) { return ctx.onChange($event); });
    } } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InputNoFormControlMagicDirective, [{
        type: Directive,
        args: [{
                selector: `input[magic]:([noFormControl]):not([type=checkbox]),
             textarea[magic]:([noFormControl]):not([type=checkbox])`
            }]
    }], function () { return [{ type: MagicDirective }]; }, { onChange: [{
            type: HostListener,
            args: ['change', ['$event']]
        }] }); })();

const DATE_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => DateValueAccessor),
    multi: true
};
class DateValueAccessor {
    constructor(renderer, elementRef) {
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    writeValue(value) {
        if (!value) {
            this.renderer.setProperty(this.elementRef.nativeElement, "value", null);
            return;
        }
        this.renderer.setProperty(this.elementRef.nativeElement, "valueAsDate", new Date(Date.UTC(value.getFullYear(), value.getMonth(), value.getDate())));
    }
    registerOnChange(fn) {
        this.onChange = v => fn(v instanceof Date
            ? new Date(v.getUTCFullYear(), v.getUTCMonth(), v.getUTCDate())
            : v);
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.renderer.setProperty(this.elementRef.nativeElement, "disabled", isDisabled);
    }
}
DateValueAccessor.ɵfac = function DateValueAccessor_Factory(t) { return new (t || DateValueAccessor)(i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ElementRef)); };
DateValueAccessor.ɵdir = i0.ɵɵdefineDirective({ type: DateValueAccessor, selectors: [["", "dateInput", ""]], hostBindings: function DateValueAccessor_HostBindings(rf, ctx) { if (rf & 1) {
        i0.ɵɵlistener("input", function DateValueAccessor_input_HostBindingHandler($event) { return ctx.onChange($event.target.valueAsDate); })("blur", function DateValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
    } }, features: [i0.ɵɵProvidersFeature([DATE_VALUE_ACCESSOR])] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateValueAccessor, [{
        type: Directive,
        args: [{
                selector: "[dateInput]",
                providers: [DATE_VALUE_ACCESSOR]
            }]
    }], function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }]; }, { onChange: [{
            type: HostListener,
            args: ["input", ["$event.target.valueAsDate"]]
        }], onTouched: [{
            type: HostListener,
            args: ["blur", []]
        }] }); })();

class NonMagicControlDirective {
    set magic(val) {
        this.id = val;
        this.selector = 'NonMagicControl';
    }
    ;
    constructor(_task, element, renderer, vcRef) {
        this._task = _task;
        this.element = element;
        this.renderer = renderer;
        this.vcRef = vcRef;
        this.eventHandlers = {};
        this.eventsOnlyVal = false;
        this.htmlElement = this.element.nativeElement;
    }
    get task() {
        return this._task;
    }
    regEvents() {
        this.eventHandlers['focusin'] = this.OnFocus.bind(this);
        Object.keys(this.eventHandlers).forEach((key) => {
            this.renderer.listen(this.htmlElement, key, this.eventHandlers[key]);
        });
    }
    OnFocus() {
        this.task.insertEvent(getGuiEventObj('focusOnNonMagicControl', '', -1));
        event.cancelBubble = true;
    }
    ngOnInit() {
        this.regEvents();
    }
}
NonMagicControlDirective.ɵfac = function NonMagicControlDirective_Factory(t) { return new (t || NonMagicControlDirective)(i0.ɵɵdirectiveInject(TaskMagicService), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.Renderer2), i0.ɵɵdirectiveInject(i0.ViewContainerRef)); };
NonMagicControlDirective.ɵdir = i0.ɵɵdefineDirective({ type: NonMagicControlDirective, selectors: [["", "NonMagicControl", ""]], inputs: { magic: ["NonMagicControl", "magic"] } });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NonMagicControlDirective, [{
        type: Directive,
        args: [{
                selector: '[NonMagicControl]'
            }]
    }], function () { return [{ type: TaskMagicService }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i0.ViewContainerRef }]; }, { magic: [{
            type: Input,
            args: ['NonMagicControl']
        }] }); })();

class Time24MagicPipe {
    constructor(_task) {
        this._task = _task;
    }
    transform(value, controlId) {
        let mask = this._task.GetControlPictureMask(controlId).getMask();
        if (typeof value !== "undefined" && mask !== null) {
            const date = new Date(value);
            const hours = date.getHours().toString().padStart(2, '0');
            const minutes = date.getMinutes().toString().padStart(2, '0');
            const seconds = date.getSeconds().toString().padStart(2, '0');
            if (mask.length == 5) {
                return `${hours}:${minutes}`;
            }
            else if (mask.length > 5) {
                return `${hours}:${minutes}:${seconds}`;
            }
        }
        return value;
    }
}
Time24MagicPipe.ɵfac = function Time24MagicPipe_Factory(t) { return new (t || Time24MagicPipe)(i0.ɵɵdirectiveInject(TaskMagicService, 16)); };
Time24MagicPipe.ɵpipe = i0.ɵɵdefinePipe({ name: "magicTime24", type: Time24MagicPipe, pure: true });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(Time24MagicPipe, [{
        type: Pipe,
        args: [{
                name: 'magicTime24'
            }]
    }], function () { return [{ type: TaskMagicService }]; }, null); })();

const decs = [
    MagicDirective,
    CheckboxMagicDirective,
    CheckboxNoFormControlMagicDirective,
    InputNoFormControlMagicDirective,
    ComboboxMagicDirective,
    RowMagicDirective,
    MagicCheckboxControlValueAccessor,
    MagicDefaultValueAccessor,
    DateValueAccessor,
    TaskBaseMagicComponent,
    MagicOverlayContainer,
    MagicAlertComponent,
    MagicConfirmationBoxComponent,
    BaseMagicAlertComponent,
    BaseMagicConfirmComponent,
    MagicOverlayContainerWrapper,
    RouterContainerMagicComponent,
    MagicShellComponent,
    SubformMagicComponent,
    ErrorMagicComponent,
    NoControlMagicDirective,
    MgformatMagicDirective,
    DateMagicPipe,
    TimeMagicPipe,
    RangeValidatorMagicDirective,
    NonMagicControlDirective,
    MagicFocusDirective,
    MagicViewContainerRef,
    Time24MagicPipe
];
class MagicModule {
}
MagicModule.ɵfac = function MagicModule_Factory(t) { return new (t || MagicModule)(); };
MagicModule.ɵmod = i0.ɵɵdefineNgModule({ type: MagicModule });
MagicModule.ɵinj = i0.ɵɵdefineInjector({ providers: [ConfirmationComponentsMagicProvider, OverlayContainerMagicProvider], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        RouterModule,
        DynamicModule,
        HttpClientModule, MaskitoModule] });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MagicModule, [{
        type: NgModule,
        args: [{
                declarations: [...decs],
                exports: [...decs, MaskitoModule],
                entryComponents: [],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule,
                    RouterModule,
                    DynamicModule,
                    HttpClientModule
                ],
                providers: [ConfirmationComponentsMagicProvider, OverlayContainerMagicProvider]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(MagicModule, { declarations: [MagicDirective,
        CheckboxMagicDirective,
        CheckboxNoFormControlMagicDirective,
        InputNoFormControlMagicDirective,
        ComboboxMagicDirective,
        RowMagicDirective,
        MagicCheckboxControlValueAccessor,
        MagicDefaultValueAccessor,
        DateValueAccessor,
        TaskBaseMagicComponent,
        MagicOverlayContainer,
        MagicAlertComponent,
        MagicConfirmationBoxComponent,
        BaseMagicAlertComponent,
        BaseMagicConfirmComponent,
        MagicOverlayContainerWrapper,
        RouterContainerMagicComponent,
        MagicShellComponent,
        SubformMagicComponent,
        ErrorMagicComponent,
        NoControlMagicDirective,
        MgformatMagicDirective,
        DateMagicPipe,
        TimeMagicPipe,
        RangeValidatorMagicDirective,
        NonMagicControlDirective,
        MagicFocusDirective,
        MagicViewContainerRef,
        Time24MagicPipe], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        RouterModule,
        DynamicModule,
        HttpClientModule], exports: [MagicDirective,
        CheckboxMagicDirective,
        CheckboxNoFormControlMagicDirective,
        InputNoFormControlMagicDirective,
        ComboboxMagicDirective,
        RowMagicDirective,
        MagicCheckboxControlValueAccessor,
        MagicDefaultValueAccessor,
        DateValueAccessor,
        TaskBaseMagicComponent,
        MagicOverlayContainer,
        MagicAlertComponent,
        MagicConfirmationBoxComponent,
        BaseMagicAlertComponent,
        BaseMagicConfirmComponent,
        MagicOverlayContainerWrapper,
        RouterContainerMagicComponent,
        MagicShellComponent,
        SubformMagicComponent,
        ErrorMagicComponent,
        NoControlMagicDirective,
        MgformatMagicDirective,
        DateMagicPipe,
        TimeMagicPipe,
        RangeValidatorMagicDirective,
        NonMagicControlDirective,
        MagicFocusDirective,
        MagicViewContainerRef,
        Time24MagicPipe, MaskitoModule] }); })();

const MG_FORMATS = {
    parse: { dateInput: { month: 'short', year: 'numeric', day: 'numeric' } },
    display: {
        dateInput: 'input',
        monthYearLabel: { year: 'numeric', month: 'short' },
        dateA11yLabel: { year: 'numeric', month: 'long', day: 'numeric' },
        monthYearA11yLabel: { year: 'numeric', month: 'long' }
    }
};
class MgDateAdapter extends NativeDateAdapter {
    constructor(platform, task, localeId) {
        super(localeId, platform);
        this.platform = platform;
        this.task = task;
        this.localeId = localeId;
        this.mgdtfmt = null;
        this.setLocale(localeId);
    }
    parse(value) {
        let valueStr = value;
        let date = 0, month = 0, year = 0;
        let mgDateMask = this.mgdtfmt;
        let sep = valueStr.indexOf('/') > 0 ? '/' : '-';
        if (value == null || value == "")
            return null;
        if (this.mgdtfmt == null && this.task.mgInputDateFormat != null)
            this.mgdtfmt = this.task.mgInputDateFormat;
        if ((this.mgdtfmt.indexOf('MMM') > 0) || (this.mgdtfmt.indexOf('MMMM') > 0))
            return new Date(value);
        if (mgDateMask !== null) {
            for (let i = 0; i < mgDateMask.length;) {
                switch (mgDateMask[i]) {
                    case 'd':
                        {
                            let tmpStr;
                            let len = valueStr.indexOf(sep, 0);
                            tmpStr = len == -1 ? valueStr : valueStr.substr(0, len);
                            if (len > -1)
                                valueStr = valueStr.substr(len + 1);
                            for (; mgDateMask[i] == 'd'; i++)
                                ;
                            date = (Number)(tmpStr);
                        }
                        break;
                    case 'M':
                        {
                            let tmpStr;
                            let len = valueStr.indexOf(sep, 0);
                            tmpStr = len == -1 ? valueStr : valueStr.substr(0, len);
                            if (len > -1)
                                valueStr = valueStr.substr(len + 1);
                            for (; mgDateMask[i] == 'M'; i++)
                                ;
                            month = (Number)(tmpStr) > 0 ? (Number)(tmpStr) - 1 : 0;
                        }
                        break;
                    case 'y':
                        {
                            let tmpStr;
                            let len = valueStr.indexOf(sep, 0);
                            tmpStr = len == -1 ? valueStr : valueStr.substr(0, len);
                            if (len > -1) {
                                valueStr = valueStr.substr(len + 1);
                            }
                            for (; mgDateMask[i] == 'y'; i++)
                                ;
                            year = (Number)(tmpStr);
                        }
                        break;
                    default:
                        i++;
                        break;
                }
            }
            if (month == 0 && year == 0 && date == 0)
                return null;
            return new Date(year, month, date);
        }
    }
    format(date, displayFormat) {
        if (this.mgdtfmt == null && this.task.mgInputDateFormat != null)
            this.mgdtfmt = this.task.mgInputDateFormat;
        if (displayFormat === 'input') {
            if (this.mgdtfmt == null)
                this.mgdtfmt = 'M/d/yyyy';
            return formatDate(date, this.mgdtfmt, this.locale);
        }
        else {
            return date.toDateString();
        }
    }
}
MgDateAdapter.ɵfac = function MgDateAdapter_Factory(t) { return new (t || MgDateAdapter)(i0.ɵɵinject(i1$3.Platform), i0.ɵɵinject(TaskMagicService), i0.ɵɵinject(MAT_DATE_LOCALE)); };
MgDateAdapter.ɵprov = i0.ɵɵdefineInjectable({ token: MgDateAdapter, factory: MgDateAdapter.ɵfac });
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MgDateAdapter, [{
        type: Injectable
    }], function () { return [{ type: i1$3.Platform }, { type: TaskMagicService }, { type: undefined, decorators: [{
                type: Inject,
                args: [MAT_DATE_LOCALE]
            }] }]; }, null); })();

const matDateProviders = [
    { provide: DateAdapter, useClass: MgDateAdapter },
    { provide: MAT_DATE_FORMATS, useValue: MG_FORMATS }
];
const basicMagicProviders = [
    MagicServices,
    TaskMagicService,
    SubformMagicService,
    TitleMagicService,
    AccessorMagicService,
    matDateProviders,
];
const magicProviders = [
    ...basicMagicProviders,
    TableMagicService
];

class utils {
    static getDistance(control, x, y) {
        let left = control.clientLeft, top = control.clientTop;
        let dx, dy;
        const right = left + control.clientWidth;
        const bottom = top + control.clientHeight;
        if (x < left) {
            dx = left - x;
        }
        else if (x > right) {
            dx = x - right;
        }
        else {
            dx = 0;
        }
        if (y < top) {
            dy = top - y;
        }
        else if (y > bottom) {
            dy = y - bottom;
        }
        else {
            dy = 0;
        }
        const ret = (dx * dx + dy * dy);
        return ret;
    }
    static getDimentions(el) {
        let xPos = 0;
        let yPos = 0;
        let width = el.width;
        let height = el.height;
        while (el) {
            if (el.tagName == "BODY") {
                let xScroll = el.scrollLeft || document.documentElement.scrollLeft;
                let yScroll = el.scrollTop || document.documentElement.scrollTop;
                xPos += (el.offsetLeft - xScroll + el.clientLeft);
                yPos += (el.offsetTop - yScroll + el.clientTop);
            }
            else {
                xPos += (el.offsetLeft - el.scrollLeft + el.clientLeft);
                yPos += (el.offsetTop - el.scrollTop + el.clientTop);
            }
            el = el.offsetParent;
        }
        return {
            x: xPos,
            y: yPos,
            width: width,
            height: height
        };
    }
}

class ModalFormDefinition {
    constructor() {
        this.taskId = "";
        this.comp = null;
        this.parameters = {};
    }
}

export { AccessorMagicService, BaseMagicAlertComponent, BaseMagicConfirmComponent, BaseMagicOverlayContainer, CHECKBOX_VALUE_ACCESSOR, COLOR_FILE_NAME, CheckboxMagicDirective, CheckboxNoFormControlMagicDirective, ComboboxMagicDirective, CommandsCollectorMagicService, ComponentListMagicService, ConfirmationComponentsMagicProvider, Constants, ControlMetadata, ControlsMetadata, DATE_VALUE_ACCESSOR, DateMagicPipe, DateValueAccessor, EngineMagicService, ErrorMagicComponent, ExitMagicService, GuiInteractiveExecutor, HtmlClasses, InputNoFormControlMagicDirective, MAGIC_BG_COLOR, MAGIC_DEFAULT_VALUE_ACCESSOR, MAGIC_FG_COLOR, MG_FORMATS, MagicAlertComponent, MagicCheckboxControlValueAccessor, MagicColorService, MagicConfirmationBoxComponent, MagicDefaultValueAccessor, MagicDirective, MagicFocusDirective, MagicLazyLoaderService, MagicModule, MagicOverlayContainer, MagicOverlayContainerWrapper, MagicServices, MagicShellComponent, MagicViewContainerRef, MgDateAdapter, MgDateFormatter, MgformatMagicDirective, ModalFormDefinition, NoControlMagicDirective, NonMagicControlDirective, OverlayContainerMagicProvider, OverlayWindowService, RangeValidatorMagicDirective, Records, RouteCommand, RouterCommandsMagicService, RouterContainerMagicComponent, RowMagicDirective, StylesMapManager, SubformMagicComponent, SubformMagicService, TableMagicService, TaskBaseMagicComponent, TaskMagicService, Time24MagicPipe, TimeMagicPipe, TitleMagicService, basicMagicProviders, confirmationBox, magicProviders, matDateProviders, utils };
//# sourceMappingURL=magic-xpa-angular.mjs.map
