import { StorageAttribute } from "@magic-xpa/utils";
import { HtmlProperties, CustomValidator } from "@magic-xpa/gui";
export declare class ControlMetadata {
    controlType: string;
    dataType: StorageAttribute;
    properties: Map<HtmlProperties, any>;
    classesMap: Map<HtmlClasses, any>;
    stylesMap: Map<HtmlClasses, any>;
    removedClass: string;
    classes: string;
    rangeValidator: boolean;
    userProperties: Map<string, any>;
    customValidators: Map<string, CustomValidator>;
    setClass(key: any, value: any): void;
    setStyle(key: any, value: any): void;
}
export declare class ControlsMetadata {
    values: Map<string, string>;
    ControlsProperties: Map<string, ControlMetadata>;
    rowId: string;
    isCreated: boolean;
    isEditing: boolean;
    get Values(): Map<string, string>;
    getControlMetadata(controlId: string): ControlMetadata;
    update(obj: any): void;
    setValue(controlName: string, value: any): void;
    getProperty(controlId: string, prop: HtmlProperties): any;
    getValue(controlName: string): string;
}
export declare class Records {
    data: Map<number, ControlsMetadata>;
    list: ControlsMetadata[];
    includesFirst: boolean;
    includesLast: boolean;
    guiTopIndex: number;
    recordsBeforeCurrentView: number;
    isEmptyDataView: boolean;
    sizeUpdated: boolean;
    getRow(dvRowId: number): ControlsMetadata;
    markRowAsCreated(guiRowId: number): void;
    markRowAsNotCreated(guiRowId: number): void;
    isRowCreated(guiRowId: number): boolean;
    startRowEditing(guiRowId: number): void;
    stopRowEditing(guiRowId: number): void;
    isRowInRowEditing(guiRowId: string): boolean;
    update(obj: any): void;
    updateSize(len: number): void;
    clearFirstTableRecord(template: {
        [id: string]: string;
    }): void;
    addRow(guiRowId: number): void;
    createFirst(): void;
    fromJson(data: string): void;
    setGuiTopIndex(topIndex: number): void;
    getGuiTopIndex(): number;
}
export declare enum HtmlClasses {
    Color = "color",
    font = "font",
    FocusColor = "focuscolor",
    HintColor = "hintcolor"
}
