import { Subject } from "rxjs";
import { IGuiEvent, MagicBridge } from "@magic-xpa/engine";
import { GuiCommand, GuiInteractive } from "@magic-xpa/gui";
import { HttpClient } from "@angular/common/http";
import * as i0 from "@angular/core";
export declare class EngineMagicService {
    magicBridge: typeof MagicBridge;
    isStub: boolean;
    isLoggedIn: boolean;
    refreshDom: Subject<GuiCommand>;
    interactiveCommands: Subject<GuiInteractive>;
    startMagicEngine(httpClient: HttpClient): void;
    terminateMagic(): Promise<void>;
    insertEvent(guiEvent: IGuiEvent): void;
    GetRangedValue(taskId: string, controlName: string, value: string): string;
    GetControlPictureMask(taskId: string, controlName: string): any;
    GetFormattedValue(taskId: string, controlName: string, value: any, rowId?: string): any;
    ValidateControlValue(taskId: string, controlName: string, value: any): string;
    GetFldRanges(taskId: string, controlName: string): string;
    saveData(data: string): void;
    getIsLoggedIn(): boolean;
    setIsLoggedIn(setIsLoggedIn: boolean): void;
    TransCacheExists(): boolean;
    TerminateContextUsingFetchAPI(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<EngineMagicService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<EngineMagicService>;
}
