import { EventEmitter } from '@angular/core';
import { AbstractControl, FormControl, FormGroup, ValidatorFn } from '@angular/forms';
import { Subject, Subscription } from 'rxjs';
import { EngineMagicService } from './engine.magic.service';
import { GuiCommand, GuiInteractive, HtmlProperties } from '@magic-xpa/gui';
import { IGuiEvent } from '@magic-xpa/engine';
import { SubformMagicService } from './subform.magic.service';
import { TitleMagicService } from './title.magic.service';
import { AccessorMagicService } from './accessor.magic.service';
import { OverlayWindowService } from './OverlayWindowService';
import * as i0 from "@angular/core";
export declare class TaskMagicService {
    protected magic: EngineMagicService;
    private overlayWindowService;
    tableService: any;
    Records: any;
    formGroups: Array<FormGroup>;
    ScreenModeControls: FormGroup;
    refreshDom: Subject<GuiCommand>;
    subscribeRefreshDom: Subscription;
    detectChanges: Subject<any>;
    subscribeInteractiveCommands: Subscription;
    interactiveCommands: Subject<GuiInteractive>;
    OnSelectedRowChanged: EventEmitter<string>;
    customPropertiesSubject: Subject<any>;
    recordsCountChangeSubject: Subject<any>;
    mgLoadSubject: Subject<any>;
    template: {
        [id: string]: string;
    };
    mgSubformService: SubformMagicService;
    mgTitleService: TitleMagicService;
    mgAccessorService: AccessorMagicService;
    mgInputDateFormat: any;
    oldPageSize: number;
    constructor(magic: EngineMagicService, overlayWindowService: OverlayWindowService);
    getIsLoggenIn(): boolean;
    _taskId: string;
    get taskId(): string;
    set taskId(value: string);
    get ScreenControlsData(): any;
    settemplate(value: any): void;
    buildScreenModeControls(): void;
    isTableControl(id: string): boolean;
    getMgInputDateFormat(): string;
    getFormControl(guiRowid: string, id: string): AbstractControl;
    setInputTextValue(controlId: string, guiRowid: string, val: any): void;
    buildTableRowControls(guiRowId: number): void;
    updateRecordsBeforeCurrentView(value: number): void;
    setIncludesFirst(value: boolean): void;
    setIncludesLast(value: boolean): void;
    markRowAsCreated(guiRowId: number): void;
    markRowAsNotCreated(guiRowId: number): void;
    startRowEditing(guiRowId: number): void;
    stopRowEditing(guiRowId: number): void;
    isRowInRowEditing(guiRowId: string): boolean;
    setIsEmptyDataView(isEmpty: boolean): void;
    initTask(taskId: any, taskDescription: any): void;
    refreshView(): void;
    insertEvent(guiEvent: IGuiEvent): void;
    GetControlPictureMask(controlName: string): any;
    ValidateControlValue(controlName: string, value: any): string;
    GetRangedValue(controlName: string, value: string): string;
    GetFldRanges(controlName: string): string;
    getProperty(controlId: string, prop: HtmlProperties, guiRowId?: string): any;
    getPropertyStub(ControlsProperties: any, controlId: any, prop: any): any;
    getStyleStub(ControlsProperties: any, controlId: any, styleName: string): any;
    getClasses(controlId: string, guiRowId?: string): string;
    getStyle(controlId: string, styleName: string, guiRowId?: string): string;
    getValue(controlId: string, guiRowId?: string): any;
    getFormattedValue(controlName: string, val: any, rowId?: string): string;
    setValue(controlId: string, guiRowId: string, value: any): void;
    protected executeInteractiveCommand(guiInteractiveCommand: GuiInteractive): void;
    handleSetProperty(command: GuiCommand, isTableChild: boolean): void;
    executeCommand(command: GuiCommand): void;
    customValidator(rowid: string, id: string): ValidatorFn;
    ConvertValToNative(controlId: string, rowId: number, val: any): any;
    ConvertValFromNative(controlId: string, rowId: number, val: any): any;
    resize(pageSize: number, topGuiRowId: number): void;
    onScrollDown(): void;
    setTitle(newTitle: string): void;
    getGuiRowId(dvRowId: number, isTableControl: boolean): number;
    getDvRowId(guiRowId: number): number;
    dispose(): void;
    onComboboxSelectionChanged(event: Event, idx: string, line: number): void;
    onListBoxSelectionChanged(event: Event, idx: string): void;
    onCheckChanged(event: Event, idx: string, rowId: number): void;
    mgOnTabSelectionChanged(idx: string, layer: number): void;
    mgOnRadioSelectionChanged(idx: string): void;
    close(): void;
    IsStub(): boolean;
    jsonData: string;
    saveData(data: string): void;
    createData(): void;
    loadStubData(stubData: any): void;
    loadData(): void;
    setStubValue(guiRowId: number, fc: FormControl, name: string): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TaskMagicService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TaskMagicService>;
}
