"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Log = exports.LogLn = exports.logErr = exports.Util = void 0;
const process = require("process");
const env_1 = require("./env");
// @dynamic
class Util {
    static enumNameByVal(enumm, val) {
        return Object.keys(enumm).find(key => enumm[key] === val);
    }
}
exports.Util = Util;
function logErr(err) {
    process.stderr.write('ERR' + err + '\r\n');
}
exports.logErr = logErr;
function LogLn(msg) {
    if (!env_1.env.prevent_log)
        process.stdout.write(msg + '\r\n');
}
exports.LogLn = LogLn;
function Log(msg) {
    if (!env_1.env.prevent_log)
        return process.stdout.write(msg);
}
exports.Log = Log;
//# sourceMappingURL=Util.js.map