"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prettierConfig = exports.getTemplateConfig = exports.sourceAngularTemplateRootForCli = exports.sourceAngularTemplateRoot = void 0;
const generated_file_types_enum_1 = require("../../types/enums/generated-file-types.enum");
exports.sourceAngularTemplateRoot = './templates/angular/src';
exports.sourceAngularTemplateRootForCli = './templates/angular/src';
function getTemplateConfig(app, magic_config, manifest) {
    const appId = app.name, appRoot = magic_config.output_folder + `\\${appId}`, data = {
        app: app,
        manifest: manifest,
    };
    let configs_array = [
        /*
                {
                    template   : `${this.sourceAngularTemplateRoot}/app.module.ts`,
                    name       : 'app.module.ts',
                    destination: `${appRoot}/src/app`,
                    type       : GeneratedFileTypes.TS,
                    data       : data
                },
        */
        {
            template: `${this.sourceAngularTemplateRoot}/styles/app.css`,
            name: 'app.css',
            destination: `${appRoot}/src/app/styles`,
            type: generated_file_types_enum_1.GeneratedFileTypes.CSS,
            data: data
        },
        /*
                {
                    template   : `${this.sourceAngularTemplateRoot}/app/magic/magic.core.module.ts`,
                    name       : 'magic.core.module.ts',
                    destination: `${appRoot}/src/app/magic`,
                    type       : GeneratedFileTypes.TS,
                    data       : data
                }
        */
        {
            template: `${this.sourceAngularTemplateRoot}/app/component-list.g.ts`,
            name: 'component-list.g.ts',
            destination: `${appRoot}/src/app`,
            type: generated_file_types_enum_1.GeneratedFileTypes.TS,
            data: data
        },
    ];
    return configs_array;
}
exports.getTemplateConfig = getTemplateConfig;
;
exports.prettierConfig = {
    trailingComma: 'none',
    bracketSpacing: true,
    parser: 'typescript',
    useTabs: true,
    tabWidth: 4
};
//# sourceMappingURL=config.js.map