import {AppJson, AppConfig, AppManifest} from '../../types/interfaces/app';
import {TemplateConfig} from '../../types/interfaces/template.config';
import {GeneratedFileTypes} from '../../types/enums/generated-file-types.enum';

export const sourceAngularTemplateRoot       = './templates/angular/src';
export const sourceAngularTemplateRootForCli = './templates/angular/src';


export function getTemplateConfig(app: AppJson, magic_config: AppConfig, manifest: AppManifest):TemplateConfig[]
{
  const
    appId     = app.name,
    appRoot   = magic_config.output_folder + `\\${appId}`,
    data: any = {
      app: app,
      manifest: manifest,
    };

  let configs_array = [
    /*
            {
                template   : `${this.sourceAngularTemplateRoot}/app.module.ts`,
                name       : 'app.module.ts',
                destination: `${appRoot}/src/app`,
                type       : GeneratedFileTypes.TS,
                data       : data
            },
    */

    {
      template   : `${this.sourceAngularTemplateRoot}/styles/app.css`,
      name       : 'app.css',
      destination: `${appRoot}/src/app/styles`,
      type       : GeneratedFileTypes.CSS,
      data       : data

    },
    /*
            {
                template   : `${this.sourceAngularTemplateRoot}/app/magic/magic.core.module.ts`,
                name       : 'magic.core.module.ts',
                destination: `${appRoot}/src/app/magic`,
                type       : GeneratedFileTypes.TS,
                data       : data
            }
    */
    {
      template: `${this.sourceAngularTemplateRoot}/app/component-list.g.ts`,
      name: 'component-list.g.ts',
      destination: `${appRoot}/src/app`,
      type       : GeneratedFileTypes.TS,
      data       : data

    },
  ];



  return configs_array;
};

export const prettierConfig = {
  trailingComma : 'none',
  bracketSpacing: true,
  parser        : 'typescript',
  useTabs       : true,
  tabWidth      : 4
};
