// TODO(PK): hard-code for now, will query npm repo
// to get this info in the future
import { MagicMetadata } from "./metadata.class";
import { IEnv } from "../../types/interfaces/env.interface";

export const METADATA_DIR         = `magic-metadata`;
export const GEN_COMPONENTS_ARRAY = 'magicGenComponents';
export const GEN_COMPONENTS_HASH  = 'magicGenCmpsHash';
export const GEN_FOLDER           = 'magic';
export const MAGIC_CLI_FOLDER     = './node_modules/@magic-xpa/cli';
export const GEN_LAZY_LOAD_MODULES_ARRAY  = 'LazyLoadModulesMap';
export const manifest_path  = `./${METADATA_DIR}/manifest.json`;
export const config_path    = `./${METADATA_DIR}/config.json`;

export class Idependencies {
  constructor(setName:string, setVersion:string){
    this.name = setName;
    this.version = setVersion;
  }
  name:string;
  version:string;
}

export var dependencies = [

  // material dependencies
  {name: "@angular/material"  , version: '^14.0.0'},
  {name: "@angular/cdk"       , version: '^14.0.0'},
  {name: "@angular/animations", version: '^15.2.2'},
  {name: "font-awesome"       , version: '^4.7.0'},
  {name: "hammerjs"           , version: '^2.0.8'},

  {name: "ngx-infinite-scroll" , version: '^10.0.0'},
  {name: "ng-dynamic-component", version: '~10.1.0'},
  {name: "rxjs-compat"         , version: "^6.6.0"},
  {name: "ngx-currency"        , version: "^2.5.2"},
  {name: "ngx-mask"            , version: "^13.1.15"},

  // Time masking dependencies (hh:mm, hh:mm:ss, hh:mm:ss:mss)
  {name: "@maskito/angular"     , version: "^1.4.0"},
  {name: "@maskito/core"        , version: "^1.4.0"},
  {name: "@maskito/kit"         , version: "^1.4.0"}

];

export const devDependencies = [
  {name: "@types/stacktrace-js", version: '^0.0.32'}
];
export const env : IEnv = {} as any;

