"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
class Manifest {
    constructor(entries) {
        this.items = new Map();
        if (entries) {
            this.convertArrayToMap(entries);
        }
    }
    add(entry) {
        this.items.set(entry.jsonPath, entry);
    }
    get(jsonPath) {
        let compId = this.items.get(jsonPath);
        /*if(!compId){
          console.log(`manifest dosen't contain key: ${uniqueName}`);
        }*/
        return compId;
    }
    convertArrayToMap(entries) {
        this.items.clear();
        entries.forEach(entry => {
            this.items.set(entry.uniqueName, entry);
        });
    }
    convertMapToArray() {
        return [...this.items.values()];
    }
    toString() {
        return JSON.stringify([...this.items.values()]);
    }
    dump() {
        for (let [key, value] of this.items) {
            console.dir(value);
        }
    }
}
exports.Manifest = Manifest;
//export const manifest = new Manifest();
//# sourceMappingURL=manifest.js.map