import { ComponentId } from "../../types/interfaces/app";


export class Manifest {

  items = new Map<string,ComponentId>();

  constructor(entries : ComponentId[]){
    if(entries){
      this.convertArrayToMap(entries);
    }
  }

  add(entry: ComponentId) {
    this.items.set( entry.jsonPath , entry );
  }
  get(jsonPath:string){
    let compId:ComponentId =  this.items.get(jsonPath);
    /*if(!compId){
      console.log(`manifest dosen't contain key: ${uniqueName}`);
    }*/
    return compId;
  }

  convertArrayToMap(entries : ComponentId[]){
    this.items.clear();
    entries.forEach(entry=>{
      this.items.set(entry.uniqueName,entry);
    });
  }
  convertMapToArray() : any[] {
    return [ ...this.items.values() ];
  }

  toString(){
    return JSON.stringify([ ...this.items.values() ]);
  }
  dump(){
    for( let [key,value] of this.items){
      console.dir(value);
    }
  }

}

//export const manifest = new Manifest();
