import { SchematicContext, Tree } from "@angular-devkit/schematics";
import { AppConfig, RouteTable } from "../../types/interfaces/app";
import { MagicOptionScheme } from "./rules/magic-option.scheme";
import { Project } from "../utils/devkit-utils/config";
export declare class MagicPaths {
    protected project: Project;
    currentModulePath(module_name: string): string;
    getDestPathForComponent(module_name: string, componentPath: string): string;
    getJsonPathForComponent(cmpJsonPath: string): string;
    getRelativePathForComponentInModule(module_name: string, cmpJsonPath: string): string;
    getRoutePathForWebModule(module_name: string): string;
    get rootMagicGenFolder(): string;
    get appComponentPath(): string;
    get appRoutesPath(): string;
    get appModulePath(): string;
    get executionPath(): string;
    get magicStylePath(): string;
    get angularJsonPath(): string;
    get tsConfigAppJsonPath(): string;
    magicGenLibModulePath(moduleName: any): string;
    get magicGenFolderPath(): string;
    componentListPathForCurrentModuleName(module_name: string): string;
    componentListPath(module_name: string): string;
    get rootMagicComponentListPath(): string;
    get magicGenLibModule(): string;
    get favIconPath(): string;
    get metadataFolderPath(): string;
    get manifestPath(): string;
    get configPath(): string;
    get programListPath(): string;
    get routesPath(): string;
    constructor(project: Project);
}
export declare class MagicMetadata {
    host: Tree;
    context: SchematicContext;
    options: MagicOptionScheme;
    private _config;
    private _routesTable;
    private _programListContents;
    paths: MagicPaths;
    get theme(): string;
    get allow_testing(): boolean;
    get config(): AppConfig;
    get programListContents(): any;
    get routesTable(): RouteTable[];
    constructor(host: Tree, context: SchematicContext, options: MagicOptionScheme);
    loadConfig(): AppConfig;
    loadProgramList(): any;
    loadRoutes(): RouteTable[];
}
