"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MagicMetadata = exports.MagicPaths = void 0;
const env_1 = require("./env");
const utils_1 = require("./utils");
class MagicPaths {
    // return the current module path
    // for example : for module "WebModule1" it returns 'src/app/magic/WebModule1'
    currentModulePath(module_name) {
        if (module_name !== "") {
            return `${this.rootMagicGenFolder}/${env_1.GEN_FOLDER}/${module_name}`;
        }
        return `${this.rootMagicGenFolder}/${env_1.GEN_FOLDER}`;
    }
    // return the destanation path for create the component
    // for example : for module "WebModule1" component "WebModule1/folder1/bb/cc/it returns 'src/app/magic/WebModule1'
    getDestPathForComponent(module_name, componentPath) {
        return `${this.currentModulePath(module_name)}/${componentPath}`;
    }
    getJsonPathForComponent(cmpJsonPath) {
        return `${this.metadataFolderPath}/${cmpJsonPath}.json`;
    }
    getRelativePathForComponentInModule(module_name, cmpJsonPath) {
        let relativePathForComponentInModule = `${cmpJsonPath}`;
        if (module_name !== "")
            relativePathForComponentInModule = `${module_name}/${cmpJsonPath}`;
        return relativePathForComponentInModule;
    }
    getRoutePathForWebModule(module_name) {
        if (module_name == "")
            return this.appRoutesPath;
        return `${this.rootMagicGenFolder}/${env_1.GEN_FOLDER}/${module_name}/app.routes.ts`;
    }
    get rootMagicGenFolder() { return `./${this.project.root}/src/app`; }
    get appComponentPath() { return `./${this.project.root}/src/app/app.component.html`; }
    get appRoutesPath() { return `./${this.project.root}/src/app/app.routes.ts`; }
    get appModulePath() { return `./${this.project.root}/src/app/app.module.ts`; }
    get executionPath() { return `./${this.project.root}/src/assets/execution.properties`; }
    get magicStylePath() { return `./${this.project.root}/src/magic-styles.css`; }
    get angularJsonPath() { return `./angular.json`; }
    get tsConfigAppJsonPath() { return `./${this.project.root}/tsconfig.app.json`; }
    // get the relative path of module to be used in LazyLoadMap
    magicGenLibModulePath(moduleName) {
        let rootPath = this.project.root == '' ? this.project.root : this.project.root + '/';
        let modulepath = rootPath + `src/app/${env_1.GEN_FOLDER}`;
        if (moduleName !== "") {
            return `${modulepath}/${moduleName}/magic.gen.lib.module`;
        }
        return `${modulepath}/magic.gen.lib.module`;
    }
    // Files under gen folder
    get magicGenFolderPath() { return `./${this.project.root}/src/app/${env_1.GEN_FOLDER}`; }
    componentListPathForCurrentModuleName(module_name) {
        return `./${this.project.root}/src/app/${env_1.GEN_FOLDER}/${module_name}/component-list.g.ts`;
    }
    componentListPath(module_name) {
        if (module_name !== "") {
            return this.componentListPathForCurrentModuleName(module_name);
        }
        return this.rootMagicComponentListPath;
    }
    get rootMagicComponentListPath() {
        return `./${this.project.root}/src/app/${env_1.GEN_FOLDER}/component-list.g.ts`;
    }
    get magicGenLibModule() { return `./${this.project.root}/src/app/${env_1.GEN_FOLDER}/magic.gen.lib.module.ts`; }
    get favIconPath() { return `./${this.project.root}/src/favicon.ico`; }
    get metadataFolderPath() { return `./${this.project.root}/${env_1.METADATA_DIR}`; }
    get manifestPath() { return `./${this.project.root}/${env_1.METADATA_DIR}/manifest.json`; }
    get configPath() { return `./${this.project.root}/${env_1.METADATA_DIR}/config.json`; }
    get programListPath() { return `./${this.project.root}/${env_1.METADATA_DIR}/ProgramsList.json`; }
    get routesPath() { return `./${this.project.root}/${env_1.METADATA_DIR}/routes.json`; }
    constructor(project) {
        this.project = project;
    }
}
exports.MagicPaths = MagicPaths;
class MagicMetadata {
    get theme() {
        if (!this.options.theme) {
            this.options.theme = env_1.env.metadata.config ? env_1.env.metadata.config.theme : 'basicHTML';
        }
        return this.options.theme;
    }
    get allow_testing() {
        if (!this.options.allowTesting) {
            this.options.allowTesting = env_1.env.metadata.config ? env_1.env.metadata.config.allow_testing : false;
        }
        return this.options.allowTesting;
    }
    get config() {
        if (this._config)
            return this._config;
        return this.loadConfig();
    }
    get programListContents() {
        if (this._programListContents)
            return this._programListContents;
        return this.loadProgramList();
    }
    get routesTable() {
        if (this._routesTable)
            return this._routesTable;
        return this.loadRoutes();
    }
    constructor(host, context, options) {
        this.host = host;
        this.context = context;
        this.options = options;
        this.paths = new MagicPaths((0, utils_1.getProject)(host, options.project));
    }
    loadConfig() {
        this._config = (0, utils_1.readJson)(this.host, this.paths.configPath);
        return this._config;
    }
    loadProgramList() {
        this._programListContents = (0, utils_1.readJson)(this.host, this.paths.programListPath);
        return this._programListContents;
    }
    loadRoutes() {
        this._routesTable = (0, utils_1.readJson)(this.host, this.paths.routesPath);
        return this._routesTable;
    }
}
exports.MagicMetadata = MagicMetadata;
//# sourceMappingURL=metadata.class.js.map