import { SchematicContext, Tree } from "@angular-devkit/schematics";
import { AppConfig, ComponentId, Route, RouteTable } from "../../types/interfaces/app";
import { MagicOptionScheme } from "./rules/magic-option.scheme";
import { Project } from "../utils/devkit-utils/config";
import { env, GEN_FOLDER, METADATA_DIR } from "./env";
import { Manifest } from "./manifest";
import { getProject, readJson } from "./utils";


export class MagicPaths {

  // return the current module path
  // for example : for module "WebModule1" it returns 'src/app/magic/WebModule1'
 currentModulePath(module_name:string) {
    if (module_name !== "") {
      return `${this.rootMagicGenFolder}/${GEN_FOLDER}/${module_name}`;
    }

    return `${this.rootMagicGenFolder}/${GEN_FOLDER}`;


  }

  // return the destanation path for create the component
  // for example : for module "WebModule1" component "WebModule1/folder1/bb/cc/it returns 'src/app/magic/WebModule1'
  getDestPathForComponent(module_name:string, componentPath:string) {
      return `${this.currentModulePath(module_name)}/${componentPath}`;
  }

  getJsonPathForComponent(cmpJsonPath:string) {
    return `${this.metadataFolderPath}/${cmpJsonPath}.json`;
  }

  getRelativePathForComponentInModule(module_name:string, cmpJsonPath:string) {
    let relativePathForComponentInModule = `${cmpJsonPath}`;
    if (module_name !== "")
      relativePathForComponentInModule = `${module_name}/${cmpJsonPath}`;

    return relativePathForComponentInModule;
  }

  getRoutePathForWebModule(module_name:string) {

    if (module_name == "")
      return this.appRoutesPath;

    return `${this.rootMagicGenFolder}/${GEN_FOLDER}/${module_name}/app.routes.ts`;
  }
  get rootMagicGenFolder(){ return `./${this.project.root}/src/app`; }
  get appComponentPath(){   return `./${this.project.root}/src/app/app.component.html`}
  get appRoutesPath(){      return `./${this.project.root}/src/app/app.routes.ts`}
  get appModulePath(){      return `./${this.project.root}/src/app/app.module.ts`}
  get executionPath(){      return `./${this.project.root}/src/assets/execution.properties`}
  get magicStylePath(){     return `./${this.project.root}/src/magic-styles.css`}
  get angularJsonPath(){    return `./angular.json`}
  get tsConfigAppJsonPath(){      return `./${this.project.root}/tsconfig.app.json`}

  // get the relative path of module to be used in LazyLoadMap
  magicGenLibModulePath (moduleName){

   let rootPath = this.project.root == '' ? this.project.root: this.project.root + '/';
    let modulepath = rootPath+`src/app/${GEN_FOLDER}`;
    if (moduleName !== "") {
      return `${modulepath}/${moduleName}/magic.gen.lib.module`;
    }
    return `${modulepath}/magic.gen.lib.module`;
  }

  // Files under gen folder
  get magicGenFolderPath (){ return `./${this.project.root}/src/app/${GEN_FOLDER}`}

  componentListPathForCurrentModuleName (module_name:string):string{
    return `./${this.project.root}/src/app/${GEN_FOLDER}/${module_name}/component-list.g.ts`
  }
  componentListPath (module_name:string):string{

    if (module_name !== ""){
      return this.componentListPathForCurrentModuleName(module_name);
    }
      return this.rootMagicComponentListPath;
  }

  get rootMagicComponentListPath (){

    return `./${this.project.root}/src/app/${GEN_FOLDER}/component-list.g.ts`
  }

  get magicGenLibModule (){ return `./${this.project.root}/src/app/${GEN_FOLDER}/magic.gen.lib.module.ts`}

  get favIconPath(){ return `./${this.project.root}/src/favicon.ico`; }

  get metadataFolderPath(){ return `./${this.project.root}/${METADATA_DIR}`; }
  get manifestPath      (){ return `./${this.project.root}/${METADATA_DIR}/manifest.json`; }
  get configPath        (){ return `./${this.project.root}/${METADATA_DIR}/config.json`; }
  get programListPath   (){return `./${this.project.root}/${METADATA_DIR}/ProgramsList.json`; }
  get routesPath        (){ return `./${this.project.root}/${METADATA_DIR}/routes.json`; }

  constructor(protected project:Project){
  }
}


export class MagicMetadata {

  private _config:  AppConfig;
  private _routesTable:  RouteTable[];
  private _programListContents: any;

  paths: MagicPaths;

  get theme() {
    if (!this.options.theme) {
      this.options.theme = env.metadata.config ?env.metadata.config.theme  : 'basicHTML';
    }
    return this.options.theme;
  }

  get allow_testing() {
    if (!this.options.allowTesting) {
      this.options.allowTesting = env.metadata.config ?env.metadata.config.allow_testing: false;
    }
    return this.options.allowTesting;
  }
  get config() {
    if (this._config) return this._config;
    return this.loadConfig();
  }

  get programListContents(){
      if(this._programListContents) return this._programListContents;
      return this.loadProgramList();
  }

  get routesTable(){
    if (this._routesTable) return this._routesTable;
    return this.loadRoutes();
  }

  constructor(public host: Tree, public context: SchematicContext, public options: MagicOptionScheme) {
    this.paths = new MagicPaths(getProject(host, options.project));
  }

  loadConfig() {
    this._config = readJson(this.host, this.paths.configPath);
    return this._config;
  }

  loadProgramList(){
      this._programListContents = readJson(this.host, this.paths.programListPath);
      return this._programListContents;
  }

  loadRoutes() {
    this._routesTable = readJson(this.host, this.paths.routesPath);
    return this._routesTable;
  }
}


