"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processJson = void 0;
const Util_1 = require("./Util");
const util_1 = require("util");
const Enums_1 = require("../../../src/types/enums/Enums");
// mapping for properties which are implemented using a class
const Map = {
    style: [
        {
            name: 'font',
            suffix: 'mgFont'
        },
        {
            name: 'focus_color',
            suffix: 'mgFocusColor'
        },
        {
            name: 'border_color',
            suffix: 'mgBorderColor'
        },
        {
            name: 'border',
            options: {
                "false": 'hidden_border'
            }
        },
        {
            name: 'border_style',
            options: {
                "1": 'twod_border',
                "2": 'threed_border',
                "3": 'threedsunken_border',
                "4": 'windows_border',
                "5": 'windows_border',
                "6": 'emboss_border',
                "7": 'hidden_border'
            }
        },
        {
            name: 'multiline_edit',
            options: {
                "true": 'multiline',
            }
        }
    ],
    props: [],
    hint: []
};
//////////////////////////////////////////////////////////////////
// process the views' json, find the classes used for each control
//////////////////////////////////////////////////////////////////
function processJson(appJson) {
    const views$ = Object.assign([], appJson.views);
    appJson.views.length = 0;
    // loop on all views
    views$.forEach(view$ => {
        if (view$) {
            (0, Util_1.LogLn)(`[>] Processing JSON file for component ${view$.props.id}`);
            processControl(view$);
            appJson.views.push(view$);
        }
    });
    return appJson;
}
exports.processJson = processJson;
function CalcClassForControl(control, controlClasses) {
    if (control.controlType != Enums_1.MgControlType.CTRL_TYPE_TABPAGE) {
        if (control.controlType === Enums_1.MgControlType.CTRL_TYPE_BUTTON && control.props.button_style === Enums_1.CtrlButtonTypeGui.Image) {
            controlClasses.push("button_image_background_size");
        }
        if (control.controlType === Enums_1.MgControlType.CTRL_TYPE_LABEL) {
            controlClasses.push("lable_overflow");
        }
        if (control.controlType === Enums_1.MgControlType.CTRL_TYPE_COLUMN) {
            controlClasses.push("table_row");
        }
        if (control.controlType === Enums_1.MgControlType.CTRL_TYPE_TABLE) {
            if (control.props.scroll_bar) {
                controlClasses.push("table_scrollBar");
            }
        }
        if (control.controlType === Enums_1.MgControlType.CTRL_TYPE_TABLE || control.controlType === Enums_1.MgControlType.CTRL_TYPE_GROUP) {
            controlClasses.push("container_border");
        }
        // if (control.children) {
        //   control.children.forEach((ctrl$: Control) => {
        //     CalcClassForControl(ctrl$, controlClasses)
        //   });
        // }
    }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// for each special chars we will add "\" before the special char.
// For example : control name "Blabla?" the class name will be "Blabla\?"
///////////////////////////////////////////////////////////////////////////////////////////////////
function getControlClassNameInCss(controlNameStr) {
    var controlName = controlNameStr;
    //The following chars are created problem in css = ["!" "," "+", ":", ",", "~", ";", "\"" "{" "}" ">" " "];
    //TODO:need to be check with Rotem let specialCharsForRotem = ["!"];
    // replace all special chars
    let specialCharsWork = ["\\", "#", "$", "%", "&", "(", ")", "*", "-", ".", "/", "<", "=", "?", "@", "[", "]", "^", "`", "|"];
    for (let i = 0; i < specialCharsWork.length; i++) {
        controlName = controlName.split(specialCharsWork[i]).join("\\" + specialCharsWork[i]);
    }
    return controlName;
}
//////////////////////////////////////////////////////////////////
// recursively process the controls' properties, find the classes used for the control
//////////////////////////////////////////////////////////////////
function processControl(control) {
    const categoryNames = Object.keys(Map);
    //LogLn(">> Generating CSS class list for \"" + control.props.id + "\"");
    const controlClasses = [];
    // use the control's id as a class
    //control["class_name_in_css"] = getControlClassNameInCss(control.props.id);
    //controlClasses.push(control.props.id + "Props");
    CalcClassForControl(control, controlClasses);
    // loop on all item names from the "Map" object
    categoryNames.forEach((catName) => {
        let catRuleArray = Map[catName];
        catRuleArray.forEach((rule, i) => {
            let ruleSet$;
            if (control[catName]) {
                ruleSet$ = control[catName][rule.name];
            }
            else {
                return;
            }
            if ((0, util_1.isNullOrUndefined)(ruleSet$))
                return;
            // ... or turn on the has-expession flag
            if (!(0, util_1.isNullOrUndefined)(ruleSet$.has_exp) && ruleSet$.has_exp) {
                control.hasClassExpression = true;
            }
            // find and keep the class name...
            else {
                if (Map[catName] && Map[catName][i] && Map[catName][i] && Map[catName][i]['options']) {
                    if (!(0, util_1.isNullOrUndefined)(Map[catName][i]['options'][String(ruleSet$)]))
                        controlClasses.push(Map[catName][i]['options'][String(ruleSet$)]);
                }
                else {
                    controlClasses.push(Map[catName] && Map[catName][i] && Map[catName][i] && Map[catName][i]['suffix'] + ruleSet$);
                }
            }
        });
        control.classes = controlClasses.join(' ');
    });
    //LogLn("generated classes \"" + control.classes + "\"");
    // go over control's children
    if (control.children) {
        //LogLn("processing child controls...");
        control.children.forEach((ctrl$) => {
            processControl(ctrl$);
        });
        //LogLn("...children processing done")
    }
}
//# sourceMappingURL=process-json.js.map