import {AppJson, View,Control}  from '../../types/index';
import {LogLn,}                  from "./Util";
import { isNullOrUndefined } from "util";
import { MgControlType, CtrlButtonTypeGui } from "../../../src/types/enums/Enums";

// mapping for properties which are implemented using a class
const Map: { [category: string]: { name: string, suffix?: string, options?: { [val: string]: string } }[] } = {
    style: [
        {
            name: 'font',
            suffix: 'mgFont'
        },
        {
            name: 'focus_color',
            suffix: 'mgFocusColor'
        },

        {
            name: 'border_color',
            suffix: 'mgBorderColor'
        },
        {
            name: 'border',
            options: {
                "false": 'hidden_border'
            }
        },
        {
            name: 'border_style',
            options: {
                "1": 'twod_border',
                "2": 'threed_border',
                "3": 'threedsunken_border',
                "4": 'windows_border',
                "5": 'windows_border',
                "6": 'emboss_border',
                "7": 'hidden_border'
            }
        },
        {
            name: 'multiline_edit',
            options: {
                "true": 'multiline',

            }
        }
    ],
    props: [],
    hint: []
};

//////////////////////////////////////////////////////////////////
// process the views' json, find the classes used for each control
//////////////////////////////////////////////////////////////////
export function processJson(appJson: AppJson) :AppJson {

    const views$: View[] = Object.assign([], appJson.views);
    appJson.views.length = 0;

    // loop on all views
    views$.forEach( view$ => {
      if(view$){
        LogLn(`[>] Processing JSON file for component ${view$.props.id}`);
        processControl(view$);
        appJson.views.push(view$);
      }
    });
    return appJson;
}

function CalcClassForControl(control: Control, controlClasses: string[] ){
  if (control.controlType != MgControlType.CTRL_TYPE_TABPAGE){

    if (control.controlType === MgControlType.CTRL_TYPE_BUTTON && control.props.button_style === CtrlButtonTypeGui.Image) {
      controlClasses.push("button_image_background_size");
    }

    if (control.controlType === MgControlType.CTRL_TYPE_LABEL) {
      controlClasses.push("lable_overflow");
    }


    if (control.controlType === MgControlType.CTRL_TYPE_COLUMN ) {
      controlClasses.push("table_row");
    }

    if (control.controlType === MgControlType.CTRL_TYPE_TABLE){

      if (control.props.scroll_bar) {
        controlClasses.push("table_scrollBar");
      }
    }

    if(control.controlType === MgControlType.CTRL_TYPE_TABLE || control.controlType === MgControlType.CTRL_TYPE_GROUP) {
      controlClasses.push("container_border");
    }

    // if (control.children) {
    //   control.children.forEach((ctrl$: Control) => {
    //     CalcClassForControl(ctrl$, controlClasses)
    //   });
    // }
  }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// for each special chars we will add "\" before the special char.
// For example : control name "Blabla?" the class name will be "Blabla\?"
///////////////////////////////////////////////////////////////////////////////////////////////////
function getControlClassNameInCss(controlNameStr: string): string {
    var controlName = controlNameStr;

    //The following chars are created problem in css = ["!" "," "+", ":", ",", "~", ";", "\"" "{" "}" ">" " "];
    //TODO:need to be check with Rotem let specialCharsForRotem = ["!"];

    // replace all special chars
    let specialCharsWork = ["\\", "#", "$", "%", "&", "(", ")", "*", "-", ".", "/", "<", "=", "?", "@", "[", "]", "^", "`", "|"];
    for (let i = 0; i < specialCharsWork.length; i++) {
        controlName = controlName.split(specialCharsWork[i]).join("\\" + specialCharsWork[i]);
    }

    return controlName;
}

//////////////////////////////////////////////////////////////////
// recursively process the controls' properties, find the classes used for the control
//////////////////////////////////////////////////////////////////
function processControl(control: Control) {

    const categoryNames: string[] = Object.keys(Map);

    //LogLn(">> Generating CSS class list for \"" + control.props.id + "\"");

    const controlClasses: string[] = [];

    // use the control's id as a class
    //control["class_name_in_css"] = getControlClassNameInCss(control.props.id);
    //controlClasses.push(control.props.id + "Props");
    CalcClassForControl(control, controlClasses);

    // loop on all item names from the "Map" object
    categoryNames.forEach((catName) => {
        let catRuleArray: { name: string, suffix?: string, options?: { [val: string]: string } }[] = Map[catName];

        catRuleArray.forEach((rule, i) => {

            let ruleSet$;
            if (control[catName]) {
                ruleSet$ = control[catName][rule.name];
            }
            else {
                return;
            }
            if (isNullOrUndefined(ruleSet$)) return;

            // ... or turn on the has-expession flag
            if (!isNullOrUndefined(ruleSet$.has_exp) && ruleSet$.has_exp) {
                control.hasClassExpression = true;
            }
            // find and keep the class name...
            else {
                if (Map[catName] && Map[catName][i] && Map[catName][i] && Map[catName][i]['options']) {
                    if (!isNullOrUndefined(Map[catName][i]['options'][String(ruleSet$)]))
                        controlClasses.push(Map[catName][i]['options'][String(ruleSet$)]);
                }
                else {
                    controlClasses.push(Map[catName] && Map[catName][i] && Map[catName][i] && Map[catName][i]['suffix'] + ruleSet$);
                }
            }

        });

        control.classes = controlClasses.join(' ');
    });

    //LogLn("generated classes \"" + control.classes + "\"");

    // go over control's children
    if (control.children) {
        //LogLn("processing child controls...");
        control.children.forEach((ctrl$: Control) => {
            processControl(ctrl$)
        });
        //LogLn("...children processing done")
    }

}
