"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = exports.buildControl = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const index_1 = require("../../../types/index");
const Util_1 = require("../Util");
const env_1 = require("../env");
const EJS = require("ejs");
const Util_2 = require("../Util");
const jsbeautify = require("js-beautify");
const generate_rule_1 = require("./generate.rule");
const htmlBeautify = jsbeautify.html;
//
// build the HTML of a single control
//
function buildControl(options, module_name) {
    return (host, context) => {
        const metadata = env_1.env.metadata;
        const view = env_1.env.app.views[0];
        let rules = [];
        const viewId = view.props.id;
        const dest = metadata.paths.getDestPathForComponent(module_name, view.props.component_path);
        const data = {
            MgControlType: index_1.MgControlType,
            theme: metadata.theme,
            CtrlButtonTypeGui: index_1.CtrlButtonTypeGui,
            SideType: index_1.SideType,
            StorageAttributeType: index_1.StorageAttributeType,
            TableWebStyle: index_1.TableWebStyle,
            RowEditingTypes: index_1.RowEditingTypes,
            WindowType: index_1.WindowType,
            WindowPosition: index_1.WindowPosition,
            Util: Util_1.Util,
            child: view,
            ctrl: view,
            app: env_1.env.app,
            magicConfig: metadata.config,
        };
        const componentFiles = [
            {
                type: index_1.GeneratedFileTypes.HTML,
                template: './templates/themes/control.ejs',
                destination: dest,
                name: `${viewId}.component.html`,
                data: data
            },
        ];
        componentFiles.forEach(templateConfig => {
            rules.push(generate(templateConfig, options));
        });
        return (0, schematics_1.chain)(rules)(host, context);
    };
}
exports.buildControl = buildControl;
//
// Call EJS to generate HTML and write the result to stdout
//
function generate(file, options) {
    return (host, context) => {
        EJS.renderFile(`${env_1.MAGIC_CLI_FOLDER}/${file.template}`, file.data, {}, (err, output) => {
            try {
                output = (0, generate_rule_1.createGenFuncs)(output, file.type);
            }
            catch (err) {
                (0, Util_2.logErr)(output);
                (0, Util_2.logErr)(err);
            }
            // send the output directly to the stdout, so the calling app will get it
            console.log(output);
        });
        return host;
    };
}
exports.generate = generate;
//# sourceMappingURL=build-control.rule.js.map