import { MagicOptionScheme } from "./magic-option.scheme";
import { chain, Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import {
  CtrlButtonTypeGui,
  GeneratedFileTypes,
  MgControlType,
  SideType,
  StorageAttributeType,
  TableWebStyle,
  RowEditingTypes,
  TemplateConfig,
  WindowPosition,
  WindowType
} from "../../../types/index";
import { Util } from "../Util";
import { env, GEN_FOLDER, MAGIC_CLI_FOLDER } from "../env";
import * as EJS from 'ejs';
import { logErr, Log } from "../Util";
import * as jsbeautify from 'js-beautify';
import { createGenFuncs } from "./generate.rule";

const htmlBeautify = jsbeautify.html;

//
// build the HTML of a single control
//
export function buildControl(options:MagicOptionScheme, module_name:string) : Rule {
  return (host:Tree, context: SchematicContext)=>{
    const metadata = env.metadata;
    const view    = env.app.views[0];
    let rules:Rule[] = [];

      const viewId   = view.props.id;
      const dest     = metadata.paths.getDestPathForComponent(module_name, view.props.component_path);
      const data     = {
        MgControlType     : MgControlType,
        theme             : metadata.theme,
        CtrlButtonTypeGui : CtrlButtonTypeGui,
        SideType          : SideType,
        StorageAttributeType: StorageAttributeType,
        TableWebStyle     : TableWebStyle,
        RowEditingTypes   : RowEditingTypes,
        WindowType        : WindowType,
        WindowPosition    : WindowPosition,
        Util              : Util,
        child             : view,
        ctrl              : view,
        app               : env.app,
        magicConfig       : metadata.config,
      };
      const componentFiles: TemplateConfig[] = [
        {
          type: GeneratedFileTypes.HTML,
          template: './templates/themes/control.ejs',
          destination: dest,
          name: `${viewId}.component.html`,
          data: data
        },
      ];
      componentFiles.forEach( templateConfig => {
        rules.push(generate(templateConfig, options));
      });

    return chain(rules)(host,context);
  }
}

//
// Call EJS to generate HTML and write the result to stdout
//
export function generate(file: TemplateConfig,options:MagicOptionScheme) :Rule{
  return (host:Tree, context: SchematicContext) => {
    EJS.renderFile(
      `${MAGIC_CLI_FOLDER}/${file.template}`,
      file.data,
      {},
      (err, output) => {
        try {
          output = createGenFuncs(output, file.type);
        }
        catch (err) {
          logErr(output);
          logErr(err);
        }
        // send the output directly to the stdout, so the calling app will get it
        console.log(output);
      });
    return host;
  }
}
