"use strict";
//import * as _ from "lodash";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildViews = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const index_1 = require("../../../types/index");
const Util_1 = require("../Util");
const generate_rule_1 = require("./generate.rule");
const env_1 = require("../env");
function buildViews(options, module_name) {
    return (host, context) => {
        const metadata = env_1.env.metadata;
        const views = env_1.env.app.views;
        let rules = [];
        //console.log(`Number of components to generate: ${views.length}`);
        (0, Util_1.LogLn)(`*** Step 3: generate components. (${views.length} components) ***`);
        views.forEach(view => {
            const viewId = view.props.id;
            const dest = metadata.paths.getDestPathForComponent(module_name, view.props.component_path);
            (0, Util_1.LogLn)(`[>] generate component ${viewId}`);
            const data = {
                MgControlType: index_1.MgControlType,
                theme: metadata.theme,
                CtrlButtonTypeGui: index_1.CtrlButtonTypeGui,
                SideType: index_1.SideType,
                StorageAttributeType: index_1.StorageAttributeType,
                TableWebStyle: index_1.TableWebStyle,
                RowEditingTypes: index_1.RowEditingTypes,
                WindowType: index_1.WindowType,
                WindowPosition: index_1.WindowPosition,
                Util: Util_1.Util,
                ctrl: view,
                app: env_1.env.app,
                //_                 : _,
                magicConfig: metadata.config,
            };
            const componentFiles = [
                {
                    type: index_1.GeneratedFileTypes.HELPER,
                    template: './templates/component/mg.accessor.ts',
                    destination: dest,
                    name: `${viewId}.mg.controls.g.ts`,
                    data: data
                },
                {
                    type: index_1.GeneratedFileTypes.TS,
                    template: './templates/component/view.component.ts',
                    destination: dest,
                    name: `${viewId}.component.ts`,
                    data: data
                },
                {
                    type: index_1.GeneratedFileTypes.HTML,
                    template: './templates/component/view.component.html',
                    destination: dest,
                    name: `${viewId}.component.html`,
                    data: data
                },
            ];
            componentFiles.forEach(templateConfig => {
                if (shouldGenerateFileType(templateConfig))
                    rules.push((0, generate_rule_1.generate)(templateConfig, options));
            });
        });
        //console.log(`Number of generate rules: ${rules.length}`);
        return (0, schematics_1.chain)(rules)(host, context);
    };
    // check if the specified template should be used in generation, enables blocking
    // generation according to specified flags
    function shouldGenerateFileType(templateConfig) {
        if (env_1.env.metadata.config.no_controls_accessor && templateConfig.type === index_1.GeneratedFileTypes.HELPER)
            return false;
        if (!env_1.env.metadata.config.controls_accessor_only)
            return true;
        if (templateConfig.type === index_1.GeneratedFileTypes.HELPER)
            return true;
        return false;
    }
}
exports.buildViews = buildViews;
//# sourceMappingURL=build-view.rule.js.map