//import * as _ from "lodash";

import { MagicOptionScheme } from "./magic-option.scheme";
import { chain, Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import {
  CtrlButtonTypeGui,
  GeneratedFileTypes,
  MgControlType,
  SideType,
  StorageAttributeType,
  TableWebStyle,
  RowEditingTypes,
  TemplateConfig,
  WindowPosition,
  WindowType
} from "../../../types/index";
import { LogLn, Util } from "../Util";
import { generate } from "./generate.rule";
import { env, GEN_FOLDER } from "../env";

export function buildViews(options:MagicOptionScheme, module_name:string) : Rule {
  return (host:Tree, context: SchematicContext)=>{
    const metadata = env.metadata;
    const views    = env.app.views;
    let rules:Rule[] = [];

    //console.log(`Number of components to generate: ${views.length}`);

    LogLn(`*** Step 3: generate components. (${views.length} components) ***`);
    views.forEach( view => {
      const viewId   = view.props.id;
      const dest     = metadata.paths.getDestPathForComponent(module_name, view.props.component_path);

      LogLn(`[>] generate component ${viewId}`);

      const data     = {
        MgControlType     : MgControlType,
        theme             : metadata.theme,
        CtrlButtonTypeGui : CtrlButtonTypeGui,
        SideType          : SideType,
        StorageAttributeType: StorageAttributeType,
        TableWebStyle     : TableWebStyle,
        RowEditingTypes   : RowEditingTypes,
        WindowType        : WindowType,
        WindowPosition    : WindowPosition,
        Util              : Util,
        ctrl              : view,
        app               : env.app,
        //_                 : _,
        magicConfig       : metadata.config,
      };
      const componentFiles: TemplateConfig[] = [
        {
          type: GeneratedFileTypes.HELPER,
          template: './templates/component/mg.accessor.ts',
          destination: dest,
          name: `${viewId}.mg.controls.g.ts`,
          data: data
        },
        {
          type: GeneratedFileTypes.TS,
          template: './templates/component/view.component.ts',
          destination: dest,
          name: `${viewId}.component.ts`,
          data: data
        },
        {
          type: GeneratedFileTypes.HTML,
          template: './templates/component/view.component.html',
          destination: dest,
          name: `${viewId}.component.html`,
          data: data
        },
      ];
      componentFiles.forEach( templateConfig => {
        if(shouldGenerateFileType(templateConfig))
          rules.push(generate(templateConfig,options));
      });
    });

    //console.log(`Number of generate rules: ${rules.length}`);

    return chain(rules)(host,context);
  }

  // check if the specified template should be used in generation, enables blocking
  // generation according to specified flags
  function shouldGenerateFileType(templateConfig): boolean{
    if(env.metadata.config.no_controls_accessor && templateConfig.type === GeneratedFileTypes.HELPER)
      return false;

    if(!env.metadata.config.controls_accessor_only)
      return true;

    if(templateConfig.type === GeneratedFileTypes.HELPER)
      return true;

    return false;
  }
}

