"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.componentlistGen = void 0;
const ts = require("typescript");
const EJS = require("ejs");
const schematics_1 = require("@angular-devkit/schematics");
const env_1 = require("../env");
const types_1 = require("../../../types");
const generate_rule_1 = require("./generate.rule");
const ast_1 = require("../../utils/ast");
const route_utils_1 = require("../../utils/devkit-utils/route-utils");
const ast_utils_1 = require("../../utils/devkit-utils/ast-utils");
const Util_1 = require("../Util");
const util_1 = require("util");
let existCmpListSet;
let newCmpListSet = new Set();
let toAddImports = true;
let orgPreventLog = env_1.env.prevent_log;
function componentlistGen(options, module_name, loadOnDemand) {
    return (host, context) => {
        (0, Util_1.LogLn)(`[>] Step 4: components-list.`);
        return (0, schematics_1.chain)([
            addNewCmpsToCmpListOrGenAll(options, module_name),
            addCmpsImportsToCmpList(options, module_name),
            createLazyModuleMap(options, module_name),
            addLazyLoadComponentList(options, module_name, loadOnDemand),
            addLazyModuleToMagicGen(options),
            addImportForLazyModule(options)
        ])(host, context);
    };
}
exports.componentlistGen = componentlistGen;
// create the lazy load map if it does not exist
function createLazyModuleMap(options, module_name) {
    return (host, context) => {
        const cmpListPath = env_1.env.metadata.paths.componentListPath("");
        env_1.env.prevent_log = false;
        const source = host.read(cmpListPath).toString("utf-8");
        const LazyModuleArrayStart = 'export const ' + env_1.GEN_LAZY_LOAD_MODULES_ARRAY + ' = {';
        const LazyMOduleArrayEnd = '};';
        // create lazy load component array if it does not exist
        if (source.indexOf(LazyModuleArrayStart) < 0) {
            (0, Util_1.LogLn)(`[>] Creating LazyLoadModulesMap `);
            // add the code of creating map in file
            host.overwrite(cmpListPath, source + "\r\n" + LazyModuleArrayStart + LazyMOduleArrayEnd);
        }
    };
}
// add the lazy load components
function addLazyLoadComponentList(options, module_name, loadOnDemand) {
    return (host, context) => {
        if (loadOnDemand) {
            let lazyLoadedComponents = new Array();
            const cmpListPath = env_1.env.metadata.paths.componentListPath("");
            const source = host.read(cmpListPath);
            if (source) {
                let cmpListSource = (0, ast_1.getSourceFile)(host, cmpListPath);
                let cmpListTs = getLazyLoadCompoenentsInfo(cmpListSource, env_1.GEN_LAZY_LOAD_MODULES_ARRAY);
                let sourceStep1 = host.read(cmpListPath).toString("utf-8");
                env_1.env.app.views.forEach(view => {
                    if ((0, util_1.isNullOrUndefined)(cmpListTs.components) || !(cmpListTs.components.includes(view.props.component_uniquename))) {
                        lazyLoadedComponents.push(view); // if component does not exist add it to list
                        (0, Util_1.LogLn)(`[>] Add  ${view.props.component_uniquename} component to LazyLoadModulesMap`);
                    }
                });
                // add components to map
                if (lazyLoadedComponents.length > 0) {
                    let sourceStep2 = addComponentsToLazyLoad(sourceStep1, cmpListTs, lazyLoadedComponents, module_name);
                    host.overwrite(cmpListPath, sourceStep2);
                }
            }
            env_1.env.prevent_log = orgPreventLog;
        }
        return host;
    };
}
function addImportForLazyModule(options) {
    return (tree, context) => {
        let genLibPath = env_1.env.metadata.paths.rootMagicGenFolder + '/magic/magic.gen.lib.module.ts';
        const recorder = tree.beginUpdate(genLibPath);
        let genLibSource = (0, ast_1.getSourceFile)(tree, genLibPath);
        const importChange = (0, route_utils_1.insertImport)(genLibSource, genLibPath, env_1.GEN_LAZY_LOAD_MODULES_ARRAY, './component-list.g');
        if (importChange.toAdd) {
            recorder.insertLeft(importChange.pos, importChange.toAdd);
        }
        tree.commitUpdate(recorder);
    };
}
// add the lazy load module to magic.gen.lib
function addLazyModuleToMagicGen(options) {
    return (tree, context) => {
        let origModuleFileName = env_1.env.metadata.paths.rootMagicGenFolder + '/magic/magic.gen.lib.module.ts';
        if (!tree.exists(origModuleFileName)) {
            (0, Util_1.LogLn)(`      [>Error] File cannot be overwrite, The file is not exist  !!! : ${origModuleFileName}`);
        }
        const text = tree.read(origModuleFileName);
        if (text === null) {
            throw new schematics_1.SchematicsException(`File ${origModuleFileName} does not exist.`);
        }
        let sourceText = text.toString('utf-8');
        const lazyModuleStatement = '\r\n    componentList.lazyLoadModulesMap = ' + env_1.GEN_LAZY_LOAD_MODULES_ARRAY + ';';
        if (sourceText !== "" && sourceText.indexOf(lazyModuleStatement) == -1) {
            let genLibSource = (0, ast_1.getSourceFile)(tree, origModuleFileName);
            let newLazyModuleText = sourceText.replace(lazyModuleStatement, '').trim();
            const constNode = (0, ast_utils_1.findNodes)(genLibSource, ts.SyntaxKind.Constructor)[0];
            let lastStatementEnd = constNode.body.statements.end;
            const prefix = sourceText.substring(0, lastStatementEnd);
            const suffix = sourceText.substring(lastStatementEnd);
            tree.overwrite(origModuleFileName, `${prefix} ${lazyModuleStatement} ${suffix}`);
        }
        return tree;
    };
}
/*
* Add new component to component-list.g file (Array and Hash).
* If the file not exist new file will create by componentListGenIfNotExist function.
* */
function addNewCmpsToCmpListOrGenAll(options, module_name) {
    return (host, context) => {
        const metadata = env_1.env.metadata;
        const cmpsToGen = env_1.env.app.views;
        const cmpListPath = env_1.env.metadata.paths.componentListPath(module_name);
        const source = host.read(cmpListPath);
        if (source) {
            let cmpToGenNum = 0;
            let sourceStep1 = source.toString("utf-8");
            let cmpListSource = (0, ast_1.getSourceFile)(host, cmpListPath);
            let cmpListTs = getComponentsArrayInfo(cmpListSource, env_1.GEN_COMPONENTS_ARRAY);
            existCmpListSet = new Set(cmpListTs.components);
            newCmpListSet = new Set();
            // merge between components in the file and new component to gen
            cmpsToGen.forEach(newCmpGen => {
                if (!existCmpListSet.has(newCmpGen.props.component_uniquename)) {
                    newCmpListSet.add(newCmpGen.props.component_uniquename);
                }
            });
            const newCmpListArray = Array.from(newCmpListSet);
            if (newCmpListArray && newCmpListArray.length > 0) {
                let sourceStep2 = addComponentsToArray(sourceStep1, cmpListTs, newCmpListArray);
                let cmpListHashTs = getComponentsHashInfo(cmpListSource, env_1.GEN_COMPONENTS_HASH);
                let sourceStep3 = addComponentsToHash(sourceStep2, cmpListHashTs, newCmpListArray);
                (0, Util_1.LogLn)(` Total old components: ${existCmpListSet.size}, added components: ${newCmpListSet.size}. `);
                host.overwrite(cmpListPath, sourceStep3);
            }
        }
        else {
            // If component-list.g.ts doesn't exist.
            toAddImports = false; // We generate the entire file with imports.
            return componentListGenIfNotExist(options)(host, context);
        }
        return host;
    };
}
/*
* Create new component-list.g file.
* */
function componentListGenIfNotExist(options) {
    return (host, context) => {
        console.log("creating component-list");
        const metadata = env_1.env.metadata;
        const cmpList = new Set();
        const data = {
            app: env_1.env.app,
            cmpList: env_1.env.app.views
        };
        const componentFile = {
            template: `./templates/angular/src/app/component-list.g.ts`,
            name: 'component-list.g.ts',
            destination: metadata.paths.magicGenFolderPath,
            type: types_1.GeneratedFileTypes.TS,
            data: data
        };
        return (0, schematics_1.chain)([
            (0, generate_rule_1.generate)(componentFile, options)
        ])(host, context);
    };
}
/*
* Add new imports to component-list.g file.
* */
function addCmpsImportsToCmpList(options, module_name) {
    return (host, context) => {
        if (toAddImports) {
            const cmpsToGen = env_1.env.app.views;
            let cmpListSource = (0, ast_1.getSourceFile)(host, env_1.env.metadata.paths.componentListPath(module_name));
            const recorder = host.beginUpdate(env_1.env.metadata.paths.componentListPath(module_name));
            cmpsToGen.forEach(cmp => {
                let name = cmp.props.id;
                let uniqueName = cmp.props.component_uniquename;
                let cmpPath = cmp.props.component_path;
                if (newCmpListSet.has(uniqueName)) {
                    const importsChange = (0, route_utils_1.insertImport2)(cmpListSource, env_1.env.metadata.paths.componentListPath(module_name), name, uniqueName, `./${cmpPath}${name}.component`);
                    if (importsChange.toAdd) {
                        recorder.insertLeft(importsChange.pos, importsChange.toAdd);
                    }
                }
            });
            host.commitUpdate(recorder);
        }
        return host;
    };
}
function getComponentsHashInfo(source, variable) {
    const rootNode = source;
    const cmpListVars = (0, ast_utils_1.findNodes)(rootNode, ts.SyntaxKind.VariableDeclaration);
    let endPos = -1;
    let isEmpty = true;
    let magicGenCmpsInfo = cmpListVars.filter((node) => node.name.escapedText === variable);
    if (magicGenCmpsInfo && magicGenCmpsInfo.length > 0) {
        const firstPunctuation = (0, ast_utils_1.findNodes)(magicGenCmpsInfo[0], ts.SyntaxKind.FirstPunctuation);
        if (!(firstPunctuation && firstPunctuation.length > 0)) {
            throw new Error('magicGenCmpsHash variable has no open bracket ( { )');
        }
        endPos = firstPunctuation[0].end;
        const propertyAssignment = (0, ast_utils_1.findNodes)(firstPunctuation[0].parent, ts.SyntaxKind.PropertyAssignment);
        if (propertyAssignment && propertyAssignment.length > 0) {
            isEmpty = false;
        }
    }
    return {
        components: null,
        endPos,
        isEmpty
    };
}
function getComponentsArrayInfo(source, variable) {
    const rootNode = source;
    const cmpListVars = (0, ast_utils_1.findNodes)(rootNode, ts.SyntaxKind.VariableDeclaration);
    let endPos = -1;
    let cmpListArray;
    let isEmpty = true;
    let magicGenCmpsInfo = cmpListVars.filter((node) => node.name.escapedText === variable);
    if (magicGenCmpsInfo && magicGenCmpsInfo.length > 0) {
        const openBracketToken = (0, ast_utils_1.findNodes)(magicGenCmpsInfo[0], ts.SyntaxKind.OpenBracketToken);
        if (!(openBracketToken && openBracketToken.length > 0)) {
            throw new Error('magicGenComponents variable has no open bracket ([)');
        }
        endPos = openBracketToken[0].end;
        const identifiers = (0, ast_utils_1.findNodes)(openBracketToken[0].parent, ts.SyntaxKind.Identifier);
        // Array with items
        if (identifiers && identifiers.length > 0) {
            isEmpty = false;
            //endPos = identifiers[identifiers.length - 1].end;
            cmpListArray = identifiers.map((i) => i.escapedText);
        }
        // Array with no items
        // else{
        //   endPos = openBracketToken[0].end;
        // }
    }
    return {
        components: cmpListArray,
        endPos,
        isEmpty
    };
}
function getLazyLoadCompoenentsInfo(source, variable) {
    const cmpListVars = (0, ast_utils_1.findNodes)(source, ts.SyntaxKind.VariableDeclaration);
    let endPos = -1;
    let cmpListArray;
    let isEmpty = true;
    let magicGenCmpsInfo = cmpListVars.filter((node) => node.name.escapedText === variable);
    if (magicGenCmpsInfo && magicGenCmpsInfo.length > 0) {
        const openBracketToken = (0, ast_utils_1.findNodes)(magicGenCmpsInfo[0], ts.SyntaxKind.FirstPunctuation);
        if (!(openBracketToken && openBracketToken.length > 0)) {
            throw new Error('FirstPunctuation variable has no open bracket ([)');
        }
        endPos = openBracketToken[0].end;
        const identifiers = (0, ast_utils_1.findNodes)(openBracketToken[0].parent, ts.SyntaxKind.PropertyAssignment);
        const identifiers1 = (0, ast_utils_1.findNodes)(openBracketToken[0].parent, ts.SyntaxKind.Identifier);
        // Array with items
        if (identifiers && identifiers.length > 0) {
            isEmpty = false;
            cmpListArray = identifiers.map((i) => i.name.escapedText).filter(id => id !== "moduleName" && id !== "modulePath");
        }
    }
    return {
        components: cmpListArray,
        endPos,
        isEmpty
    };
}
function addComponentsToArray(source, info, cmpsToAdd) {
    const prefix = source.substring(0, info.endPos);
    const suffix = source.substring(info.endPos);
    let toAdd = `${cmpsToAdd}`;
    toAdd = `${toAdd.replace(/,/g, ",\n\t")}`;
    return info.isEmpty ?
        `${prefix}
\t${toAdd} ${suffix}` :
        `${prefix}
\t${toAdd},${suffix}`;
}
function addComponentsToHash(source, info, cmpsToAdd) {
    const prefix = source.substring(0, info.endPos);
    const suffix = source.substring(info.endPos);
    const cmpHashStr = EJS.render(`
      <% components.forEach(componentUniqueName => { %>
        <%= componentUniqueName %>:<%- componentUniqueName %>,
      <%})%>`, { components: cmpsToAdd });
    let toAdd = `${cmpHashStr.replace(/\n/g, '').replace(/,/g, ",\n")}`;
    // update source
    return `${prefix} ${toAdd} ${suffix}`;
    /*return info.isEmpty ?
      `${prefix} ${delLastComma(cmpHashStr)} ${suffix}` :
      `${prefix} ${delLastComma(cmpHashStr)}, ${suffix}` ;*/
}
// add the lazy loaded components to map
function addComponentsToLazyLoad(source, info, cmpsToAdd, module_name) {
    const prefix = source.substring(0, info.endPos);
    const suffix = source.substring(info.endPos);
    // get the module path
    let currentModulePath = env_1.env.metadata.paths.magicGenLibModulePath(module_name);
    const cmpHashStr = EJS.render(`
<%{components.forEach(view =>{-%>
<%=view.props.component_uniquename %> : { moduleName : 'Magic<%=moduleName%>Module'},
<%})}-%>`, { components: cmpsToAdd, moduleName: module_name, modulePath: currentModulePath });
    let toAdd = `${cmpHashStr.replace(/\n/g, '').replace(/,/g, ",\n")}`;
    // update source
    return `${prefix} ${toAdd} ${suffix}`;
}
function delLastComma(source) {
    let index = source.lastIndexOf(',');
    return source.substring(0, index);
}
//# sourceMappingURL=component-list.rule.js.map