"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = exports.createGenFuncs = void 0;
const EJS = require("ejs");
//import * as prettier    from "prettier";
const jsbeautify = require("js-beautify");
const Util_1 = require("../Util");
const env_1 = require("../env");
const types_1 = require("../../../types");
function createGenFuncs(output, type) {
    const htmlFn = jsbeautify.html.bind(this, output, {
        "max_preserve_newlines": 0,
        "wrap_line_length": 0,
        "wrap_attributes": "force-expand-multiline",
        "brace_style": 'collapse,preserve-inline'
    });
    const fnMap = {
        [types_1.GeneratedFileTypes.HTML]: htmlFn,
        //[GeneratedFileTypes.TS]  : prettier.format.bind(this, output, prettierConfig),
        [types_1.GeneratedFileTypes.TS]: jsbeautify.js.bind(this, output, { "brace_style": 'collapse,preserve-inline' }),
        [types_1.GeneratedFileTypes.HELPER]: jsbeautify.js.bind(this, output, {}),
        [types_1.GeneratedFileTypes.CSS]: jsbeautify.css.bind(this, output, {})
    };
    return fnMap[type]();
}
exports.createGenFuncs = createGenFuncs;
function generate(file, options) {
    return (host, context) => {
        EJS.renderFile(`${env_1.MAGIC_CLI_FOLDER}/${file.template}`, file.data, { "rmWhitespace": true }, (err, output) => {
            if (err) {
                (0, Util_1.logErr)(err);
                return;
            }
            try {
                //if(file.type != GeneratedFileTypes.TS) {
                output = createGenFuncs(output, file.type);
                //}
                let path = `${file.destination}/${file.name}`;
                if (host.exists(path)) {
                    host.overwrite(`${file.destination}/${file.name}`, output);
                }
                else {
                    host.create(`${file.destination}/${file.name}`, output);
                }
            }
            catch (err) {
                (0, Util_1.logErr)(output);
                (0, Util_1.logErr)(err);
            }
        });
        return host;
    };
}
exports.generate = generate;
//# sourceMappingURL=generate.rule.js.map