import * as EJS         from "ejs";
//import * as prettier    from "prettier";
import * as jsbeautify  from "js-beautify";

import { Rule, SchematicContext, Tree } from "@angular-devkit/schematics";

import { logErr } from "../Util";
import { MAGIC_CLI_FOLDER } from "../env";
import { GeneratedFileTypes, TemplateConfig } from "../../../types";
import { MagicOptionScheme } from "./magic-option.scheme";
import { prettierConfig } from "../config";

export function createGenFuncs(output : string,type: GeneratedFileTypes ) {
  const htmlFn =  jsbeautify.html.bind(this, output, {
    "max_preserve_newlines": 0,
    "wrap_line_length"     : 0,
    "wrap_attributes"      : "force-expand-multiline",
     "brace_style" : 'collapse,preserve-inline'
  });

  const fnMap = {
    [GeneratedFileTypes.HTML]: htmlFn,
    //[GeneratedFileTypes.TS]  : prettier.format.bind(this, output, prettierConfig),
    [GeneratedFileTypes.TS]  : jsbeautify.js.bind(this, output, {"brace_style" : 'collapse,preserve-inline'}),
    [GeneratedFileTypes.HELPER]  : jsbeautify.js.bind(this, output, {}),
    [GeneratedFileTypes.CSS] : jsbeautify.css.bind(this, output, { })
  };

  return fnMap[type]();
}

export function generate(file: TemplateConfig,options:MagicOptionScheme) :Rule{
  return (host:Tree, context: SchematicContext) => {
    EJS.renderFile(
      `${MAGIC_CLI_FOLDER}/${file.template}`,
      file.data,
      {"rmWhitespace" : true},
     (err, output) => {
        if (err) { logErr(err); return }

        try {
          //if(file.type != GeneratedFileTypes.TS) {
            output = createGenFuncs(output, file.type);
          //}

          let path = `${file.destination}/${file.name}`;

          if(host.exists(path)){
            host.overwrite(`${file.destination}/${file.name}`, output)
          } else{
            host.create(`${file.destination}/${file.name}`, output);
          }
        }
        catch (err) {
          logErr(output);
          logErr(err);
        }
      });
    return host;
  }
}
