"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRouteFileToModuleFile = exports.createRoute = exports.checkAndCreateRouteForModule = exports.generateWebModules = exports.generateWebModule = exports.checkAndCreateModule = exports.getDestinationModulePathByWebModuleName = exports.updateWebModuleFileWithNewClassName = exports.overwriteWebModuleFileName = exports.initGenModules = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const env_1 = require("../env");
const Util_1 = require("../Util");
const ast_1 = require("../../utils/ast");
const env_interface_1 = require("../../../types/interfaces/env.interface");
//-------------------------------------------------------------------------------------------------
// init generate module into env.modulesGen
//-------------------------------------------------------------------------------------------------
function initGenModules(options, generateViaCLI = false) {
    return (tree, context) => {
        let metadata = env_1.env.metadata;
        let programList = env_1.env.programList;
        env_1.env.modulesGen = [];
        let web_modules = metadata.config.web_modules;
        if (generateViaCLI) {
            let programListString = JSON.stringify(programList.programListContents);
            // Validate whether the component is valid
            if (programListString.includes(options.component)) {
                let moduleInfo = new env_interface_1.ModuleInfo(options.module, options.loadOnDemand);
                env_1.env.modulesGen.push(moduleInfo);
            }
            else {
                (0, Util_1.LogLn)(`Invalid component ${options.component} to generate.`);
            }
        }
        else {
            // Generate only one module from --module=xxxx
            if (options.module) {
                let moduleInfo = new env_interface_1.ModuleInfo(options.module, options.loadOnDemand);
                env_1.env.modulesGen.push(moduleInfo);
            }
            else {
                // Generate list of components from config.json, properties web_modules.module_name
                for (let modulePath of web_modules) {
                    //LogLn(`   Web Module name:   [${modulePath.module_name}]   IsLoadOnDemand?   [${modulePath.load_on_demand}]`);
                    let moduleInfo = new env_interface_1.ModuleInfo(modulePath.module_name, modulePath.load_on_demand);
                    env_1.env.modulesGen.push(moduleInfo);
                }
            }
        }
        if (!generateViaCLI)
            (0, Util_1.LogLn)(`   Number of modules to be check for generate: ${web_modules.length}`);
        return tree;
    };
}
exports.initGenModules = initGenModules;
//-------------------------------------------------------------------------------------------------
// overwrite the web module file name with the new content
//-------------------------------------------------------------------------------------------------
function overwriteWebModuleFileName(options, moduleNameFileName, content) {
    return (tree, _context) => {
        if (!tree.exists(moduleNameFileName)) {
            (0, Util_1.LogLn)(`      [>Error] File cannot be overwrite, The file is not exist  !!! : ${moduleNameFileName}`);
        }
        tree.overwrite(moduleNameFileName, content);
        return tree;
    };
}
exports.overwriteWebModuleFileName = overwriteWebModuleFileName;
//-------------------------------------------------------------------------------------------------
// update the  the web module file name with the new class name
//-------------------------------------------------------------------------------------------------
function updateWebModuleFileWithNewClassName(options, webModuleName) {
    return (tree, context) => {
        let rules = [];
        const origModuleFileName = getWebModuleFullFileName(webModuleName);
        // create new class name for "web Module Name"
        let newClassModuleName = getWebModuleClass(webModuleName);
        //read the exist module file name
        const text = tree.read(origModuleFileName);
        if (text === null) {
            throw new schematics_1.SchematicsException(`File ${origModuleFileName} does not exist.`);
        }
        let sourceText = text.toString('utf-8');
        if (sourceText !== "") {
            let newsourceText = sourceText.replace(`MagicGenLibModule`, newClassModuleName);
            rules.push(overwriteWebModuleFileName(options, origModuleFileName, newsourceText));
        }
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.updateWebModuleFileWithNewClassName = updateWebModuleFileWithNewClassName;
//-------------------------------------------------------------------------------------------------
// copy the two default files into the web module path
//-------------------------------------------------------------------------------------------------
function copyDefaultMagicFilesToWebModule(options, webModuleName) {
    return (tree, context) => {
        const webModulePath = getDestinationModulePathByWebModuleName(webModuleName);
        return (0, schematics_1.chain)([
            (0, schematics_1.branchAndMerge)((0, schematics_1.chain)([
                (0, schematics_1.mergeWith)((0, schematics_1.apply)((0, schematics_1.url)(`./../mg-add/files/src/app/magic/`), [
                    (0, schematics_1.move)(webModulePath)
                ]), schematics_1.MergeStrategy.AllowCreationConflict)
            ]))
        ])(tree, context);
    };
}
//-------------------------------------------------------------------------------------------------
// delete LazyLoadService for non root modules
//-------------------------------------------------------------------------------------------------
function deleteLazyLoadService(webModuleName) {
    return (tree) => {
        const lazyLoaderServicePath = getDestinationModulePathByWebModuleName(webModuleName) + '/lazy-loader.service.ts';
        if (webModuleName != '') {
            if (!tree.exists(lazyLoaderServicePath)) {
                (0, Util_1.LogLn)(`      [>Error] File cannot be overwrite, The file is not exist  !!! :lazyLoaderServicePath`);
            }
            tree.delete(lazyLoaderServicePath);
            return tree;
        }
    };
}
//-------------------------------------------------------------------------------------------------
// get destination  path according to the send webModuleName
//-------------------------------------------------------------------------------------------------
function getDestinationModulePathByWebModuleName(webModuleName) {
    const newDestModulePath = `${env_1.env.metadata.paths.rootMagicGenFolder}/${env_1.GEN_FOLDER}/${webModuleName}`;
    return newDestModulePath;
}
exports.getDestinationModulePathByWebModuleName = getDestinationModulePathByWebModuleName;
//-------------------------------------------------------------------------------------------------
// get web module full file name according to the send webModuleName
//-------------------------------------------------------------------------------------------------
function getWebModuleFullFileName(webModuleName) {
    // calc the path of new the module
    const newDestModulePath = getDestinationModulePathByWebModuleName(webModuleName);
    return `${newDestModulePath}/magic.gen.lib.module.ts`;
}
//-------------------------------------------------------------------------------------------------
// get web module class according to the send webModuleName
//-------------------------------------------------------------------------------------------------
function getWebModuleClass(webModuleName) {
    return `Magic` + webModuleName + `Module`;
}
//-------------------------------------------------------------------------------------------------
// add magic module to app module
//-------------------------------------------------------------------------------------------------
function addMagicModuleToAppModule(options, modulePath, moduleName, srcModuleName) {
    return (tree, context) => {
        const project = env_1.env.project;
        (0, Util_1.LogLn)(`         [>] add New Web Module    :[${moduleName}] `);
        (0, Util_1.LogLn)(`         [>]         from          :[${srcModuleName}]`);
        (0, Util_1.LogLn)(`         [>]         To App Module :[${modulePath}]`);
        (0, ast_1.addModuleImportToModule)(tree, modulePath, // for now we will update env.metadata.paths.magicGenLibModule
        moduleName, // 'MagicXXXModule',
        srcModuleName);
        return tree;
    };
}
//-------------------------------------------------------------------------------------------------
// create module
//-------------------------------------------------------------------------------------------------
function checkAndCreateModule(options, webModuleName, loadOnDemand) {
    return (tree, context) => {
        let rules = [];
        const webModuleFullFileName = getWebModuleFullFileName(webModuleName);
        // only if not exist create the new 2 files magic.gen.lib.module.ts & component-list.g.ts
        if (!tree.exists(webModuleFullFileName)) {
            rules.push(copyDefaultMagicFilesToWebModule(options, webModuleName));
            rules.push(updateWebModuleFileWithNewClassName(tree, webModuleName));
            rules.push(deleteLazyLoadService(webModuleName));
            // for NON load on demand we need to update magic root module
            if (!loadOnDemand) {
                const newDestModulePath = `./${webModuleName}/magic.gen.lib.module`;
                const webModuleClass = getWebModuleClass(webModuleName);
                rules.push(addMagicModuleToAppModule(options, env_1.env.metadata.paths.magicGenLibModule, webModuleClass, newDestModulePath));
            }
            return (0, schematics_1.chain)(rules)(tree, context);
        }
        ;
    };
}
exports.checkAndCreateModule = checkAndCreateModule;
//-------------------------------------------------------------------------------------------------
// check if module is exist, only if not exist create the web module
//-------------------------------------------------------------------------------------------------
function generateWebModule(options, webModuleName, loadOnDemand) {
    return (tree, context) => {
        let rules = [];
        (0, Util_1.LogLn)(`  [>]Handling Web Module named:   [${webModuleName}]   isLoadOnDemand:   [${loadOnDemand}]`);
        rules.push(checkAndCreateModule(options, webModuleName, loadOnDemand));
        rules.push(checkAndCreateRouteForModule(options, webModuleName, loadOnDemand));
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.generateWebModule = generateWebModule;
//-------------------------------------------------------------------------------------------------
// generate all the modules in  env.modulesGen
//-------------------------------------------------------------------------------------------------
function generateWebModules(options, generateViaCLI = false) {
    return (tree, context) => {
        let rules = [];
        for (let webModuleInfo of env_1.env.modulesGen) {
            if (webModuleInfo.moduleName !== undefined && webModuleInfo.moduleName !== "") {
                if (generateViaCLI) {
                    if (webModuleInfo.moduleName === options.module) {
                        rules.push(generateWebModule(options, webModuleInfo.moduleName, webModuleInfo.loadOnDemand));
                    }
                }
                else {
                    rules.push(generateWebModule(options, webModuleInfo.moduleName, webModuleInfo.loadOnDemand));
                }
            }
        }
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.generateWebModules = generateWebModules;
//-------------------------------------------------------------------------------------------------
// check if module is exist, only if not exist create the web module
//-------------------------------------------------------------------------------------------------
function checkAndCreateRouteForModule(options, webModuleName, loadOnDemand) {
    return (tree, context) => {
        let rules = [];
        if (loadOnDemand) {
            const newDestRoutePathForModule = env_1.env.metadata.paths.getRoutePathForWebModule(webModuleName);
            // only if file not exist then copy the default route
            if (!tree.exists(newDestRoutePathForModule)) {
                rules.push(createRoute(options, webModuleName));
            }
            else {
                // if file exist then only update the magic.gen.lib.module.ts
                rules.push(addRouteFileToModuleFile(options, webModuleName));
            }
        }
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.checkAndCreateRouteForModule = checkAndCreateRouteForModule;
//-------------------------------------------------------------------------------------------------
// create route for module
//-------------------------------------------------------------------------------------------------
function createRoute(options, webModuleName) {
    return (tree, context) => {
        let rules = [];
        rules.push(copyDefaultRouteMagicFilesToWebModule(options, webModuleName));
        // --------------------------------------------------------
        // // generate the route for module /////
        // let routeItem : RouteTable = new RouteTable();
        // routeItem.module_name = webModuleName;
        //
        // let route:Route = new Route();
        // route.ModuleName = webModuleName;
        // route.OutletName="";
        // route.RouteName="";
        // route.children=null;
        //
        // routeItem.routesArray = [route];
        // rules.push(genRouteFile(options, routeItem ));
        // --------------------------------------------------------
        // update the new MagicRoutingModule in file magic.gen.lib.module.ts of the module
        rules.push(addRouteFileToModuleFile(options, webModuleName));
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.createRoute = createRoute;
//-------------------------------------------------------------------------------------------------
// create route for module
//-------------------------------------------------------------------------------------------------
function addRouteFileToModuleFile(options, webModuleName) {
    return (tree, context) => {
        let rules = [];
        const modulePath = getWebModuleFullFileName(webModuleName); // get the magic.gen.lib.module.ts according to the module name
        const moduleName = `MagicRoutingModule`; //for now it will be the same for all modules ... getWebModuleClass(webModuleName);
        const srcModuleName = `./app.routes`;
        rules.push(addMagicModuleToAppModule(options, modulePath, moduleName, srcModuleName));
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.addRouteFileToModuleFile = addRouteFileToModuleFile;
//-------------------------------------------------------------------------------------------------
// copy the two default files into the web module path
//-------------------------------------------------------------------------------------------------
function copyDefaultRouteMagicFilesToWebModule(options, webModuleName) {
    return (tree, context) => {
        const routeFileForWebModulePath = env_1.env.metadata.paths.getRoutePathForWebModule(webModuleName);
        if (tree.exists(routeFileForWebModulePath)) {
            let rules = [];
            return (0, schematics_1.chain)(rules)(tree, context);
        }
        else {
            const webModulePath = getDestinationModulePathByWebModuleName(webModuleName);
            (0, Util_1.LogLn)(`[ >] copy default Route file to webModule [${webModuleName}]`);
            return (0, schematics_1.chain)([
                (0, schematics_1.branchAndMerge)((0, schematics_1.chain)([
                    (0, schematics_1.mergeWith)((0, schematics_1.apply)((0, schematics_1.url)(`./../mg-add/webModule/`), [
                        (0, schematics_1.move)(webModulePath)
                    ]), schematics_1.MergeStrategy.AllowCreationConflict)
                ]))
            ])(tree, context);
        }
    };
}
//# sourceMappingURL=init-add-modules.rule.js.map