"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initGenComponentsFromList = exports.initAndGenComponentsForModule = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const env_1 = require("../env");
const load_views_gen_rule_1 = require("./load-views-gen.rule");
const build_view_rule_1 = require("./build-view.rule");
const component_list_rule_1 = require("./component-list.rule");
const init_add_modules_rule_1 = require("./init-add-modules.rule");
const utils_1 = require("../utils");
function initAndGenComponentsForModule(options, shouldBuildAndUpdateModule, generateViaCLI = false) {
    return (tree, context) => {
        let metadata = env_1.env.metadata;
        env_1.env.componentsGen = [];
        let rules = [];
        rules.push((0, utils_1.displayMessge)(options, " ********************************* START    GENERATE *********************************"));
        // if we need to build and update module , first generate(if needed) the modules
        if (shouldBuildAndUpdateModule) {
            rules.push((0, init_add_modules_rule_1.initGenModules)(options, generateViaCLI));
            rules.push((0, init_add_modules_rule_1.generateWebModules)(options, generateViaCLI));
        }
        // TO DO: Following code can be simplified.
        if (generateViaCLI) {
            const componentsArray = [options.component];
            rules.push(initGenComponentsFromList(options, options.module, options.component, componentsArray));
            rules.push((0, load_views_gen_rule_1.loadViewsToGen)(options));
            if (shouldBuildAndUpdateModule) {
                rules.push((0, build_view_rule_1.buildViews)(options, options.module));
                rules.push((0, component_list_rule_1.componentlistGen)(options, options.module, options.loadOnDemand));
            }
        }
        else {
            for (let moduleJsonPath of metadata.config.web_modules) {
                rules.push((0, utils_1.displayMessge)(options, `          ******    Start Web Module name : [${moduleJsonPath.module_name}]    *******`));
                rules.push(initGenComponentsFromList(options, moduleJsonPath.module_name, options.component, moduleJsonPath.form_files));
                rules.push((0, load_views_gen_rule_1.loadViewsToGen)(options));
                if (shouldBuildAndUpdateModule) {
                    rules.push((0, build_view_rule_1.buildViews)(options, moduleJsonPath.module_name));
                    rules.push((0, component_list_rule_1.componentlistGen)(options, moduleJsonPath.module_name, moduleJsonPath.load_on_demand));
                }
            }
        }
        rules.push((0, utils_1.displayMessge)(options, " ********************************* E N D    GENERATE *********************************"));
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.initAndGenComponentsForModule = initAndGenComponentsForModule;
function initGenComponentsFromList(options, module_name, component, form_files) {
    return (host, context) => {
        let metadata = env_1.env.metadata;
        env_1.env.componentsGen = [];
        // Generate only one component from --component=xxxx
        if (component) {
            env_1.env.componentsGen.push(component);
        }
        else {
            // Generate list of components from config.json, properties form_views.
            for (let cmpJsonPath of form_files) {
                let JsonRelativePath = env_1.env.metadata.paths.getRelativePathForComponentInModule(module_name, cmpJsonPath);
                env_1.env.componentsGen.push(JsonRelativePath);
            }
        }
        return host;
    };
}
exports.initGenComponentsFromList = initGenComponentsFromList;
//# sourceMappingURL=init-gen-components.rule.js.map