import { chain, Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import { MagicOptionScheme } from "./magic-option.scheme";
import { env } from "../env";
import { loadViewsToGen } from "./load-views-gen.rule";
import { buildViews } from "./build-view.rule";
import { componentlistGen } from "./component-list.rule";
import { generateWebModules, initGenModules } from "./init-add-modules.rule";
import { displayMessge } from "../utils";
import {LogLn} from "../Util";

export function initAndGenComponentsForModule(options: MagicOptionScheme, shouldBuildAndUpdateModule: boolean, generateViaCLI: boolean = false): Rule {
  return (tree: Tree, context: SchematicContext) => {
    let metadata = env.metadata;
    env.componentsGen = [];
    let rules:Rule[] = [];

    rules.push(displayMessge(options, " ********************************* START    GENERATE *********************************"))
    // if we need to build and update module , first generate(if needed) the modules
    if (shouldBuildAndUpdateModule) {
      rules.push(initGenModules (options, generateViaCLI));
      rules.push(generateWebModules(options, generateViaCLI));
    }

    // TO DO: Following code can be simplified.
    if(generateViaCLI){
      const componentsArray = [options.component];
      rules.push(initGenComponentsFromList(options, options.module, options.component, componentsArray));
      rules.push(loadViewsToGen(options));

      if (shouldBuildAndUpdateModule) {
        rules.push(buildViews(options, options.module));
        rules.push(componentlistGen(options, options.module, options.loadOnDemand));
      }
    }else{
      for (let moduleJsonPath of metadata.config.web_modules) {
        rules.push(displayMessge(options, `          ******    Start Web Module name : [${moduleJsonPath.module_name}]    *******`))

        rules.push(initGenComponentsFromList(options, moduleJsonPath.module_name, options.component, moduleJsonPath.form_files));
        rules.push(loadViewsToGen(options));

        if (shouldBuildAndUpdateModule) {
          rules.push(buildViews(options, moduleJsonPath.module_name));
          rules.push(componentlistGen(options, moduleJsonPath.module_name, moduleJsonPath.load_on_demand));
        }
      }
    }

      rules.push(displayMessge(options, " ********************************* E N D    GENERATE *********************************"))
    return chain(rules)(tree, context);
  };
}


export function initGenComponentsFromList(options: MagicOptionScheme, module_name:string, component: string, form_files: string[]): Rule {
  return (host: Tree, context: SchematicContext) => {
    let metadata = env.metadata;
    env.componentsGen = [];

    // Generate only one component from --component=xxxx
    if (component) {
      env.componentsGen.push(component)
    } else {

      // Generate list of components from config.json, properties form_views.
      for (let cmpJsonPath of form_files) {

        let JsonRelativePath = env.metadata.paths.getRelativePathForComponentInModule(module_name, cmpJsonPath);

        env.componentsGen.push(JsonRelativePath);
      }
    }
    return host;
  };
}
