"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initMagicMetadata = void 0;
const metadata_class_1 = require("../metadata.class");
const env_1 = require("../env");
const config_1 = require("../../utils/devkit-utils/config");
function initMagicMetadata(options) {
    return (host, context) => {
        if (!env_1.env.metadata) {
            env_1.env.workspace = (0, config_1.getWorkspace)(host);
            env_1.env.project = (0, config_1.getProjectFromWorkspace)(env_1.env.workspace, options.project);
            env_1.env.metadata = new metadata_class_1.MagicMetadata(host, context, options);
            env_1.env.programList = new metadata_class_1.MagicMetadata(host, context, options);
        }
        return host;
    };
}
exports.initMagicMetadata = initMagicMetadata;
//# sourceMappingURL=init-magic-metadata.rule.js.map