import { Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import { MagicMetadata } from "../metadata.class";
import { env } from "../env";
import { getProjectFromWorkspace, getWorkspace } from "../../utils/devkit-utils/config";
import { MagicOptionScheme } from "./magic-option.scheme";


export function initMagicMetadata(options:MagicOptionScheme) : Rule {
  return (host: Tree, context: SchematicContext)=>{
    if( !env.metadata ) {
      env.workspace = getWorkspace(host);
      env.project   = getProjectFromWorkspace(env.workspace, options.project);
      env.metadata  = new MagicMetadata(host, context, options);
      env.programList = new MagicMetadata(host, context, options);
    }
    return host;
  }
}

