"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadViewsToGen = void 0;
const utils_1 = require("../utils");
const env_1 = require("../env");
const Util_1 = require("../Util");
const process_json_1 = require("../process-json");
function loadViewsToGen(options) {
    return (host, context) => {
        const metadata = env_1.env.metadata;
        env_1.env.app = {
            name: options.project,
            suffix: "mga",
            views: []
        };
        (0, Util_1.LogLn)(`*** Step 1: Loading JSON files ***`);
        env_1.env.componentsGen.forEach(cmpJsonPath => {
            cmpJsonPath = env_1.env.metadata.paths.getJsonPathForComponent(cmpJsonPath);
            (0, Util_1.LogLn)(`[>] Loading JSON file ${cmpJsonPath}`);
            let view = (0, utils_1.readJson)(host, cmpJsonPath);
            env_1.env.app.views.push(view);
        });
        (0, Util_1.LogLn)(`*** Step 2: Processing JSON files -  (${env_1.env.app.views.length} components) ***`);
        env_1.env.app = (0, process_json_1.processJson)(env_1.env.app);
        //console.log(`Number of app.views to generate: ${env.app.views.length}`);
        return host;
    };
}
exports.loadViewsToGen = loadViewsToGen;
//# sourceMappingURL=load-views-gen.rule.js.map