import { Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import { readJson } from "../utils";
import { env } from "../env";
import { Log, LogLn } from "../Util";
import { MagicOptionScheme } from "./magic-option.scheme";
import { processJson } from "../process-json";


export function loadViewsToGen(options: MagicOptionScheme): Rule {
  return (host: Tree, context: SchematicContext) => {
    const metadata = env.metadata;

    env.app = {
      name: options.project,
      suffix: "mga",
      views: []
    };

    LogLn(`*** Step 1: Loading JSON files ***`);
    env.componentsGen.forEach(cmpJsonPath => {
      cmpJsonPath = env.metadata.paths.getJsonPathForComponent(cmpJsonPath);
      LogLn(`[>] Loading JSON file ${cmpJsonPath}`);
      let view = readJson(host, cmpJsonPath);
      env.app.views.push(view);
    });
    LogLn(`*** Step 2: Processing JSON files -  (${env.app.views.length} components) ***`);
    env.app = processJson(env.app);
    //console.log(`Number of app.views to generate: ${env.app.views.length}`);
    return host;
  };
}
