"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addImportTSModule = exports.getMagicConfig = exports.readJson = exports.getProject = exports.deleteMagicMetadataFolder = exports.deleteMagicFolder = exports.deleteMagicFiles = exports.copyMagicFiles = exports.displayMessge = void 0;
const config_1 = require("../utils/devkit-utils/config");
const schematics_1 = require("@angular-devkit/schematics");
const env_1 = require("./env");
const route_utils_1 = require("../utils/devkit-utils/route-utils");
const ast_1 = require("../utils/ast");
const Util_1 = require("./Util");
function displayMessge(options, message) {
    return (host, context) => {
        (0, Util_1.LogLn)(`[>] ${message}`);
        return host;
    };
}
exports.displayMessge = displayMessge;
function copyMagicFiles(options) {
    return (host, context) => {
        const project = getProject(host, options.project);
        return (0, schematics_1.chain)([
            (0, schematics_1.branchAndMerge)((0, schematics_1.chain)([
                (0, schematics_1.mergeWith)((0, schematics_1.apply)((0, schematics_1.url)('./files'), [
                    (0, schematics_1.template)({
                        skipHelp: options.skipHelp,
                    }),
                    (0, schematics_1.move)(project.root)
                ]), schematics_1.MergeStrategy.AllowCreationConflict)
            ]))
        ])(host, context);
    };
}
exports.copyMagicFiles = copyMagicFiles;
function deleteMagicFiles(option) {
    return (host) => {
        const metadta = env_1.env.metadata;
        let files = [
            metadta.paths.appComponentPath,
            metadta.paths.appRoutesPath,
            metadta.paths.executionPath,
            metadta.paths.magicStylePath,
            // Magic Generate folder
            metadta.paths.rootMagicComponentListPath,
            metadta.paths.magicGenLibModule,
            metadta.paths.favIconPath
        ];
        for (let file of files) {
            if (host.exists(file)) {
                host.delete(file);
            }
        }
        return host;
    };
}
exports.deleteMagicFiles = deleteMagicFiles;
function deleteMagicFolder(option) {
    return (host) => {
        const metadta = env_1.env.metadata;
        const path = metadta.paths.magicGenFolderPath;
        //rimraf(path);
        host.getDir(path).visit(filePath => {
            host.delete(filePath);
        });
        return host;
    };
}
exports.deleteMagicFolder = deleteMagicFolder;
function deleteMagicMetadataFolder(option) {
    return (host) => {
        const metadta = env_1.env.metadata;
        const path = metadta.paths.metadataFolderPath;
        //rimraf(path);
        host.getDir(path).visit(filePath => {
            host.delete(filePath);
        });
        return host;
    };
}
exports.deleteMagicMetadataFolder = deleteMagicMetadataFolder;
function getProject(host, projectName) {
    const workspace = (0, config_1.getWorkspace)(host);
    const project = (0, config_1.getProjectFromWorkspace)(workspace, projectName);
    return project;
}
exports.getProject = getProject;
function readJson(host, path) {
    const source = host.read(path);
    let file = null;
    if (source) {
        const sourceText = source.toString("utf-8");
        file = JSON.parse(sourceText);
    }
    return file;
}
exports.readJson = readJson;
function getMagicConfig(host, project) {
    let path = `${project.root}/${env_1.METADATA_DIR}/config.json`;
    const source = host.read(path);
    if (!source) {
        return;
    }
    const sourceText = source.toString("utf-8");
    const config = JSON.parse(sourceText);
    return config;
}
exports.getMagicConfig = getMagicConfig;
function addImportTSModule(path, name, from) {
    return (host, context) => {
        let moduleSource = (0, ast_1.getSourceFile)(host, path);
        const recorder = host.beginUpdate(path);
        const routesChange = (0, route_utils_1.insertImport)(moduleSource, path, name, from);
        if (routesChange.toAdd) {
            recorder.insertLeft(routesChange.pos, routesChange.toAdd);
        }
        host.commitUpdate(recorder);
    };
}
exports.addImportTSModule = addImportTSModule;
//# sourceMappingURL=utils.js.map