import { getProjectFromWorkspace, getWorkspace, Project } from "../utils/devkit-utils/config";
import {
  apply,
  branchAndMerge,
  chain,
  MergeStrategy,
  mergeWith,
  move,
  Rule,
  SchematicContext, template,
  Tree,
  url
} from "@angular-devkit/schematics";
import { env, METADATA_DIR } from "./env";
import { MagicOptionScheme } from "./rules/magic-option.scheme";
import { insertImport } from "../utils/devkit-utils/route-utils";
import { getSourceFile } from "../utils/ast";
import { InsertChange } from "../utils/devkit-utils/change";
import { MagicMetadata } from "./metadata.class";
import { LogLn } from "./Util";

export function displayMessge(options:MagicOptionScheme, message:string) : Rule {
  return (host: Tree, context: SchematicContext)=>{

    LogLn(`[>] ${message}`);
    return host;
  }
}


export function copyMagicFiles(options:MagicOptionScheme): Rule {
  return (host: Tree,context:SchematicContext) => {
    const project   = getProject(host, options.project);
    return chain([
      branchAndMerge(chain([
        mergeWith(
          apply(url('./files'), [
            template({
              skipHelp: options.skipHelp,
            }),
            move(project.root)
          ]), MergeStrategy.AllowCreationConflict)
      ]))
    ])(host,context);
  }
}
export function deleteMagicFiles(option:MagicOptionScheme): Rule {
  return (host: Tree) => {
    const metadta   = env.metadata;
    let files = [
      metadta.paths.appComponentPath,
      metadta.paths.appRoutesPath,
      metadta.paths.executionPath,
      metadta.paths.magicStylePath,

      // Magic Generate folder
      metadta.paths.rootMagicComponentListPath,
      metadta.paths.magicGenLibModule,
      metadta.paths.favIconPath
    ];
    for (let file of files)	{
      if (host.exists(file)) {
        host.delete(file);
      }
    }
    return host;
  };

}
export function deleteMagicFolder(option:MagicOptionScheme): Rule {
  return (host: Tree) => {
    const metadta   = env.metadata;
    const path = metadta.paths.magicGenFolderPath;
    //rimraf(path);
    host.getDir(path).visit( filePath => {
      host.delete(filePath);
    });
    return host;
  };

}
export function deleteMagicMetadataFolder(option:MagicOptionScheme): Rule {
  return (host: Tree) => {
    const metadta   = env.metadata;
    const path = metadta.paths.metadataFolderPath;

    //rimraf(path);
    host.getDir(path).visit( filePath => {
      host.delete(filePath);
    });
    return host;
  };

}

export function getProject(host: Tree, projectName: string): Project {
  const workspace = getWorkspace(host);
  const project   = getProjectFromWorkspace(workspace, projectName);
  return project;
}
export function readJson(host:Tree,path:string) {
  const source = host.read(path);
  let   file   = null;
  if (source) {
    const sourceText = source.toString("utf-8");
    file = JSON.parse(sourceText);
  }
  return file;
}
export function getMagicConfig(host: Tree, project: Project) {
  let path = `${project.root}/${METADATA_DIR}/config.json`;
  const source = host.read(path);
  if (!source) { return; }

  const sourceText = source.toString("utf-8");
  const config = JSON.parse(sourceText);

  return config;
}

export function addImportTSModule(path:string,name:string,from:string) : Rule {
  return (host: Tree, context:SchematicContext) => {

    let moduleSource = getSourceFile(host, path);

    const recorder = host.beginUpdate(path);

    const routesChange =insertImport(moduleSource, path, name,from) as InsertChange;
    if (routesChange.toAdd) {
      recorder.insertLeft(routesChange.pos, routesChange.toAdd);
    }
    host.commitUpdate(recorder);
  }
}
