"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mgInstallPrerequisites = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const init_magic_metadata_rule_1 = require("../magic-utils/rules/init-magic-metadata.rule");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const env_1 = require("../magic-utils/env");
const package_1 = require("../utils/package");
function mgInstallPrerequisites(options) {
    return (0, schematics_1.chain)([
        (0, init_magic_metadata_rule_1.initMagicMetadata)(options),
        installPrerequisitesSaveDev(options)
    ]);
}
exports.mgInstallPrerequisites = mgInstallPrerequisites;
function installPrerequisitesSaveDev(option) {
    return (host, context) => {
        for (let dep of env_1.devDependencies) {
            context.logger.info(`[>] Add devDependencies ${dep.name}`);
            (0, package_1.addPackageToPackageJson)(host, 'devDependencies', dep.name, dep.version);
        }
        context.addTask(new tasks_1.NodePackageInstallTask());
        return host;
    };
}
//# sourceMappingURL=index.js.map