import { chain, Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import { initMagicMetadata}   from "../magic-utils/rules/init-magic-metadata.rule";
import { NodePackageInstallTask } from "@angular-devkit/schematics/tasks";
import { dependencies, devDependencies } from "../magic-utils/env";
import { addPackageToPackageJson } from "../utils/package";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";

export function mgInstallPrerequisites(options:MagicOptionScheme): Rule {
  return chain([
    initMagicMetadata            (options),
    installPrerequisitesSaveDev  (options)
  ]);
}


function installPrerequisitesSaveDev(option:MagicOptionScheme): Rule {
  return (host: Tree, context:SchematicContext) => {
      for (let dep of devDependencies){
        context.logger.info(`[>] Add devDependencies ${dep.name}`);
        addPackageToPackageJson(host, 'devDependencies', dep.name, dep.version);
      }

      context.addTask(new NodePackageInstallTask());

    return host;
  };
}



