"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mgAddTasks = void 0;
const tasks_1 = require("@angular-devkit/schematics/tasks");
const env_1 = require("../magic-utils/env");
function mgAddTasks(options) {
    return (host, context) => {
        console.log("   [V - add install dependencies !] options.cliVersion=" + options.cliVersion);
        env_1.devDependencies.push(new env_1.Idependencies("@magic-xpa/cli", options.cliVersion));
        // install the devDependencies
        const devInstallTask = context.addTask(new tasks_1.RunSchematicTask('mg-install', {
            skipInstall: false,
            skipPackageJson: false,
            dependencies: [],
            devDependencies: env_1.devDependencies
        }));
        console.log("   [V - add install dependencies !] options.angularVersion=" + options.angularVersion);
        env_1.dependencies.push(new env_1.Idependencies("@magic-xpa/angular", options.angularVersion));
        // install the dependencies
        const packagesInstallTask = context.addTask(new tasks_1.RunSchematicTask('mg-install', {
            skipInstall: options.skipInstall,
            skipPackageJson: options.skipPackageJson,
            dependencies: env_1.dependencies,
            devDependencies: []
        }), [devInstallTask]);
        const deleteFilesTask = context.addTask(new tasks_1.RunSchematicTask('delete-files', options), [devInstallTask, packagesInstallTask]);
        const ngAddTask = context.addTask(new tasks_1.RunSchematicTask('mg-add', options), [devInstallTask, packagesInstallTask, deleteFilesTask]);
    };
}
exports.mgAddTasks = mgAddTasks;
//# sourceMappingURL=index.js.map