import { Rule,Tree,SchematicContext } from "@angular-devkit/schematics";
import { NodePackageInstallTask, RunSchematicTask } from "@angular-devkit/schematics/tasks";
import { addPackageToPackageJson } from "../utils/package";
import { dependencies, devDependencies, Idependencies } from "../magic-utils/env";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";

export function mgAddTasks(options:MagicOptionScheme): Rule {
  return (host:Tree, context:SchematicContext)=>{

    console.log("   [V - add install dependencies !] options.cliVersion=" + options.cliVersion );
    devDependencies.push(new Idependencies("@magic-xpa/cli", options.cliVersion));

    // install the devDependencies
    const devInstallTask = context.addTask(
      new RunSchematicTask('mg-install', {
        skipInstall     : false,
        skipPackageJson : false,
        dependencies    : [],
        devDependencies : devDependencies
      })
    );



    console.log("   [V - add install dependencies !] options.angularVersion=" + options.angularVersion);
    dependencies.push(new Idependencies("@magic-xpa/angular", options.angularVersion ));

    // install the dependencies
    const packagesInstallTask = context.addTask(
      new RunSchematicTask('mg-install', {
        skipInstall     : options.skipInstall,
        skipPackageJson : options.skipPackageJson,
        dependencies    : dependencies,
        devDependencies : []
      }),
      [devInstallTask]
    );


    const deleteFilesTask = context.addTask(
      new RunSchematicTask('delete-files', options),
      [devInstallTask,packagesInstallTask]
    );

    const ngAddTask = context.addTask(
      new RunSchematicTask('mg-add', options),
      [devInstallTask, packagesInstallTask, deleteFilesTask]
    );

  };
}


