"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mgAdd = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const package_1 = require("./../utils/package");
const env_1 = require("../magic-utils/env");
const utils_1 = require("../magic-utils/utils");
const init_magic_metadata_rule_1 = require("../magic-utils/rules/init-magic-metadata.rule");
const ast_1 = require("../utils/ast");
const Util_1 = require("../magic-utils/Util");
const generate_rule_1 = require("../magic-utils/rules/generate.rule");
const generated_file_types_enum_1 = require("../../types/enums/generated-file-types.enum");
const ast_utils_1 = require("../utils/devkit-utils/ast-utils");
const ts = require("typescript");
const change_1 = require("../utils/devkit-utils/change");
function mgAdd(options) {
    return (0, schematics_1.chain)([
        (0, init_magic_metadata_rule_1.initMagicMetadata)(options),
        (0, utils_1.copyMagicFiles)(options),
        // handel app.modules.ts
        addMagicModuleToAppModule(options),
        // handel Angular.json
        updateAngularJsonWithMagicStyle(options),
        updateTsConfigAppJson(options),
        addLazyLoadProvider(),
        // handel app.component.html
        //updateAppComponentHtmlFiles       (options),
        //handel package.Json
        //addMagicDependenciesToPackageJson (options),
    ]);
}
exports.mgAdd = mgAdd;
function updateAppComponentHtmlFiles(options) {
    return (0, generate_rule_1.generate)({
        template: "./templates/angular/src/app/app.component.html.ejs",
        name: "app.component.html",
        destination: env_1.env.metadata.paths.rootMagicGenFolder,
        type: generated_file_types_enum_1.GeneratedFileTypes.HTML,
        data: {
            skipHelp: options.skipHelp
        }
    }, options);
}
function updateAngularJsonWithMagicStyle(options) {
    return (host, context) => {
        const project = env_1.env.project;
        let isDirty = false;
        let fullPathmagicStylePath = env_1.env.metadata.paths.magicStylePath;
        if (!project.architect.test.options.styles.includes(fullPathmagicStylePath)) {
            context.logger.info(`  [>]add file ${fullPathmagicStylePath} to test`);
            project.architect.test.options.styles.push(fullPathmagicStylePath);
            isDirty = true;
        }
        if (!project.architect.build.options.styles.includes(fullPathmagicStylePath)) {
            context.logger.info(`  [>]add file ${fullPathmagicStylePath} to build`);
            project.architect.build.options.styles.push(fullPathmagicStylePath);
            isDirty = true;
        }
        if (isDirty) {
            let fullPath = env_1.env.metadata.paths.angularJsonPath;
            host.overwrite(fullPath, JSON.stringify(env_1.env.workspace, null, 2));
        }
        return host;
    };
}
// Angular 10 , does not include .ts file for compilation
// So to avoid compilation error , add *.module.ts in includes section
function updateTsConfigAppJson(option) {
    return (host, context) => {
        const tsConfigPath = env_1.env.metadata.paths.tsConfigAppJsonPath;
        const tsConfig = host.read(tsConfigPath).toString("utf-8");
        // extract the comment
        let comment = tsConfig.substring(tsConfig.indexOf('/*'), tsConfig.indexOf('*/') + 2);
        // replace the comment as parsing json with comment throws exception
        var config = JSON.parse(tsConfig.replace(comment, ''));
        //Add module files for compilation
        if (!config['include'].includes('src/**/*module.ts'))
            config['include'].push('src/**/*module.ts');
        // append the comment again and write the file
        host.overwrite(tsConfigPath, comment + "\n" + JSON.stringify(config, null, 2));
        return host;
    };
}
function addMagicDependenciesToPackageJson(option) {
    return (host, context) => {
        if (!option.skipPackageJson) {
            for (let dep of env_1.dependencies) {
                (0, Util_1.LogLn)(`[>] Add dependencies ${dep.name}`);
                (0, package_1.addPackageToPackageJson)(host, 'dependencies', dep.name, dep.version);
            }
            /*
            // done in pre-install step
            for (let dep of devDependencies){
               LogLn(`[>] Add devDependencies ${dep.name}`);
               addPackageToPackageJson(host, 'devDependencies', dep.name, dep.version);
             }
             */
        }
        if (!option.skipInstall) {
            (0, Util_1.LogLn)(`[>] Install dependencies.`);
            context.addTask(new tasks_1.NodePackageInstallTask());
        }
        else {
            (0, Util_1.LogLn)(`skipIstalls ${env_1.dependencies.length} dependencies`);
            (0, Util_1.LogLn)(`skipIstalls ${env_1.devDependencies.length} devDependencies`);
        }
        return host;
    };
}
function addMagicModuleToAppModule(options) {
    return (host, context) => {
        const workspace = env_1.env.workspace;
        const project = env_1.env.project;
        (0, ast_1.addModuleImportToRootModule)(host, 'BrowserAnimationsModule', '@angular/platform-browser/animations', project);
        (0, ast_1.addModuleImportToRootModule)(host, 'ReactiveFormsModule', '@angular/forms', project);
        (0, ast_1.addModuleImportToRootModule)(host, 'MagicModule', "@magic-xpa/angular", project);
        (0, ast_1.addModuleImportToRootModule)(host, 'MagicAngularMaterialModule', "@magic-xpa/angular-material-core", project);
        (0, ast_1.addModuleImportToRootModule)(host, 'MagicGenLibModule', "./magic/magic.gen.lib.module", project);
        (0, ast_1.addModuleImportToRootModule)(host, 'MagicRoutingModule', "./app.routes", project);
    };
}
function addLazyLoadProvider() {
    return (host) => {
        const appmodule = env_1.env.metadata.paths.rootMagicGenFolder + '/app.module.ts';
        const lazyLoaderService = 'LazyLoaderService';
        const lazyLoaderServicePath = './magic/lazy-loader.service';
        let text = host.read(appmodule);
        let sourceText = text.toString('utf-8');
        let source = ts.createSourceFile(appmodule, sourceText, ts.ScriptTarget.Latest, true);
        let providerChanges = (0, ast_utils_1.addProviderToModule)(source, appmodule, '{ provide: MagicLazyLoaderService, useClass: LazyLoaderService }', lazyLoaderServicePath);
        const providerRecorder = host.beginUpdate(appmodule);
        for (const change of providerChanges) {
            if (change instanceof change_1.InsertChange) {
                if (!change.toAdd.includes('import')) // skip import change
                    providerRecorder.insertLeft(change.pos, change.toAdd);
            }
        }
        host.commitUpdate(providerRecorder);
        const lazyLoaderServiceImport = (0, ast_utils_1.insertImport)(source, appmodule, lazyLoaderService, lazyLoaderServicePath, false);
        const lazyLoaderServiceChangesRecorder = host.beginUpdate(appmodule);
        if (lazyLoaderServiceImport instanceof change_1.InsertChange)
            lazyLoaderServiceChangesRecorder.insertLeft(lazyLoaderServiceImport.pos, lazyLoaderServiceImport.toAdd);
        host.commitUpdate(lazyLoaderServiceChangesRecorder);
        // add import for MagicLazyLoaderService
        const magicLazyLoaderServiceImportChanges = (0, ast_utils_1.insertImport)(source, appmodule, 'MagicLazyLoaderService', '@magic-xpa/angular', false);
        const magicImportChangesRecorder = host.beginUpdate(appmodule);
        magicImportChangesRecorder.insertLeft(magicLazyLoaderServiceImportChanges.pos, magicLazyLoaderServiceImportChanges.toAdd);
        host.commitUpdate(magicImportChangesRecorder);
    };
}
//# sourceMappingURL=index.js.map