import { chain, Rule } from "@angular-devkit/schematics";
import { initMagicMetadata}   from "../magic-utils/rules/init-magic-metadata.rule";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";
import { generateWebModules, initGenModules } from "../magic-utils/rules/init-add-modules.rule";

export function mgGenModule(options:MagicOptionScheme): Rule {
  return chain([
    initMagicMetadata (options),

    // ** generate the modules in the project **
    initGenModules (options),
    generateWebModules(options)
  ]);
}
