"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mgGenerateComponent = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const init_magic_metadata_rule_1 = require("../magic-utils/rules/init-magic-metadata.rule");
const Util_1 = require("../magic-utils/Util");
const init_gen_components_rule_1 = require("../magic-utils/rules/init-gen-components.rule");
function mgGenerateComponent(options) {
    if (options.component == '') {
        (0, Util_1.LogLn)('Component name should not be empty.');
        return (0, schematics_1.chain)([]);
    }
    options.module = getModuleName(options);
    options.loadOnDemand = getLoadOnDemandFlagForModule(options);
    return (0, schematics_1.chain)([
        (0, init_magic_metadata_rule_1.initMagicMetadata)(options),
        (0, init_gen_components_rule_1.initAndGenComponentsForModule)(options, true, true)
    ]);
}
exports.mgGenerateComponent = mgGenerateComponent;
// To get the module name from the FormId
// In the case of containertype="Directory", consider root module.
// In all other cases gets the first string value till separator(/) from the formId.
function getModuleName(options) {
    let moduleName = "";
    if (options.containertype && options.containertype !== "Directory")
        moduleName = options.component.split('/')[0];
    return moduleName;
}
// To get loadOnDemand flag for the module
// In the case of containertype == "LoadOnDemandModule", consider it as true
// In all other cases, consider it as false
function getLoadOnDemandFlagForModule(options) {
    return options.containertype === "LoadOnDemandModule";
}
//# sourceMappingURL=index.js.map