import { chain, Rule, SchematicContext, Tree } from "@angular-devkit/schematics";
import { initMagicMetadata}   from "../magic-utils/rules/init-magic-metadata.rule";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";
import {LogLn} from "../magic-utils/Util";
import {initAndGenComponentsForModule} from "../magic-utils/rules/init-gen-components.rule";

export function mgGenerateComponent(options:MagicOptionScheme): Rule {

  if(options.component == ''){
    LogLn('Component name should not be empty.');
    return chain([]);
  }

  options.module = getModuleName(options);
  options.loadOnDemand = getLoadOnDemandFlagForModule(options);

  return chain([
    initMagicMetadata (options),
    initAndGenComponentsForModule(options, true,true)
  ]);
}

// To get the module name from the FormId
// In the case of containertype="Directory", consider root module.
// In all other cases gets the first string value till separator(/) from the formId.
function getModuleName(options: MagicOptionScheme){
  let moduleName:string = "";
  if(options.containertype && options.containertype !== "Directory")
    moduleName = options.component.split('/')[0];
  return moduleName;
}

// To get loadOnDemand flag for the module
// In the case of containertype == "LoadOnDemandModule", consider it as true
// In all other cases, consider it as false
function getLoadOnDemandFlagForModule(options: MagicOptionScheme){
   return options.containertype === "LoadOnDemandModule";
}
