"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mgInstall = void 0;
const tasks_1 = require("@angular-devkit/schematics/tasks");
const package_1 = require("../utils/package");
function mgInstall(options) {
    return (host, context) => {
        // for debug only
        // if (options.dependencies == null) {
        //   options.dependencies = [];
        //   options.dependencies.push(new Idependencies("@magic-xpa/angular", "0.0.177"));
        // }
        if (!options.skipPackageJson) {
            for (let dep of options.dependencies) {
                context.logger.info(`[>] Add dependencies ${dep.name} ${dep.version}`);
                (0, package_1.addPackageToPackageJson)(host, 'dependencies', dep.name, dep.version);
            }
            for (let dep of options.devDependencies) {
                context.logger.info(`[>] Add devDependencies ${dep.name} ${dep.version}`);
                (0, package_1.addPackageToPackageJson)(host, 'devDependencies', dep.name, dep.version);
            }
        }
        if (!options.skipInstall) {
            context.logger.info(`[>] Install dependencies.`);
            context.addTask(new tasks_1.NodePackageInstallTask());
        }
        return host;
    };
}
exports.mgInstall = mgInstall;
//# sourceMappingURL=index.js.map