import { Rule,Tree,SchematicContext } from "@angular-devkit/schematics";
import { NodePackageInstallTask, RunSchematicTask } from "@angular-devkit/schematics/tasks";
import { addPackageToPackageJson } from "../utils/package";
import { dependencies, devDependencies, Idependencies } from "../magic-utils/env";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";

export function mgInstall(options:MagicOptionScheme): Rule {
  return (host:Tree, context:SchematicContext)=>{

    // for debug only
    // if (options.dependencies == null) {
    //   options.dependencies = [];
    //   options.dependencies.push(new Idependencies("@magic-xpa/angular", "0.0.177"));
    // }

    if(!options.skipPackageJson){
      for (let dep of options.dependencies){
        context.logger.info(`[>] Add dependencies ${dep.name} ${dep.version}`);
        addPackageToPackageJson(host, 'dependencies', dep.name, dep.version);
      }
      for (let dep of options.devDependencies){
        context.logger.info(`[>] Add devDependencies ${dep.name} ${dep.version}`);
        addPackageToPackageJson(host, 'devDependencies', dep.name, dep.version);
      }
    }

    if(!options.skipInstall){
      context.logger.info(`[>] Install dependencies.`);
      context.addTask(new NodePackageInstallTask());
    }

    return host;

  };
}


